/*
 * Decompiled with CFR 0.152.
 */
package de.berlin.hu.uima.util;

import de.berlin.hu.types.PubmedDocument;
import java.util.ArrayList;
import java.util.Iterator;
import opennlp.uima.Sentence;
import org.apache.uima.analysis_component.JCasAnnotator_ImplBase;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.tcas.Annotation;
import org.uimafit.util.JCasUtil;

public class OpenNLPToUCompareSentenceConverterAE
extends JCasAnnotator_ImplBase {
    @Override
    public void process(JCas aJCas) throws AnalysisEngineProcessException {
        for (PubmedDocument document2 : JCasUtil.iterate(aJCas, PubmedDocument.class)) {
            Iterator<Sentence> sentenceIterator = JCasUtil.selectCovered(aJCas, Sentence.class, document2).iterator();
            ArrayList<Annotation> sentencesToRemove = new ArrayList<Annotation>();
            if (!sentenceIterator.hasNext()) {
                org.u_compare.shared.syntactic.Sentence ucompareSentence2 = new org.u_compare.shared.syntactic.Sentence(aJCas);
                ucompareSentence2.setBegin(0);
                ucompareSentence2.setEnd(aJCas.getDocumentText().length());
                ucompareSentence2.addToIndexes();
            }
            Annotation sentence = null;
            while (sentenceIterator.hasNext()) {
                sentence = sentenceIterator.next();
                org.u_compare.shared.syntactic.Sentence sentence2 = new org.u_compare.shared.syntactic.Sentence(aJCas);
                sentence2.setBegin(sentence.getBegin());
                sentence2.setEnd(sentence.getEnd());
                sentence2.addToIndexes();
                sentencesToRemove.add(sentence);
            }
            if (sentence != null && sentence.getEnd() < document2.getEnd() && !document2.getCoveredText().substring(sentence.getEnd() + 1 - document2.getBegin()).matches("\\s*")) {
                org.u_compare.shared.syntactic.Sentence sentence3 = new org.u_compare.shared.syntactic.Sentence(aJCas);
                sentence3.setBegin(sentence.getEnd() + 1);
                sentence3.setEnd(aJCas.getDocumentText().length());
                sentence3.addToIndexes();
            }
            for (Sentence sentence4 : sentencesToRemove) {
                sentence4.removeFromIndexes(aJCas);
            }
        }
    }
}

