/*
 * Decompiled with CFR 0.152.
 */
package de.berlin.hu.uima.cr.chemdner;

import de.berlin.hu.chemspot.Mention;
import de.berlin.hu.types.PubmedDocument;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.uima.cas.CAS;
import org.apache.uima.cas.CASException;
import org.apache.uima.collection.CollectionException;
import org.apache.uima.collection.CollectionReader_ImplBase;
import org.apache.uima.jcas.JCas;
import org.apache.uima.resource.ResourceInitializationException;
import org.apache.uima.util.Progress;
import org.u_compare.shared.semantic.NamedEntity;

public class CHEMDNERReader
extends CollectionReader_ImplBase {
    public static final String PARAM_INPUTDIR = "InputDirectory";
    private File inputDirectory = null;
    private File documentsFile = null;
    private File annotationsFile = null;
    private BufferedReader reader = null;
    private String inputLine = null;
    private Map<String, List<Mention>> docIdToAnnotations = null;
    private String abstractId = null;
    private String abstractText = null;

    @Override
    public void initialize() throws ResourceInitializationException {
        this.inputDirectory = new File((String)this.getConfigParameterValue(PARAM_INPUTDIR));
        this.documentsFile = new File(String.valueOf(this.inputDirectory.getAbsolutePath()) + "/chemdner_abstracts.txt");
        this.annotationsFile = new File(String.valueOf(this.inputDirectory.getAbsolutePath()) + "/chemdner_annotations.txt");
        try {
            if (this.annotationsFile.exists()) {
                this.reader = new BufferedReader(new FileReader(this.annotationsFile));
            }
        }
        catch (FileNotFoundException e) {
            throw new ResourceInitializationException(String.format("annotations file '%s' could not be found", this.annotationsFile.getAbsolutePath()), null, e);
        }
        String line = null;
        this.docIdToAnnotations = new HashMap<String, List<Mention>>();
        try {
            while (this.reader != null && (line = this.reader.readLine()) != null) {
                String[] data2 = line.split("\t");
                String docId = data2[0];
                String section = data2[1];
                int begin = Integer.parseInt(data2[2]);
                int end = Integer.parseInt(data2[3]);
                String text2 = data2[4];
                String type = data2[5];
                Mention mention = new Mention(begin, end, text2);
                mention.setType(type);
                mention.setSource("goldstandard");
                String key = String.valueOf(docId) + ":" + section;
                if (!this.docIdToAnnotations.containsKey(key)) {
                    this.docIdToAnnotations.put(key, new ArrayList());
                }
                this.docIdToAnnotations.get(key).add(mention);
            }
        }
        catch (IOException e) {
            throw new ResourceInitializationException(String.format("could not read annotations file '%s'", this.annotationsFile.getAbsolutePath()), null, e);
        }
        try {
            this.reader = new BufferedReader(new FileReader(this.documentsFile));
        }
        catch (FileNotFoundException e) {
            throw new ResourceInitializationException(String.format("documents file '%s' could not be found", this.documentsFile.getAbsolutePath()), null, e);
        }
    }

    @Override
    public void getNext(CAS aCAS) throws IOException, CollectionException {
        JCas jcas;
        try {
            jcas = aCAS.getJCas();
        }
        catch (CASException e) {
            throw new CollectionException(e);
        }
        String id = null;
        String text2 = null;
        String key = null;
        if (this.abstractText != null) {
            id = this.abstractId;
            text2 = this.abstractText;
            key = String.valueOf(id) + ":A";
            this.abstractId = null;
            this.abstractText = null;
        } else {
            String[] data2 = this.inputLine.split("\t");
            id = data2[0];
            text2 = data2[1];
            key = String.valueOf(id) + ":T";
            this.abstractId = id;
            this.abstractText = data2[2];
        }
        jcas.setDocumentText(text2);
        PubmedDocument pubmedDoc = new PubmedDocument(jcas);
        pubmedDoc.setBegin(0);
        pubmedDoc.setEnd(text2.length());
        pubmedDoc.setPmid(key);
        pubmedDoc.addToIndexes(jcas);
        if (this.docIdToAnnotations.containsKey(key)) {
            for (Mention mention : this.docIdToAnnotations.get(key)) {
                NamedEntity entity = new NamedEntity(jcas);
                entity.setBegin(mention.getStart());
                entity.setEnd(mention.getEnd());
                entity.setEntityType(mention.getType());
                entity.setSource("goldstandard");
                entity.setEntityType(mention.getType());
                entity.addToIndexes();
            }
        }
    }

    @Override
    public boolean hasNext() throws IOException, CollectionException {
        return this.abstractText != null || (this.inputLine = this.reader.readLine()) != null && !this.inputLine.isEmpty();
    }

    @Override
    public Progress[] getProgress() {
        return null;
    }

    @Override
    public void close() throws IOException {
    }
}

