/*
 * Decompiled with CFR 0.152.
 */
package de.berlin.hu.uima.cc.eval;

import org.apache.uima.cas.CAS;

public class ComparableAnnotation
implements Comparable<ComparableAnnotation> {
    private int begin;
    private int end;
    private String text;
    private int offset;
    private CAS cas;
    private String pmid;
    private String source;

    public static ComparableAnnotation createInstance(int begin, int end, String text2, int offset) {
        ComparableAnnotation output2 = new ComparableAnnotation();
        output2.setBegin(begin);
        output2.setEnd(end);
        output2.setText(text2);
        output2.setOffset(offset);
        return output2;
    }

    public static ComparableAnnotation createInstance(int begin, int end, String text2, int offset, CAS cas) {
        ComparableAnnotation output2 = new ComparableAnnotation();
        output2.setBegin(begin);
        output2.setEnd(end);
        output2.setText(text2);
        output2.setOffset(offset);
        output2.setCAS(cas);
        return output2;
    }

    public static ComparableAnnotation createInstance(int begin, int end, String text2, int offset, CAS cas, String pmid) {
        ComparableAnnotation output2 = new ComparableAnnotation();
        output2.setBegin(begin);
        output2.setEnd(end);
        output2.setText(text2);
        output2.setOffset(offset);
        output2.setCAS(cas);
        output2.setPMID(pmid);
        return output2;
    }

    public static ComparableAnnotation createInstance(int begin, int end, String text2, int offset, CAS cas, String pmid, String source) {
        ComparableAnnotation output2 = new ComparableAnnotation();
        output2.setBegin(begin);
        output2.setEnd(end);
        output2.setText(text2);
        output2.setOffset(offset);
        output2.setCAS(cas);
        output2.setPMID(pmid);
        output2.setSource(source);
        return output2;
    }

    @Override
    public int compareTo(ComparableAnnotation o) {
        if (this.equals(o)) {
            return 0;
        }
        if (this.begin != o.getBegin()) {
            return this.begin - o.getBegin();
        }
        return this.end - o.getEnd();
    }

    public int hashCode() {
        int prime = 31;
        int result2 = 1;
        result2 = 31 * result2 + this.begin;
        result2 = 31 * result2 + this.end;
        result2 = 31 * result2 + this.offset;
        result2 = 31 * result2 + (this.text == null ? 0 : this.text.hashCode());
        return result2;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ComparableAnnotation other = (ComparableAnnotation)obj;
        if (this.begin != other.begin) {
            return false;
        }
        if (this.end != other.end) {
            return false;
        }
        if (this.offset != other.offset) {
            return false;
        }
        return !(this.text == null ? other.text != null : !this.text.equals(other.text));
    }

    public boolean equalsOld(Object obj) {
        boolean isEndMatch;
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ComparableAnnotation other = (ComparableAnnotation)obj;
        boolean isBeginMatch = Math.abs(this.begin - other.getBegin()) <= this.offset;
        boolean bl = isEndMatch = Math.abs(this.end - other.getEnd()) <= this.offset;
        return isBeginMatch && isEndMatch;
    }

    public int getBegin() {
        return this.begin;
    }

    public void setBegin(int begin) {
        this.begin = begin;
    }

    public int getEnd() {
        return this.end;
    }

    public void setEnd(int end) {
        this.end = end;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text2) {
        this.text = text2;
    }

    public int getOffset() {
        return this.offset;
    }

    public void setOffset(int offset) {
        this.offset = offset;
    }

    public CAS getCAS() {
        return this.cas;
    }

    public void setCAS(CAS cas) {
        this.cas = cas;
    }

    public String getPMID() {
        return this.pmid;
    }

    public void setPMID(String pmid) {
        this.pmid = pmid;
    }

    public String getSource() {
        return this.source;
    }

    public void setSource(String source) {
        this.source = source;
    }
}

