/*
 * Decompiled with CFR 0.152.
 */
package de.berlin.hu.uima.ae.tagger.brics;

import de.berlin.hu.chemspot.ChemSpotConfiguration;
import de.berlin.hu.chemspot.Mention;
import de.berlin.hu.uima.ae.normalizer.Normalizer;
import de.berlin.hu.uima.ae.tagger.abbrev.ExtractAbbrev;
import de.berlin.hu.uima.ae.tagger.brics.BricsMatcher;
import de.berlin.hu.util.Constants;
import dk.brics.automaton.RunAutomaton;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Writer;
import java.net.SocketException;
import java.net.URL;
import java.net.URLConnection;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.GZIPInputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import org.apache.commons.io.IOUtils;
import org.apache.commons.net.ftp.FTPClient;

public class DictionaryUpdater {
    private static final Pattern SDF_KEY_PATTERN = Pattern.compile("^>\\s*<([^>]+)>");
    private static final Pattern DOSAGE_PATTERN = Pattern.compile("%");
    private static final Pattern SYNTACTIC_INVERSION_PATTERN = Pattern.compile("^(.+[^\\-]),\\s+(.+)$");
    private static final Pattern ABBREVIATION_PATTERN = Pattern.compile("([^\\(]+) \\(([^\\)]*)\\)");
    private static final List<String> EXCLUDE_LIST = new ArrayList<String>(Arrays.asList("not otherwise specified", "not specified", "unspecified", ", NOS", "(NOS)", "[NOS]", "deprecated", "unknown", "obsolete", "miscellaneous"));
    private static final List<String> EXCLUDE_PREFIXES = new ArrayList<String>(Arrays.asList("(rel)-", "rel-", "(rel)", "rel"));
    private static final List<String> CHEBI_KEYS = new ArrayList<String>(Arrays.asList("chebi id", "chebi name", "formulae", "inchi", "pubchem database links", "iupac names", "synonyms"));
    private static final List<String> PUBCHEM_KEYS = new ArrayList<String>(Arrays.asList("pubchem_compound_cid", "pubchem_iupac_openeye_name", "pubchem_iupac_cas_name", "pubchem_iupac_name", "pubchem_iupac_systematic_name", "pubchem_iupac_traditional_name", "pubchem_iupac_inchi", "pubchem_molecular_formula"));
    private static String dictFilePath = null;
    private static String idsFilePath = null;
    private static URL chebiSDFURL = null;
    private static boolean chebiMustContainFormula = false;
    private static URL pubchemSDFURL = null;
    private static int pubchemMaxLength = 25;
    private static ExtractAbbrev extractAbbrev = null;
    private static Set<String> filteredList = null;
    private static String outputLocation = null;
    private static File mergeLogFile = null;
    private static File conflictLogFile = null;
    private static File rewriteLogFile = null;
    private static File deletedLogFile = null;
    private static BufferedWriter rewriteLog = null;
    private static BufferedWriter deletedLog = null;

    public static void initialize() {
        try {
            InputStream in = DictionaryUpdater.class.getResourceAsStream("/resources/conf/update.cfg");
            if (in != null) {
                ChemSpotConfiguration.initialize(in, false);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        outputLocation = ChemSpotConfiguration.getUpdateOutputPath();
        chebiSDFURL = ChemSpotConfiguration.getChEBISDFUpdateURL();
        pubchemSDFURL = ChemSpotConfiguration.getPubChemSDFUpdateURL();
        dictFilePath = ChemSpotConfiguration.getDictionaryUpdatePath();
        idsFilePath = ChemSpotConfiguration.getIdsFileUpdatePath();
        chebiMustContainFormula = ChemSpotConfiguration.isChEBIUpdateMustContainFormula();
        pubchemMaxLength = ChemSpotConfiguration.getPubChemMaxLength();
        extractAbbrev = new ExtractAbbrev();
        filteredList = new HashSet<String>();
        mergeLogFile = new File(String.valueOf(outputLocation) + "mergers.log");
        conflictLogFile = new File(String.valueOf(outputLocation) + "conflicts.log");
        rewriteLogFile = new File(String.valueOf(outputLocation) + "rewritten.log");
        deletedLogFile = new File(String.valueOf(outputLocation) + "deleted.log");
    }

    public static Map<String, String[]> readIdsFile(File idsFile) throws IOException {
        Map<String, String[]> result2 = new HashMap<String, String[]>();
        System.out.print("Loading ids file... ");
        ZipFile zipFile = new ZipFile(idsFile);
        Enumeration<? extends ZipEntry> entries = zipFile.entries();
        HashMap<String, String[]> duplicates = new HashMap<String, String[]>();
        while (entries.hasMoreElements()) {
            ZipEntry entry = entries.nextElement();
            BufferedReader reader = new BufferedReader(new InputStreamReader(zipFile.getInputStream(entry)));
            String line = reader.readLine();
            while (line != null) {
                int splitAt2 = line.indexOf(9);
                String chem = line.substring(0, splitAt2).toLowerCase();
                String identifiers = line.substring(splitAt2 + 1);
                if (!result2.containsKey(chem)) {
                    result2.put(chem, identifiers.split("\t"));
                } else {
                    duplicates.put(chem, identifiers.split("\t"));
                }
                line = reader.readLine();
            }
        }
        if (!duplicates.isEmpty()) {
            System.out.println("IDs file contains duplicate entries.");
            result2 = DictionaryUpdater.mergeIDs(result2, duplicates, false);
        }
        System.out.println("Done.");
        return result2;
    }

    public static Map<String, String[]> mergeIDs(Map<String, String[]> d1, Map<String, String[]> d2, boolean overwrite) {
        int[] conflicts = new int[Constants.ChemicalID.values().length];
        int[] mergers = new int[Constants.ChemicalID.values().length];
        int exactDuplicates = 0;
        int added = 0;
        int updated2 = 0;
        Writer conflictLog = null;
        Writer mergeLog = null;
        for (String chemical : d2.keySet()) {
            if (d1.containsKey(chemical)) {
                String[] ids2;
                ++updated2;
                String[] ids1 = d1.get(chemical);
                if (ids1.length == (ids2 = d2.get(chemical)).length) {
                    if (ids1.length > ids2.length) {
                        ids2 = Arrays.copyOf(ids2, ids1.length);
                    } else {
                        ids1 = Arrays.copyOf(ids1, ids2.length);
                    }
                }
                boolean wasUpdated = false;
                String conflictLogEntry = "";
                String mergeLogEntry = "";
                int i = 0;
                while (i < Math.min(ids1.length, ids2.length) && i < Constants.ChemicalID.values().length) {
                    String chemicalId = Constants.ChemicalID.values()[i].toString();
                    if (ids2[i] != null && !ids2[i].isEmpty() && (ids1[i] == null || ids1[i].isEmpty())) {
                        mergeLogEntry = String.valueOf(mergeLogEntry) + String.format("%n  %s: %s<-%s", chemicalId, ids1[i], ids2[i]);
                        ids1[i] = ids2[i];
                        int n = i;
                        mergers[n] = mergers[n] + 1;
                        wasUpdated = true;
                    } else if (ids1[i] != null && !ids1[i].isEmpty() && (ids2[i] == null || ids2[i].isEmpty())) {
                        mergeLogEntry = String.valueOf(mergeLogEntry) + String.format("%n  %s: %s->%s", chemicalId, ids1[i], ids2[i]);
                        ids2[i] = ids1[i];
                    } else if (ids1[i] != null && ids2[i] != null && !ids1[i].equals(ids2[i])) {
                        int n = i;
                        conflicts[n] = conflicts[n] + 1;
                        mergeLogEntry = String.valueOf(mergeLogEntry) + String.format("%n  %s: %s%s%s", chemicalId, ids1[i], overwrite ? "<-" : "->", ids2[i]);
                        conflictLogEntry = String.valueOf(conflictLogEntry) + String.format("%n  %s: %s%s%s", chemicalId, ids1[i], overwrite ? "<-" : "->", ids2[i]);
                        if (overwrite) {
                            ids1[i] = ids2[i];
                        }
                        wasUpdated = true;
                    }
                    ++i;
                }
                if (wasUpdated) {
                    if (!mergeLogEntry.isEmpty()) {
                        mergeLogEntry = String.valueOf(chemical) + mergeLogEntry;
                        try {
                            if (mergeLog == null && mergeLogFile != null) {
                                mergeLog = new BufferedWriter(new FileWriter(mergeLogFile, true));
                            }
                            mergeLog.write(mergeLogEntry);
                            ((BufferedWriter)mergeLog).newLine();
                            ((BufferedWriter)mergeLog).newLine();
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                    if (conflictLogEntry.isEmpty()) continue;
                    conflictLogEntry = String.valueOf(chemical) + conflictLogEntry;
                    try {
                        if (conflictLog == null && conflictLogFile != null) {
                            conflictLog = new BufferedWriter(new FileWriter(conflictLogFile, true));
                        }
                        conflictLog.write(conflictLogEntry);
                        ((BufferedWriter)conflictLog).newLine();
                        ((BufferedWriter)conflictLog).newLine();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    continue;
                }
                ++exactDuplicates;
                continue;
            }
            if (chemical.matches("[\\w]+")) continue;
            d1.put(chemical, d2.get(chemical));
            ++added;
        }
        String report = added != 0 ? String.valueOf(added) + " entries added" : "";
        report = String.valueOf(report) + ((updated2 -= exactDuplicates) != 0 ? String.valueOf(report.isEmpty() ? "" : ", ") + updated2 + " entries updated" : "");
        if (!(report = String.valueOf(report) + (exactDuplicates != 0 ? String.valueOf(report.isEmpty() ? "" : ", ") + exactDuplicates + " exact duplicates removed" : "")).isEmpty()) {
            System.out.println("  " + report + ".");
        }
        String mergersReport = "";
        Constants.ChemicalID[] chemicalIDArray = Constants.ChemicalID.values();
        int n = chemicalIDArray.length;
        int ids2 = 0;
        while (ids2 < n) {
            Constants.ChemicalID id = chemicalIDArray[ids2];
            if (mergers[id.ordinal()] > 0) {
                mergersReport = String.valueOf(mergersReport) + (mergersReport.isEmpty() ? "" : ", ") + id.toString() + ": " + mergers[id.ordinal()];
            }
            ++ids2;
        }
        if (!mergersReport.isEmpty()) {
            System.out.println("  merged ids: " + mergersReport + ".");
        }
        String conflictsReport = "";
        Constants.ChemicalID[] chemicalIDArray2 = Constants.ChemicalID.values();
        int n2 = chemicalIDArray2.length;
        n = 0;
        while (n < n2) {
            Constants.ChemicalID id = chemicalIDArray2[n];
            if (conflicts[id.ordinal()] > 0) {
                conflictsReport = String.valueOf(conflictsReport) + (conflictsReport.isEmpty() ? "" : ", ") + id.toString() + ": " + conflicts[id.ordinal()];
            }
            ++n;
        }
        if (!conflictsReport.isEmpty()) {
            System.out.println("  conflicting ids: " + conflictsReport + ".");
            System.out.println("  conflicting ids were " + (overwrite ? "" : "not ") + "overwritten.");
        }
        if (mergeLog != null) {
            try {
                ((BufferedWriter)mergeLog).close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (conflictLog != null) {
            try {
                ((BufferedWriter)conflictLog).close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return d1;
    }

    public static File downloadFile(URL url, File outputLocation) throws IOException {
        System.out.print("Downloading file from: " + url.toString() + "... ");
        URLConnection connection = url.openConnection();
        String dateStamp = new SimpleDateFormat("yyyy-MM-dd").format(new Date());
        outputLocation = new File(outputLocation.toString().replaceAll("((\\.\\w{1,5})+)$", "-" + dateStamp + "$1"));
        outputLocation.getParentFile().mkdirs();
        if (outputLocation.exists()) {
            System.out.println("File already exists.");
            return outputLocation;
        }
        FileOutputStream outputStream = new FileOutputStream(outputLocation);
        IOUtils.copy(connection.getInputStream(), (OutputStream)outputStream);
        outputStream.close();
        System.out.println("Done.");
        return outputLocation;
    }

    public static List<Map<String, String>> readSDFFile(File pathToFile) throws IOException {
        ArrayList<Map<String, String>> result2 = new ArrayList<Map<String, String>>();
        System.out.print("Reading SDF file: " + pathToFile + "... ");
        InputStream inputStream = new FileInputStream(pathToFile);
        if (pathToFile.getName().endsWith(".gz")) {
            inputStream = new GZIPInputStream(inputStream);
        }
        BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));
        String line = null;
        HashMap<String, String> data2 = new HashMap<String, String>();
        while ((line = reader.readLine()) != null) {
            String key;
            Matcher m;
            if (line.startsWith("$$$$")) {
                result2.add(data2);
                data2 = new HashMap();
            }
            if (!line.startsWith(">") || !(m = SDF_KEY_PATTERN.matcher(line)).matches() || !CHEBI_KEYS.contains(key = m.group(1).toLowerCase()) && !PUBCHEM_KEYS.contains(key)) continue;
            String value2 = "";
            while ((line = reader.readLine()) != null && !line.isEmpty() && !line.startsWith("$$$$")) {
                if (!value2.isEmpty()) {
                    value2 = String.valueOf(value2) + "|";
                }
                value2 = String.valueOf(value2) + line.trim();
            }
            data2.put(key, value2);
        }
        result2.add(data2);
        reader.close();
        System.out.println("Done.");
        System.out.println("  " + result2.size() + " entries loaded.");
        return result2;
    }

    public static Map<String, String[]> convertChEBISDFToDict(List<Map<String, String>> chebiSDF) {
        HashMap<String, String[]> result2 = new HashMap<String, String[]>();
        System.out.print("Converting ChEBI SDF data to dictionary format... ");
        for (Map<String, String> data2 : chebiSDF) {
            int n;
            int n2;
            String[] stringArray;
            if (!data2.containsKey("chebi id") || !data2.containsKey("chebi name")) continue;
            String chebId = data2.get("chebi id").replace("CHEBI:", "");
            String name = data2.get("chebi name").toLowerCase();
            if (chebiMustContainFormula && (!data2.containsKey("formulae") || data2.get("formulae") == null || data2.get("formulae").isEmpty() || data2.get("formulae").length() <= 2)) {
                filteredList.add(name);
                try {
                    DictionaryUpdater.appendToFilterLog(name);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                continue;
            }
            String[] ids = new String[Constants.ChemicalID.values().length];
            ids[Constants.ChemicalID.CHEB.ordinal()] = chebId;
            if (data2.containsKey("inchi")) {
                ids[Constants.ChemicalID.INCH.ordinal()] = data2.get("inchi");
            }
            if (data2.containsKey("pubchem database links")) {
                ids[Constants.ChemicalID.PUBC.ordinal()] = data2.get("pubchem database links").split("\\|")[0];
            }
            result2.put(name, ids);
            if (data2.containsKey("iupac names")) {
                stringArray = data2.get("iupac names").split("\\|");
                n2 = stringArray.length;
                n = 0;
                while (n < n2) {
                    String iupacName = stringArray[n];
                    result2.put(iupacName.toLowerCase(), ids);
                    ++n;
                }
            }
            if (!data2.containsKey("synonyms")) continue;
            stringArray = data2.get("synonyms").split("\\|");
            n2 = stringArray.length;
            n = 0;
            while (n < n2) {
                String synonym = stringArray[n];
                if (synonym.length() > 10 && !synonym.toLowerCase().matches("[\\w ]+")) {
                    result2.put(synonym.toLowerCase(), ids);
                }
                ++n;
            }
        }
        try {
            DictionaryUpdater.appendToFilterLog(String.format("%n%n%n%n%n", new Object[0]));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        System.out.println("Done.");
        System.out.println("  " + result2.size() + " chemicals successfully converted.");
        return result2;
    }

    public static Map<String, String[]> convertPubChemSDFToDict(List<Map<String, String>> pubchemSDF) {
        HashMap<String, String[]> result2 = new HashMap<String, String[]>();
        System.out.print("Converting PubChem SDF data to dictionary format... ");
        for (Map<String, String> data2 : pubchemSDF) {
            String pubchemCompoundId = data2.get("pubchem_compound_cid");
            String name = data2.get("pubchem_iupac_name");
            HashSet<String> names = new HashSet<String>();
            names.add(data2.get("pubchem_iupac_openeye_name"));
            names.add(data2.get("pubchem_iupac_cas_name"));
            names.add(data2.get("pubchem_iupac_systematic_name"));
            names.add(data2.get("pubchem_iupac_traditional_name"));
            if (name == null && !names.isEmpty()) {
                name = (String)names.iterator().next();
            }
            names.remove(name);
            if (pubchemCompoundId == null || name == null) continue;
            if (!data2.containsKey("pubchem_molecular_formula") || data2.get("pubchem_molecular_formula") == null || data2.get("pubchem_molecular_formula").isEmpty() || data2.get("pubchem_molecular_formula").length() <= 2) {
                filteredList.add(name);
                try {
                    DictionaryUpdater.appendToFilterLog(name);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                continue;
            }
            String[] ids = new String[Constants.ChemicalID.values().length];
            ids[Constants.ChemicalID.PUBC.ordinal()] = pubchemCompoundId;
            if (data2.containsKey("pubchem_iupac_inchi")) {
                ids[Constants.ChemicalID.INCH.ordinal()] = data2.get("pubchem_iupac_inchi");
            }
            for (String otherName : names) {
                if (otherName == null) continue;
                result2.put(otherName, ids);
            }
            result2.put(name, ids);
        }
        try {
            DictionaryUpdater.appendToFilterLog(String.format("%n%n%n%n%n", new Object[0]));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        System.out.println("Done.");
        System.out.println("  " + result2.size() + " chemicals successfully converted.");
        return result2;
    }

    public static void appendToFilterLog(String s) throws IOException {
        if (deletedLog == null) {
            deletedLog = new BufferedWriter(new FileWriter(deletedLogFile, true));
        }
        deletedLog.write(s);
        deletedLog.newLine();
    }

    public static boolean isFilter(String chemical) {
        boolean result2 = false;
        result2 = result2 || chemical == null || chemical.isEmpty();
        result2 = result2 || chemical.length() < 3;
        result2 = result2 || DOSAGE_PATTERN.matcher(chemical).find();
        result2 = result2 || chemical.indexOf(64) != -1;
        for (String excludeString : EXCLUDE_LIST) {
            boolean bl = result2 = result2 || chemical.contains(excludeString);
        }
        if (!result2 && filteredList.contains(chemical)) {
            result2 = true;
        }
        if (result2) {
            try {
                if (!filteredList.contains(chemical)) {
                    filteredList.add(chemical);
                }
                DictionaryUpdater.appendToFilterLog(chemical);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return result2;
    }

    public static String rewriteChemical(String chemical) {
        String s2;
        String s1;
        Matcher m = SYNTACTIC_INVERSION_PATTERN.matcher(chemical = chemical.replace("'s ", " "));
        if (m.matches()) {
            s1 = m.group(1).trim();
            s2 = m.group(2).trim();
            if (!EXCLUDE_PREFIXES.contains(s2.toLowerCase())) {
                s1 = DictionaryUpdater.rewriteChemical(s1);
                s2 = DictionaryUpdater.rewriteChemical(s2);
                chemical = String.valueOf(s2) + (s2.endsWith("-") ? "" : " ") + s1 + "<SPLIT>" + s1;
            } else {
                chemical = s1 = DictionaryUpdater.rewriteChemical(s1);
            }
        }
        if ((m = ABBREVIATION_PATTERN.matcher(chemical)).matches()) {
            s1 = null;
            s2 = null;
            List<Mention> abbreviations = extractAbbrev.getMentions(chemical);
            if (!abbreviations.isEmpty()) {
                s1 = abbreviations.get(0).getCHID();
                s2 = abbreviations.get(0).getText();
            } else {
                s1 = m.group(1);
            }
            chemical = s2 != null ? String.valueOf(chemical) + "<SPLIT>" + s1 + "<SPLIT>" + s2 : String.valueOf(chemical) + "<SPLIT>" + s1;
        }
        return chemical;
    }

    public static void appendToRewrittenLog(String s) throws IOException {
        if (rewriteLog == null) {
            rewriteLog = new BufferedWriter(new FileWriter(rewriteLogFile, true));
        }
        rewriteLog.write(s);
        rewriteLog.newLine();
    }

    public static Map<String, String[]> processChemicals(Map<String, String[]> chemicals) {
        HashMap<String, String[]> result2 = new HashMap<String, String[]>();
        int processed = 0;
        int filtered = 0;
        int rewritten = 0;
        System.out.print("Processing chemicals... ");
        HashMap<String, String[]> toBeMerged = new HashMap<String, String[]>();
        for (String chemical : chemicals.keySet()) {
            block11: {
                if (!DictionaryUpdater.isFilter(chemical)) {
                    String rewrittenChemical = DictionaryUpdater.rewriteChemical(chemical);
                    if (!chemical.equals(rewrittenChemical)) {
                        ++rewritten;
                        try {
                            if (rewrittenChemical.contains("<SPLIT>")) {
                                String[] split2 = rewrittenChemical.split("<SPLIT>");
                                toBeMerged.put(split2[0].trim(), chemicals.get(chemical));
                                String logEntry = "'" + split2[0].trim() + "'";
                                int i = 1;
                                while (i < split2.length) {
                                    toBeMerged.put(rewrittenChemical, chemicals.get(chemical));
                                    logEntry = String.valueOf(logEntry) + " and '" + split2[i].trim() + "'";
                                    ++i;
                                }
                                DictionaryUpdater.appendToRewrittenLog(String.format("%s -> %s", chemical, logEntry));
                                rewritten += split2.length - 1;
                                break block11;
                            }
                            toBeMerged.put(rewrittenChemical, chemicals.get(chemical));
                            DictionaryUpdater.appendToRewrittenLog(String.format("%s -> %s", chemical, rewrittenChemical));
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    } else {
                        result2.put(rewrittenChemical, chemicals.get(chemical));
                    }
                } else {
                    ++filtered;
                }
            }
            ++processed;
        }
        System.out.println("Done.");
        System.out.printf("  %d chemicals processed, %d filtered, %d rewritten.%n", result2.size(), filtered, rewritten);
        if (!toBeMerged.isEmpty()) {
            System.out.println("Merging rewritten chemicals...");
            for (String chemical : new ArrayList(toBeMerged.keySet())) {
                if (!DictionaryUpdater.isFilter(chemical)) continue;
                toBeMerged.remove(chemical);
            }
            DictionaryUpdater.mergeIDs(result2, toBeMerged, false);
            System.out.println("Done.");
        }
        return result2;
    }

    public static void writeIdsFile(Map<String, String[]> ids, File outputFile) throws IOException {
        outputFile.getParentFile().mkdirs();
        BufferedWriter writer = new BufferedWriter(new FileWriter(outputFile));
        System.out.print("Writing ids file to '" + outputFile + "'... ");
        for (String chem : ids.keySet()) {
            String[] chemIds = ids.get(chem);
            String idString = "";
            Constants.ChemicalID[] chemicalIDArray = Constants.ChemicalID.values();
            int n = chemicalIDArray.length;
            int n2 = 0;
            while (n2 < n) {
                Constants.ChemicalID type = chemicalIDArray[n2];
                String id = "";
                if (type.ordinal() < chemIds.length && (id = chemIds[type.ordinal()]) == null) {
                    id = "";
                }
                idString = String.valueOf(idString) + "\t" + id;
                ++n2;
            }
            writer.write(String.valueOf(chem) + idString);
            writer.newLine();
        }
        writer.close();
        System.out.println("Done.");
    }

    public static List<File> writeAutomata(Collection<String> chemicals, String outputLocation, String prefix) throws FileNotFoundException, IOException {
        int i;
        ArrayList<File> automataFiles = new ArrayList<File>();
        ArrayList batches = new ArrayList();
        Iterator<String> chemical = chemicals.iterator();
        int batchSize = 100000;
        while (chemical.hasNext()) {
            i = 0;
            ArrayList<String> arrayList = new ArrayList<String>();
            while (i < batchSize && chemical.hasNext()) {
                arrayList.add(chemical.next());
                ++i;
            }
            batches.add(arrayList);
        }
        i = 1;
        for (Collection collection : batches) {
            System.out.printf("\rCreating dictionary automata... %d / %d", i, batches.size());
            RunAutomaton runAutomaton = BricsMatcher.createAutomaton(collection);
            File outputFile = new File(String.valueOf(outputLocation) + prefix + "_" + i++ + ".atm");
            FileOutputStream s = new FileOutputStream(outputFile);
            runAutomaton.store(s);
            ((OutputStream)s).close();
            automataFiles.add(outputFile);
        }
        System.out.printf("\rCreating dictionary automata... Done.%n", i, batches.size());
        return automataFiles;
    }

    public static File writeAutomaton(Collection<String> chemicals, File outputFile) throws FileNotFoundException, IOException {
        System.out.print("Writing chemical automaton to '" + outputFile + "'");
        System.out.print(".");
        RunAutomaton runAutomaton = BricsMatcher.createAutomaton(chemicals);
        System.out.print(".");
        outputFile.getParentFile().mkdirs();
        FileOutputStream s = new FileOutputStream(outputFile);
        runAutomaton.store(s);
        ((OutputStream)s).close();
        System.out.print(".");
        System.out.println(" Done.");
        return outputFile;
    }

    public static Map<String, String[]> getChebi(URL url) {
        List<Map<String, String>> sdfData;
        System.out.println();
        System.out.println("--- Generating ChEBI Update ---");
        File outputLocation = new File(String.valueOf(DictionaryUpdater.outputLocation) + url.getFile().replaceAll(".*/", ""));
        try {
            outputLocation = DictionaryUpdater.downloadFile(url, outputLocation);
        }
        catch (IOException e) {
            System.err.println("Could not download ChEBI SDF file from " + url.toString());
            e.printStackTrace();
            return null;
        }
        try {
            sdfData = DictionaryUpdater.readSDFFile(outputLocation);
        }
        catch (IOException e) {
            System.err.println("Could not read SDF file from " + outputLocation);
            e.printStackTrace();
            return null;
        }
        Map<String, String[]> ids = DictionaryUpdater.convertChEBISDFToDict(sdfData);
        return ids;
    }

    /*
     * Unable to fully structure code
     */
    public static List<File> downloadFilesFromFTP(URL url, String outputLocation) throws SocketException, IOException {
        result = new ArrayList<File>();
        client = new FTPClient();
        client.connect(url.getHost());
        client.login("anonymous", "");
        client.changeWorkingDirectory(url.getPath());
        client.setFileType(2);
        client.setBufferSize(1024);
        client.enterLocalPassiveMode();
        System.out.println("Downloading files from " + url.toString() + "...");
        files = client.listFiles();
        i = 0;
        var9_6 = files;
        var8_7 = files.length;
        var7_8 = 0;
        while (var7_8 < var8_7) {
            block3: {
                file = var9_6[var7_8];
                if (!file.getName().endsWith(".sdf") && !file.getName().endsWith(".sdf.gz")) break block3;
                outputFile = new File(String.valueOf(outputLocation) + "/" + file.getName());
                if (!outputFile.exists()) ** GOTO lbl30
                System.out.printf("\r%.2f%% File %s already exists. ", new Object[]{(double)Math.round((double)i / (double)files.length * 10000.0) / 100.0, file.getName()});
                if (outputFile.length() == file.getSize()) {
                    System.out.print("Files are identical. Skipping.");
                    ++i;
                } else {
                    System.out.print("Files are different. Redownloading.");
lbl30:
                    // 2 sources

                    start = System.currentTimeMillis();
                    out = new FileOutputStream(outputFile);
                    client.retrieveFile(file.getName(), out);
                    out.close();
                    end = System.currentTimeMillis();
                    System.out.printf("\r%.2f%% @ %d kB/s", new Object[]{(double)Math.round((double)i++ / (double)files.length * 10000.0) / 100.0, Math.round((double)outputFile.length() / (double)(end - start))});
                    result.add(outputFile);
                }
            }
            ++var7_8;
        }
        client.logout();
        client.disconnect();
        System.out.println("\nDone.");
        return result;
    }

    public static Map<String, String[]> getPubChem(URL url) throws SocketException, IOException {
        System.out.println();
        System.out.println("--- Generating PubChem Update ---");
        File pubchemOutputLocation = new File(String.valueOf(outputLocation) + "pubchem/");
        pubchemOutputLocation.mkdirs();
        List<File> downloadedFiles = DictionaryUpdater.downloadFilesFromFTP(url, pubchemOutputLocation.getAbsolutePath());
        downloadedFiles = new ArrayList<File>();
        ArrayList<File> idsFiles = new ArrayList<File>();
        File[] fileArray = pubchemOutputLocation.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            if (file.getName().endsWith(".sdf") || file.getName().endsWith(".sdf.gz")) {
                List<Map<String, String>> sdfData = null;
                File idsFile = new File(file.getAbsolutePath().replaceAll("(\\.[^/\\\\]+)+$", ".map"));
                if (downloadedFiles.contains(file.getAbsoluteFile()) && idsFile.exists()) {
                    System.out.printf("Deleting old ids file %s because a new version has been downloaded%n", idsFile.getName());
                    idsFile.delete();
                }
                if (!idsFile.exists()) {
                    try {
                        sdfData = DictionaryUpdater.readSDFFile(file);
                        DictionaryUpdater.writeIdsFile(DictionaryUpdater.convertPubChemSDFToDict(sdfData), idsFile);
                    }
                    catch (IOException e) {
                        System.err.println("Could not read SDF file from " + outputLocation);
                        e.printStackTrace();
                    }
                } else {
                    System.out.printf("Skipping %s because an ids file already exists%n", file.getName());
                }
                idsFiles.add(idsFile);
            }
            ++n2;
        }
        HashMap<String, String[]> ids = new HashMap<String, String[]>();
        for (File idsFile : idsFiles) {
            System.out.println("Loading file " + idsFile.getName());
            Map<String, String[]> loadedIds = Normalizer.loadIdsFromFile(idsFile.getAbsolutePath());
            int filteredCount = 0;
            for (String chemical : new ArrayList<String>(loadedIds.keySet())) {
                if (chemical.length() <= pubchemMaxLength) continue;
                loadedIds.remove(chemical);
                ++filteredCount;
            }
            DictionaryUpdater.mergeIDs(ids, loadedIds, false);
            if (filteredCount <= 0) continue;
            System.out.printf("  %d filtered (length > %d)%n", filteredCount, pubchemMaxLength);
        }
        return ids;
    }

    public static void updateDictionaryFile(File dictionaryFile, List<File> newAutomatonFiles) throws IOException {
        ZipFile zipFile = new ZipFile(dictionaryFile);
        ZipOutputStream out = new ZipOutputStream(new FileOutputStream(String.valueOf(outputLocation) + "dict.zip"));
        ArrayList<String> newAutomatonNames = new ArrayList<String>();
        for (File automatonFile : newAutomatonFiles) {
            newAutomatonNames.add(automatonFile.getName());
        }
        Enumeration<? extends ZipEntry> entries = zipFile.entries();
        while (entries.hasMoreElements()) {
            ZipEntry entry = entries.nextElement();
            if (newAutomatonNames.contains(entry.getName())) continue;
            InputStream in = zipFile.getInputStream(entry);
            out.putNextEntry(new ZipEntry(entry.getName()));
            IOUtils.copy(in, (OutputStream)out);
            in.close();
        }
        zipFile.close();
        for (File newAutomatonFile : newAutomatonFiles) {
            FileInputStream in = new FileInputStream(newAutomatonFile);
            out.putNextEntry(new ZipEntry(newAutomatonFile.getName()));
            IOUtils.copy((InputStream)in, (OutputStream)out);
            ((InputStream)in).close();
        }
        out.close();
    }

    public static void update(File dictionaryFile, File idsFile) throws FileNotFoundException, IOException {
        Map<String, String[]> chemicals;
        HashMap<String, String[]> update2 = new HashMap<String, String[]>();
        ArrayList<File> automatonFiles = new ArrayList<File>();
        if (!new File(outputLocation).exists()) {
            new File(outputLocation).mkdir();
        }
        if (mergeLogFile.exists()) {
            mergeLogFile.delete();
        }
        if (conflictLogFile.exists()) {
            conflictLogFile.delete();
        }
        if (rewriteLogFile.exists()) {
            rewriteLogFile.delete();
        }
        if (deletedLogFile.exists()) {
            deletedLogFile.delete();
        }
        if (ChemSpotConfiguration.isUpdate("chebi")) {
            chemicals = DictionaryUpdater.getChebi(chebiSDFURL);
            chemicals = DictionaryUpdater.processChemicals(chemicals);
            DictionaryUpdater.writeIdsFile(chemicals, new File(String.valueOf(outputLocation) + "chebi.map"));
            automatonFiles.add(DictionaryUpdater.writeAutomaton(chemicals.keySet(), new File(String.valueOf(outputLocation) + "chebi_updated.atm")));
            DictionaryUpdater.mergeIDs(update2, chemicals, false);
        }
        if (ChemSpotConfiguration.isUpdate("pubchem")) {
            chemicals = DictionaryUpdater.getPubChem(pubchemSDFURL);
            chemicals = DictionaryUpdater.processChemicals(chemicals);
            DictionaryUpdater.writeIdsFile(chemicals, new File(String.valueOf(outputLocation) + "pubchem.map"));
            automatonFiles.addAll(DictionaryUpdater.writeAutomata(chemicals.keySet(), outputLocation, "pubchem_updated"));
            DictionaryUpdater.mergeIDs(update2, chemicals, false);
        }
        Map<String, String[]> ids = null;
        if (idsFile != null) {
            if (!idsFile.exists()) {
                System.out.println("IDs file at '" + idsFile.getPath() + "' does not exist");
            } else {
                System.out.println();
                System.out.println("--- Loading IDs ---");
                ids = DictionaryUpdater.readIdsFile(idsFile);
                ids = DictionaryUpdater.processChemicals(ids);
            }
        }
        if (ids != null && !update2.isEmpty()) {
            System.out.println();
            System.out.println("--- Updating IDs ---");
            System.out.println("Merging ids into dictionary...");
            ids = DictionaryUpdater.mergeIDs(ids, update2, true);
            System.out.println("Done.");
            if (rewriteLog != null) {
                rewriteLog.close();
            }
            if (deletedLog != null) {
                deletedLog.close();
            }
            System.out.print("Writing ids to '" + outputLocation + "ids.zip'... ");
            Normalizer.writeIDs(String.valueOf(outputLocation) + "ids.map", ids);
            FileInputStream in = new FileInputStream(String.valueOf(outputLocation) + "ids.map");
            ZipOutputStream out = new ZipOutputStream(new FileOutputStream(String.valueOf(outputLocation) + "ids.zip"));
            out.putNextEntry(new ZipEntry("ids.map"));
            IOUtils.copy((InputStream)in, (OutputStream)out);
            in.close();
            out.close();
            System.out.println("Done.");
        }
        ids = null;
        if (dictionaryFile != null && !automatonFiles.isEmpty()) {
            System.out.println();
            System.out.println("--- Updating Dictionary ---");
            System.out.print("Writing dictionary to '" + outputLocation + "dict.zip'... ");
            DictionaryUpdater.updateDictionaryFile(dictionaryFile, automatonFiles);
            System.out.println("Done.");
        }
    }

    public static void updateFiles(File dictionaryFile, File idsFile, boolean removeTemporaryFiles) throws FileNotFoundException, IOException {
        int i;
        String oldFilePath;
        File newDictFile = new File(String.valueOf(outputLocation) + "dict.zip");
        File newIdsFile = new File(String.valueOf(outputLocation) + "ids.zip");
        String extensionPattern = "(\\.[^\\./\\\\]+)+$";
        DictionaryUpdater.update(dictionaryFile, idsFile);
        System.out.println();
        if (newDictFile.exists() && dictionaryFile.exists()) {
            oldFilePath = dictionaryFile.getPath().replaceAll(extensionPattern, "-old$1");
            i = 2;
            while (new File(oldFilePath).exists()) {
                oldFilePath = dictionaryFile.getPath().replaceAll(extensionPattern, "-old" + i++ + "$1");
            }
            System.out.printf("Renaming '%s' to '%s'%n", dictionaryFile, oldFilePath);
            if (dictionaryFile.renameTo(new File(oldFilePath))) {
                System.out.printf("Moving '%s' to '%s'%n", newDictFile, dictionaryFile);
                if (!newDictFile.renameTo(dictionaryFile)) {
                    System.out.printf("Could not move '%s' to '%s'%n", newDictFile, dictionaryFile);
                }
            } else {
                System.out.printf("Could not rename '%s' to '%s'%n", dictionaryFile, oldFilePath);
            }
        }
        if (newIdsFile.exists() && idsFile.exists()) {
            oldFilePath = idsFile.getPath().replaceAll(extensionPattern, "-old$1");
            i = 2;
            while (new File(oldFilePath).exists()) {
                oldFilePath = idsFile.getPath().replaceAll(extensionPattern, "-old" + i + "$1");
            }
            System.out.printf("Renaming '%s' to '%s'%n", idsFile, oldFilePath);
            if (idsFile.renameTo(new File(oldFilePath))) {
                System.out.printf("Moving '%s' to '%s'%n", newIdsFile, idsFile);
                if (!newIdsFile.renameTo(idsFile)) {
                    System.out.printf("Could not move '%s' to '%s'%n", newIdsFile, idsFile);
                }
            } else {
                System.out.printf("Could not rename '%s' to '%s'%n", idsFile, oldFilePath);
            }
        }
        if (removeTemporaryFiles) {
            System.out.println("Removing temporary files");
            DictionaryUpdater.removeDir(outputLocation);
        }
    }

    public static void removeDir(String dir2) {
        File outputDir = new File(outputLocation);
        File[] fileArray = outputDir.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            if (file.isFile()) {
                file.delete();
            } else if (file.isDirectory()) {
                DictionaryUpdater.removeDir(file.getAbsolutePath());
            }
            ++n2;
        }
        outputDir.delete();
    }

    public static void main(String[] args) throws FileNotFoundException, IOException {
        ChemSpotConfiguration.initialize();
        DictionaryUpdater.initialize();
        DictionaryUpdater.update(new File(dictFilePath), new File(idsFilePath));
    }
}

