/*
 * Decompiled with CFR 0.152.
 */
package de.berlin.hu.uima.ae.tagger.brics;

import de.berlin.hu.chemspot.Mention;
import de.berlin.hu.uima.ae.normalizer.Normalizer;
import de.berlin.hu.uima.ae.tagger.brics.BricsMatcher;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Set;
import org.apache.uima.UimaContext;
import org.apache.uima.analysis_component.JCasAnnotator_ImplBase;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.cas.TOP;
import org.apache.uima.jcas.tcas.Annotation;
import org.apache.uima.resource.ResourceInitializationException;
import org.u_compare.shared.semantic.Chemical;
import org.uimafit.util.JCasUtil;

public class BricsTagger
extends JCasAnnotator_ImplBase {
    public static final String PATH_TO_DICTIONARY = "DrugBankMatcherDictionaryAutomat";
    public static final String IDS = "Ids";
    private Set<String> suffixes;
    private BricsMatcher matcher;

    @Override
    public void initialize(UimaContext aContext) throws ResourceInitializationException {
        super.initialize(aContext);
        this.suffixes = new HashSet<String>();
        if (aContext.getConfigParameterValue(PATH_TO_DICTIONARY) != null && !aContext.getConfigParameterValue(PATH_TO_DICTIONARY).toString().isEmpty()) {
            try {
                BufferedReader reader = new BufferedReader(new InputStreamReader(this.getClass().getClassLoader().getResourceAsStream("resources/suffixes.txt")));
                String line = reader.readLine();
                while (line != null) {
                    this.suffixes.add(line);
                    line = reader.readLine();
                }
                this.matcher = new BricsMatcher(aContext.getConfigParameterValue(PATH_TO_DICTIONARY).toString());
            }
            catch (FileNotFoundException e) {
                throw new ResourceInitializationException(e);
            }
            catch (IOException e) {
                throw new ResourceInitializationException(e);
            }
            catch (ClassNotFoundException e) {
                throw new ResourceInitializationException(e);
            }
        }
        if (Normalizer.getIds() != null) {
            try {
                this.matcher = new BricsMatcher();
            }
            catch (IOException e) {
                throw new ResourceInitializationException(e);
            }
            catch (ClassNotFoundException e) {
                throw new ResourceInitializationException(e);
            }
        }
    }

    @Override
    public void process(JCas aJCas) throws AnalysisEngineProcessException {
        ArrayList<Object> matches2;
        String docText;
        block11: {
            docText = aJCas.getDocumentText();
            matches2 = new ArrayList();
            try {
                long start = System.currentTimeMillis();
                matches2 = new ArrayList<Mention>(this.matcher.match(docText));
                long time = System.currentTimeMillis() - start;
            }
            catch (Error e) {
                throw new AnalysisEngineProcessException(e);
            }
            catch (IllegalStateException e) {
                if (e.toString().contains("Automaton matched the empty string")) break block11;
                throw new AnalysisEngineProcessException(e);
            }
        }
        Comparator<Mention> comp = new Comparator<Mention>(){

            @Override
            public int compare(Mention m1, Mention m2) {
                return m1.getStart() - m2.getStart();
            }
        };
        Collections.sort(matches2, comp);
        Mention lastMention = null;
        TOP lastDrug = null;
        for (Mention mention : matches2) {
            int begin = mention.getStart();
            int end = mention.getEnd();
            String string2 = "";
            if (this.filter(mention)) continue;
            if (!this.overlaps(lastMention, mention)) {
                if (this.overlaps(mention, lastMention)) {
                    lastDrug.removeFromIndexes();
                    lastMention = null;
                }
                lastDrug = this.processMention(aJCas, docText, (Chemical)lastDrug, begin, end, string2);
            }
            lastMention = mention;
        }
        Comparator<Chemical> comparator = new Comparator<Chemical>(){

            @Override
            public int compare(Chemical m1, Chemical m2) {
                return m1.getBegin() - m2.getBegin();
            }
        };
        ArrayList<Chemical> entities = new ArrayList<Chemical>(JCasUtil.select(aJCas, Chemical.class));
        Collections.sort(entities, comparator);
        ArrayList<Annotation> chemicalsToRemove = new ArrayList<Annotation>();
        Annotation lastChemical = null;
        for (Chemical chemical : entities) {
            if (!"dictionary".equals(chemical.getSource())) continue;
            if (lastChemical != null && (lastChemical.getBegin() <= chemical.getBegin() && chemical.getEnd() <= lastChemical.getEnd() || lastChemical.getBegin() <= chemical.getBegin() && chemical.getBegin() <= lastChemical.getEnd())) {
                if (lastChemical.getCoveredText().length() > chemical.getCoveredText().length()) {
                    chemicalsToRemove.add(chemical);
                } else {
                    chemicalsToRemove.add(lastChemical);
                }
            }
            lastChemical = chemical;
        }
        for (Chemical chemical : chemicalsToRemove) {
            chemical.removeFromIndexes(aJCas);
        }
    }

    private Chemical processMention(JCas aJCas, String docText, Chemical lastDrug, int begin, int end, String id) {
        boolean borderHasChanged;
        int originalBegin = begin;
        int originalEnd = end;
        boolean matchExpansion = false;
        if (matchExpansion) {
            begin = this.findLeftBorder(docText, begin);
            end = this.findRightBorder(docText, end);
        }
        if (String.valueOf(docText.charAt(end - 1)).matches("[.,;:]")) {
            --end;
        }
        if (docText.charAt(end - 1) == '(') {
            --end;
        }
        if (docText.charAt(end - 1) == '[') {
            --end;
        }
        if (docText.charAt(begin) == ')') {
            ++begin;
        }
        if (docText.charAt(begin) == ']') {
            ++begin;
        }
        if (docText.charAt(begin) == '(' && docText.charAt(end - 1) == ')') {
            ++begin;
            --end;
        }
        if (docText.charAt(begin) == '[' && docText.charAt(end - 1) == ']') {
            ++begin;
            --end;
        }
        int stack = 0;
        int i = begin;
        while (i < end) {
            char c = docText.charAt(i);
            if (c == '(') {
                ++stack;
            } else if (c == ')') {
                --stack;
            }
            ++i;
        }
        if (stack > 0 && docText.charAt(begin) == '(') {
            ++begin;
        }
        if (stack < 0 && docText.charAt(end - 1) == ')') {
            --end;
        }
        int stack2 = 0;
        int i2 = begin;
        while (i2 < end) {
            char c = docText.charAt(i2);
            if (c == '[') {
                ++stack2;
            } else if (c == ']') {
                --stack2;
            }
            ++i2;
        }
        if (stack2 > 0 && docText.charAt(begin) == '[') {
            ++begin;
        }
        if (stack2 < 0 && docText.charAt(end - 1) == ']') {
            --end;
        }
        String mentionText = docText.substring(begin, end);
        for (String suffix : this.suffixes) {
            if (!mentionText.endsWith(suffix)) continue;
            end -= suffix.length();
            break;
        }
        boolean bl = borderHasChanged = originalBegin != begin || originalEnd != end;
        if (lastDrug == null || lastDrug.getBegin() != begin) {
            lastDrug = this.createDrugAnnotation(aJCas, begin, end, id, borderHasChanged);
        }
        return lastDrug;
    }

    private Chemical createDrugAnnotation(JCas aJCas, int begin, int end, String id, boolean borderHasChanged) {
        Chemical drug = new Chemical(aJCas);
        drug.setBegin(begin);
        drug.setEnd(end);
        drug.setId("");
        drug.setSource("dictionary");
        drug.addToIndexes();
        return drug;
    }

    private int findRightBorder(String docText, int end) {
        int i = end;
        while (i < docText.length()) {
            if (docText.charAt(i) == ' ' || docText.charAt(i) == '\n' || docText.charAt(i) == '\r' || docText.charAt(i) == '\t') {
                return i;
            }
            ++i;
        }
        return docText.length();
    }

    private int findLeftBorder(String docText, int begin) {
        int i = begin;
        while (i > 0) {
            if (docText.charAt(i) == ' ' || docText.charAt(i) == '\n' || docText.charAt(i) == '\r' || docText.charAt(i) == '\t') {
                return i + 1;
            }
            --i;
        }
        return 0;
    }

    private boolean filter(Mention mention) {
        if (mention.getEnd() - mention.getStart() < 3) {
            return true;
        }
        return mention.getText().matches("[-0-9]+[.,]+[0-9.,]+|[0-9,]+");
    }

    private boolean overlaps(Mention lastMention, Mention mention) {
        if (lastMention == null || mention == null) {
            return false;
        }
        return lastMention.getStart() <= mention.getStart() && mention.getEnd() <= lastMention.getEnd();
    }
}

