/*
 * Decompiled with CFR 0.152.
 */
package de.berlin.hu.uima.ae.tagger.brics;

import de.berlin.hu.chemspot.Mention;
import de.berlin.hu.uima.ae.normalizer.Normalizer;
import dk.brics.automaton.Automaton;
import dk.brics.automaton.AutomatonMatcher;
import dk.brics.automaton.RunAutomaton;
import dk.brics.automaton.State;
import dk.brics.automaton.StringUnionOperations;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class BricsMatcher {
    public static final int DEFAULT_TERMS_PER_AUTOMATON = 100000;
    private Collection<RunAutomaton> matchers = new ArrayList<RunAutomaton>();

    public BricsMatcher() throws IOException, ClassNotFoundException {
        this(Normalizer.getIds().keySet(), 100000);
    }

    public BricsMatcher(Collection<String> chemicals) throws IOException, ClassNotFoundException {
        System.out.print("Creating brics automaton...");
        this.matchers.add(BricsMatcher.createAutomaton(chemicals));
        System.out.println("Done.");
    }

    public BricsMatcher(Collection<String> chemicals, int termsPerAutomaton) throws IOException, ClassNotFoundException {
        System.out.print("Creating brics automata");
        this.matchers.addAll(BricsMatcher.createAutomata(chemicals, termsPerAutomaton));
        System.out.println("Created " + this.matchers.size() + " brics automata.");
    }

    public BricsMatcher(String pathToZippedBinaries) throws IOException, ClassNotFoundException {
        if (pathToZippedBinaries.endsWith(".zip")) {
            ZipFile zipFile = new ZipFile(pathToZippedBinaries);
            Enumeration<? extends ZipEntry> entries = zipFile.entries();
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                this.matchers.add(RunAutomaton.load(zipFile.getInputStream(entry)));
            }
        } else {
            this.matchers.add(RunAutomaton.load(new FileInputStream(pathToZippedBinaries)));
        }
        System.out.println("Loaded " + this.matchers.size() + " brics automata.");
    }

    public static List<RunAutomaton> createAutomata(Collection<String> chemicals, int termsPerAutomaton) {
        ArrayList<RunAutomaton> result2 = new ArrayList<RunAutomaton>();
        int count2 = 0;
        int total = 0;
        ArrayList<String> terms = new ArrayList<String>();
        for (String chemical : chemicals) {
            terms.add(chemical);
            ++total;
            if (++count2 < termsPerAutomaton) continue;
            result2.add(BricsMatcher.createAutomaton(terms));
            System.out.print(".");
            terms.clear();
            count2 = 0;
        }
        if (!terms.isEmpty()) {
            result2.add(BricsMatcher.createAutomaton(terms));
            System.out.println(" Done.");
            terms.clear();
            count2 = 0;
        }
        return result2;
    }

    public static RunAutomaton createAutomaton(Collection<String> chemicals) {
        ArrayList<String> sortedList = new ArrayList<String>(chemicals);
        Collections.sort(sortedList, StringUnionOperations.LEXICOGRAPHIC_ORDER);
        CharSequence[] sortedArray = sortedList.toArray(new String[sortedList.size()]);
        sortedList = null;
        State state = StringUnionOperations.build(sortedArray);
        Automaton automaton = new Automaton();
        automaton.setInitialState(state);
        RunAutomaton runAutomaton = new RunAutomaton(automaton);
        return runAutomaton;
    }

    public Collection<Mention> match(String text2) {
        HashSet<Mention> matches2 = new HashSet<Mention>();
        for (RunAutomaton automat : this.matchers) {
            AutomatonMatcher matcher = automat.newMatcher(text2);
            while (matcher.find()) {
                char left = ' ';
                char right = ' ';
                char nright = ' ';
                try {
                    left = text2.charAt(matcher.start() - 1);
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                }
                catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                    // empty catch block
                }
                try {
                    right = text2.charAt(matcher.end());
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                }
                catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                    // empty catch block
                }
                try {
                    nright = text2.charAt(matcher.end() + 1);
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                }
                catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                    // empty catch block
                }
                String coveredText = text2.substring(matcher.start(), matcher.end());
                if (coveredText.length() <= 2 || Character.isLetter(left) || Character.isLetter(right) && (right != 115 || !Character.isLetter(nright))) continue;
                matches2.add(new Mention(matcher.start(), matcher.end() + (right == 's' ? 1 : 0), text2.substring(matcher.start(), matcher.end())));
            }
        }
        return matches2;
    }
}

