/*
 * Decompiled with CFR 0.152.
 */
package de.berlin.hu.uima.ae.tagger.banner;

import banner.tagging.CRFTagger;
import banner.tagging.FeatureSet;
import cc.mallet.fst.CRF;
import dragon.nlp.tool.Lemmatiser;
import dragon.nlp.tool.Tagger;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.net.URL;
import java.util.zip.GZIPInputStream;

public class CRFWrapper
extends CRFTagger {
    public static CRFTagger load(URL f2, Lemmatiser lemmatiser, Tagger posTagger, banner.tagging.Tagger preTagger) throws IOException {
        try {
            ObjectInputStream ois = new ObjectInputStream(new GZIPInputStream(f2.openStream()));
            CRF model = (CRF)ois.readObject();
            FeatureSet featureSet = (FeatureSet)ois.readObject();
            if (lemmatiser != null) {
                featureSet.setLemmatiser(lemmatiser);
            }
            if (posTagger != null) {
                featureSet.setPosTagger(posTagger);
            }
            if (preTagger != null) {
                featureSet.setPreTagger(preTagger);
            }
            int order = ois.readInt();
            ois.close();
            return new CRFWrapper(model, featureSet, order);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    protected CRFWrapper(CRF model, FeatureSet featureSet, int order) {
        super(model, featureSet, order);
        model.getInputPipe().getDataAlphabet().stopGrowth();
    }
}

