/*
 * Decompiled with CFR 0.152.
 */
package de.berlin.hu.uima.ae.tagger.abbrev;

import de.berlin.hu.chemspot.ChemSpot;
import de.berlin.hu.chemspot.Mention;
import de.berlin.hu.types.PubmedDocument;
import de.berlin.hu.uima.ae.tagger.abbrev.ExtractAbbrev;
import org.apache.uima.analysis_component.JCasAnnotator_ImplBase;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.jcas.JCas;
import org.u_compare.shared.semantic.chemical.Chemical;
import org.uimafit.util.JCasUtil;

public class AbbreviationTagger
extends JCasAnnotator_ImplBase {
    private static boolean TAG_PUBMED = true;
    private ExtractAbbrev abbrevTagger = new ExtractAbbrev();

    /*
     * Unable to fully structure code
     */
    @Override
    public void process(JCas aJCas) throws AnalysisEngineProcessException {
        text = aJCas.getDocumentText();
        abbreviations = this.abbrevTagger.getMentions(text);
        ChemSpot.printTime("ABBREV");
        pmIterator = JCasUtil.iterator(aJCas, PubmedDocument.class);
        currDocument = AbbreviationTagger.TAG_PUBMED != false && pmIterator.hasNext() != false ? pmIterator.next() : null;
        for (Mention abbr : abbreviations) {
            if (abbr.getText().length() >= 2) ** GOTO lbl10
            continue;
lbl-1000:
            // 1 sources

            {
                currDocument = pmIterator.next();
lbl10:
                // 2 sources

                ** while (AbbreviationTagger.TAG_PUBMED && pmIterator.hasNext() && currDocument.getEnd() < abbr.getStart())
            }
lbl11:
            // 1 sources

            offset = -1;
            if (currDocument != null) {
                text = currDocument.getCoveredText();
                offset = currDocument.getBegin();
            } else {
                text = aJCas.getDocumentText();
                offset = 0;
            }
            index = -1;
            while ((index = text.indexOf(abbr.getText(), index + 1)) != -1) {
                if (index - 1 >= 0 && Character.isLetter(text.charAt(index - 1)) || index + abbr.getText().length() < text.length() && Character.isLetter(text.charAt(index + abbr.getText().length()))) continue;
                begin = offset + index;
                end = offset + index + abbr.getText().length();
                this.createAbbreviationAnnotation(aJCas, begin, end, abbr.getCHID());
            }
        }
    }

    private Chemical createAbbreviationAnnotation(JCas aJCas, int begin, int end, String id) {
        Chemical abbreviation = new Chemical(aJCas);
        abbreviation.setBegin(begin);
        abbreviation.setEnd(end);
        abbreviation.setId(id);
        abbreviation.setSource("ABBREV");
        abbreviation.addToIndexes();
        return abbreviation;
    }
}

