/*
 * Decompiled with CFR 0.152.
 */
package de.berlin.hu.uima.ae.normalizer;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.HashSet;
import java.util.Set;

public class StringComparator {
    public static float diceCoefficient(String name1, String name2) {
        return StringComparator.diceCoefficient(name1, name2, 2);
    }

    public static Set<String> getNGrams(String s, int n) {
        n = n < 2 ? 2 : n;
        s = s.trim().toLowerCase().replaceAll("\\s+", " ");
        char padChar = '\u0000';
        int i = 0;
        while (i < n - 1) {
            s = String.valueOf(padChar) + s + padChar;
            ++i;
        }
        HashSet<String> ngrams = new HashSet<String>(s.length() - n + 2, 1.0f);
        int i2 = 0;
        while (i2 < s.length() - n + 1) {
            ngrams.add(s.substring(i2, i2 + n));
            ++i2;
        }
        return ngrams;
    }

    public static float diceCoefficient(Set<String> s1, Set<String> s2) {
        HashSet<String> intersection2 = new HashSet<String>(s1);
        intersection2.retainAll(s2);
        return 2.0f * (float)intersection2.size() / (float)(s1.size() + s2.size());
    }

    public static float diceCoefficient(String s1, String s2, int n) {
        n = n < 2 ? 2 : n;
        Set<String> ngrams1 = StringComparator.getNGrams(s1, n);
        Set<String> ngrams2 = StringComparator.getNGrams(s1, n);
        HashSet<String> intersection2 = new HashSet<String>(ngrams1);
        intersection2.retainAll(ngrams2);
        return 2.0f * (float)intersection2.size() / (float)(ngrams1.size() + ngrams2.size());
    }

    public static void main(String[] args) throws IOException {
        BufferedReader reader = new BufferedReader(new InputStreamReader(System.in));
        while (true) {
            System.out.print("name 1: ");
            String name1 = reader.readLine();
            System.out.print("name 2: ");
            String name2 = reader.readLine();
            System.out.println("dice coefficient: " + StringComparator.diceCoefficient(name1, name2));
            System.out.println();
        }
    }
}

