/*
 * Decompiled with CFR 0.152.
 */
package de.berlin.hu.uima.ae.filter;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import opennlp.uima.Token;
import org.apache.uima.analysis_component.JCasAnnotator_ImplBase;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.cas.FSIterator;
import org.apache.uima.cas.text.AnnotationIndex;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.tcas.Annotation;
import org.u_compare.shared.semantic.NamedEntity;

public class PosFilter
extends JCasAnnotator_ImplBase {
    private String[] posTags;
    private final String[] invalidPOSTags = new String[]{"FW", "LS"};
    private int numberOfFilteredEntities = 0;
    private List<NamedEntity> invalidChemicals = null;

    @Override
    public void process(JCas aJCas) throws AnalysisEngineProcessException {
        int end;
        int begin;
        AnnotationIndex<Annotation> chemicalIndex = aJCas.getAnnotationIndex(NamedEntity.type);
        AnnotationIndex<Annotation> tokenIndex = aJCas.getAnnotationIndex(Token.type);
        FSIterator chemicalIterator = chemicalIndex.iterator();
        FSIterator tokenIterator = tokenIndex.iterator();
        this.posTags = new String[aJCas.getDocumentText().length()];
        while (tokenIterator.hasNext()) {
            Token token2 = (Token)tokenIterator.next();
            begin = token2.getBegin();
            end = token2.getEnd();
            String posTag = token2.getPos();
            int i = begin;
            while (i < end) {
                this.posTags[i] = posTag;
                ++i;
            }
        }
        this.invalidChemicals = new ArrayList<NamedEntity>();
        while (chemicalIterator.hasNext()) {
            NamedEntity chemical = (NamedEntity)chemicalIterator.next();
            begin = chemical.getBegin();
            end = chemical.getEnd();
            if ("goldstandard".equals(chemical.getSource()) || !this.isInvalid(begin, end)) continue;
            this.invalidChemicals.add(chemical);
            ++this.numberOfFilteredEntities;
        }
        for (NamedEntity invalidChemical : this.invalidChemicals) {
            invalidChemical.removeFromIndexes();
        }
        System.out.println("PosFilter: " + this.numberOfFilteredEntities);
    }

    public String getTag(int begin, int end) {
        HashMap<String, Integer> listOfTags = new HashMap<String, Integer>();
        int i = begin;
        while (i < end) {
            String posTag = this.posTags[i];
            if (listOfTags.containsKey(posTag)) {
                listOfTags.put(posTag, (Integer)listOfTags.get(posTag) + 1);
            } else {
                listOfTags.put(posTag, 1);
            }
            ++i;
        }
        ArrayList list2 = new ArrayList(listOfTags.entrySet());
        Collections.sort(list2, new Comparator<Map.Entry>(){

            @Override
            public int compare(Map.Entry e1, Map.Entry e2) {
                Integer i1 = (Integer)e1.getValue();
                Integer i2 = (Integer)e2.getValue();
                return i2.compareTo(i1);
            }
        });
        String tag = (String)((Map.Entry)list2.get(0)).getKey();
        return tag;
    }

    public boolean isInvalid(int begin, int end) {
        String posTag = this.getTag(begin, end);
        int i = 0;
        while (i < this.invalidPOSTags.length) {
            if (this.invalidPOSTags[i].equals(posTag)) {
                return true;
            }
            ++i;
        }
        return false;
    }
}

