/*
 * Decompiled with CFR 0.152.
 */
package de.berlin.hu.uima.ae.expander;

import java.util.ArrayList;
import org.apache.uima.analysis_component.JCasAnnotator_ImplBase;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.jcas.JCas;
import org.u_compare.shared.semantic.NamedEntity;
import org.u_compare.shared.syntactic.Token;
import org.uimafit.util.JCasUtil;

public class MentionExpander
extends JCasAnnotator_ImplBase {
    private NamedEntity expandEntity(NamedEntity ne) {
        String text2 = ne.getCAS().getDocumentText();
        int begin = ne.getBegin();
        int end = ne.getEnd();
        boolean changed = true;
        while (changed) {
            changed = false;
            if (begin - 1 > 0 && String.valueOf(text2.charAt(begin - 1)).matches("[^\\s/\\.]")) {
                --begin;
                changed = true;
            }
            if (end >= text2.length() || !String.valueOf(text2.charAt(end)).matches("[^\\s/\\.]")) continue;
            ++end;
            changed = true;
        }
        NamedEntity result2 = (NamedEntity)ne.clone();
        result2.setBegin(begin);
        result2.setEnd(end);
        return result2;
    }

    private static int countChar(char c, String s) {
        int result2 = 0;
        char[] cArray = s.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char ch = cArray[n2];
            if (c == ch) {
                ++result2;
            }
            ++n2;
        }
        return result2;
    }

    @Override
    public void process(JCas aJCas) throws AnalysisEngineProcessException {
        for (NamedEntity ne : JCasUtil.iterate(aJCas, NamedEntity.class)) {
            NamedEntity expanded;
            if ("crf".equals(ne.getSource()) || (expanded = this.expandEntity(ne)).getBegin() == ne.getBegin() && expanded.getEnd() == ne.getEnd()) continue;
            int left = -2;
            int right = -2;
            int i = 0;
            ArrayList<Token> tokens = new ArrayList<Token>();
            for (Token token2 : JCasUtil.iterate(Token.class, expanded)) {
                tokens.add(token2);
                if (token2.getBegin() <= ne.getBegin()) {
                    left = i;
                }
                if (right == -2 && token2.getEnd() >= ne.getEnd()) {
                    right = i;
                }
                ++i;
            }
            int initialLeft = left;
            while (left > 0) {
                Token t = (Token)tokens.get(left - 1);
                String pos = t.getLabel();
                if (pos != null && left - 1 == 0 && pos.startsWith("VB")) break;
                --left;
            }
            while (!((Token)tokens.get(left)).getCoveredText().matches("([^\\p{Punct}]|[\\(\\[])+") && left < initialLeft) {
                ++left;
            }
            int initialRight = right;
            while (right < tokens.size() - 1) {
                Token t = (Token)tokens.get(right + 1);
                String pos = t.getLabel();
                if (pos != null && right + 1 == tokens.size() - 1 && (pos.startsWith("VB") || pos.startsWith("JJ") || pos.equals("IN"))) break;
                ++right;
            }
            while (!((Token)tokens.get(right)).getCoveredText().matches("([^\\p{Punct}]|[\\)\\]])+") && right > initialRight) {
                --right;
            }
            expanded.setBegin(((Token)tokens.get(left)).getBegin());
            expanded.setEnd(((Token)tokens.get(right)).getEnd());
            String text2 = expanded.getCoveredText();
            if (text2.startsWith("(") && text2.endsWith(")") || text2.startsWith("[") && text2.endsWith("]")) {
                expanded.setBegin(expanded.getBegin() + 1);
                expanded.setEnd(expanded.getEnd() - 1);
                text2 = expanded.getCoveredText();
            }
            while (text2.startsWith("(") && MentionExpander.countChar('(', text2) > MentionExpander.countChar(')', text2) || text2.startsWith("[") && MentionExpander.countChar('[', text2) > MentionExpander.countChar(']', text2)) {
                expanded.setBegin(expanded.getBegin() + 1);
                text2 = expanded.getCoveredText();
            }
            while (text2.endsWith(")") && MentionExpander.countChar(')', text2) > MentionExpander.countChar('(', text2) || text2.endsWith("]") && MentionExpander.countChar(']', text2) > MentionExpander.countChar('[', text2)) {
                expanded.setEnd(expanded.getEnd() - 1);
                text2 = expanded.getCoveredText();
            }
            if (expanded.getBegin() == ne.getBegin() && expanded.getEnd() == ne.getEnd()) continue;
            ne.setBegin(expanded.getBegin());
            ne.setEnd(expanded.getEnd());
        }
    }
}

