/*
 * Decompiled with CFR 0.152.
 */
package de.berlin.hu.chemspot;

import de.berlin.hu.util.Constants;
import org.apache.uima.jcas.tcas.Annotation;
import org.u_compare.shared.semantic.NamedEntity;

public class Mention
implements Comparable<Object> {
    private int start;
    private int end;
    private String text;
    private String[] ids;
    private String source;
    private String documentText;
    private String type;

    public Mention(int start, int end, String text2, String ids, String source, String documentText, String type) {
        this.start = start;
        this.end = end;
        this.text = text2;
        this.ids = new String[Constants.ChemicalID.values().length];
        if (ids != null) {
            String tempIds = ids;
            if (tempIds.startsWith("[")) {
                tempIds = tempIds.substring(1);
            }
            if (tempIds.endsWith("]")) {
                tempIds = tempIds.substring(0, tempIds.length() - 1);
            }
            int i = 0;
            String[] stringArray = tempIds.split(", |,$|^,");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String id = stringArray[n2];
                if (i >= this.ids.length) break;
                this.setId(Constants.ChemicalID.values()[i++], id.trim());
                ++n2;
            }
        }
        this.source = source;
        this.documentText = documentText;
        this.type = type;
    }

    public Mention(int start, int end, String text2, String ids, String source, String documentText) {
        this(start, end, text2, ids, source, documentText, null);
    }

    public Mention(int start, int end, String text2) {
        this.start = start;
        this.end = end;
        this.text = text2;
        this.source = "dictionary";
    }

    public Mention(int start, int end) {
        this.start = start;
        this.end = end;
    }

    public Mention(NamedEntity entity) {
        this(entity.getBegin(), entity.getEnd(), entity.getCoveredText(), entity.getId(), entity.getSource(), entity.getCAS().getDocumentText(), entity.getEntityType());
    }

    public int getStart() {
        return this.start;
    }

    public void setStart(int start) {
        this.start = start;
    }

    public int getEnd() {
        return this.end;
    }

    public void setEnd(int end) {
        this.end = end;
    }

    public String getText() {
        return this.text;
    }

    public String[] getIds() {
        return this.ids;
    }

    public String getSource() {
        return this.source;
    }

    public void setSource(String source) {
        this.source = source;
    }

    public String getCHID() {
        return this.getId(Constants.ChemicalID.CHID);
    }

    public String getCHEB() {
        return this.getId(Constants.ChemicalID.CHEB);
    }

    public String getCAS() {
        return this.getId(Constants.ChemicalID.CAS);
    }

    public String getPUBC() {
        return this.getId(Constants.ChemicalID.PUBC);
    }

    public String getPUBS() {
        return this.getId(Constants.ChemicalID.PUBS);
    }

    public String getINCH() {
        return this.getId(Constants.ChemicalID.INCH);
    }

    public String getDRUG() {
        return this.getId(Constants.ChemicalID.DRUG);
    }

    public String getHMBD() {
        return this.getId(Constants.ChemicalID.HMBD);
    }

    public String getKEGG() {
        return this.getId(Constants.ChemicalID.KEGG);
    }

    public String getKEGD() {
        return this.getId(Constants.ChemicalID.KEGD);
    }

    public String getMESH() {
        return this.getId(Constants.ChemicalID.MESH);
    }

    public String getFDA() {
        return this.getId(Constants.ChemicalID.FDA);
    }

    public String getFDADate() {
        return this.getId(Constants.ChemicalID.FDA_DATE);
    }

    public String getId(Constants.ChemicalID type) {
        String id = null;
        try {
            id = this.ids[type.ordinal()];
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
        return id;
    }

    public void setCHID(String id) {
        this.setId(Constants.ChemicalID.CHID, id);
    }

    public void setCHEB(String id) {
        this.setId(Constants.ChemicalID.CHEB, id);
    }

    public void setCAS(String id) {
        this.setId(Constants.ChemicalID.CAS, id);
    }

    public void setPUBC(String id) {
        this.setId(Constants.ChemicalID.PUBC, id);
    }

    public void setPUBS(String id) {
        this.setId(Constants.ChemicalID.PUBS, id);
    }

    public void setINCH(String id) {
        this.setId(Constants.ChemicalID.INCH, id);
    }

    public void setDRUG(String id) {
        this.setId(Constants.ChemicalID.DRUG, id);
    }

    public void setHMBD(String id) {
        this.setId(Constants.ChemicalID.HMBD, id);
    }

    public void setKEGG(String id) {
        this.setId(Constants.ChemicalID.KEGG, id);
    }

    public void setKEGD(String id) {
        this.setId(Constants.ChemicalID.KEGD, id);
    }

    public void setMESH(String id) {
        this.setId(Constants.ChemicalID.MESH, id);
    }

    public void setFDA(String id) {
        this.setId(Constants.ChemicalID.FDA, id);
    }

    public void setFDADate(String id) {
        this.setId(Constants.ChemicalID.FDA_DATE, id);
    }

    public void setId(Constants.ChemicalID type, String id) {
        if (id != null && (id.isEmpty() || "null".equals(id))) {
            id = null;
        }
        if (Constants.ChemicalID.CHEB.equals((Object)type) && id != null && !id.startsWith("CHEBI:")) {
            id = "CHEBI:" + id;
        }
        try {
            this.ids[type.ordinal()] = id != null ? id.trim() : null;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !(obj instanceof Mention)) {
            return false;
        }
        Mention other = (Mention)obj;
        return this.getStart() == other.getStart() && this.getEnd() == other.getEnd() && (this.getText() != null || other.getText() == null) && (this.getText() == null || this.getText().equals(other.getText()));
    }

    public int hashCode() {
        int prime = 31;
        int result2 = 1;
        result2 = 31 * result2 + this.getStart();
        result2 = 31 * result2 + this.getEnd();
        result2 = 31 * result2 + (this.text == null ? 0 : this.text.hashCode());
        return result2;
    }

    public String toString() {
        return String.valueOf(this.start) + " " + this.end + " " + this.text + " " + this.getCHID();
    }

    @Override
    public int compareTo(Object o) {
        if (this.equals(o)) {
            return 0;
        }
        int otherBegin = 0;
        int otherEnd = 0;
        if (o instanceof Mention) {
            Mention other = (Mention)o;
            otherBegin = other.getStart();
            otherEnd = other.getEnd();
        } else if (o instanceof Annotation) {
            Annotation other = (Annotation)o;
            otherBegin = other.getBegin();
            otherEnd = other.getEnd();
        } else {
            return 0;
        }
        if (this.getStart() != otherBegin) {
            return this.getStart() - otherBegin;
        }
        return this.getEnd() - otherEnd;
    }

    public boolean overlaps(Mention mention) {
        return mention != null && (this.getStart() >= mention.getStart() && this.getStart() < mention.getEnd() || this.getEnd() >= mention.getStart() && this.getEnd() < mention.getEnd() || mention.getStart() >= this.getStart() && mention.getStart() < this.getEnd() || mention.getEnd() >= this.getStart() && mention.getEnd() < this.getEnd());
    }

    public String getDocumentText() {
        return this.documentText;
    }

    public void setDocumentText(String documentText) {
        this.documentText = documentText;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }
}

