/*
 * Decompiled with CFR 0.152.
 */
package de.berlin.hu.chemspot;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.Map;
import java.util.Properties;

public class ChemSpotConfiguration {
    private static final Component[] DEFAULT_DEACTIVATED = new Component[]{Component.FEATURE_GENERATOR, Component.CHEMHITS, Component.PROFILER, Component.DRUG_TAGGER};
    private static final String CORPUS_PREFIX = "corpus.";
    private static final String OUTPUT_PATH = "output.path";
    private static final String XMI_OUTPUT_PATH = "output.path.xmi";
    private static final String CONVERT_TO_IOB = "output.convertToIOB";
    private static final String SENTENCE_MODEL = "sentence_model.path";
    private static final String CRF_MODEL = "crf.model.path";
    private static final String DICTIONARY = "dict.path";
    private static final String IDS = "ids.path";
    private static final String DRUG_MODEL = "drug.model.path";
    private static final String EVALUATION = "evaluation";
    private static final String DETAILED_EVALUATION = "evaluation.detailed";
    private static final String THREADING = "threading";
    private static final String THREAD_NR = "threading.number_of_threads";
    private static final int DEFAULT_THREAD_NR = 4;
    private static final String COMPONENT_PREFIX = "component.";
    private static final String DICTIONARY_INITIALIZE_FROM_NORMALIZER = "component." + Component.DICTIONARY.toString().toLowerCase() + ".initializeFromNormalizer";
    private static final String DICTIONARY_FILTER_LENGTH = "component." + Component.DICTIONARY.toString().toLowerCase() + ".filterLength";
    private static final String UPDATE_PREFIX = "update.";
    private static final String UPDATE_REMOVE_TEMPORARY_FILES = "update.removeTemporaryFiles";
    private static final String UPDATE_CHEBI_SDF_URL = "update.chebi.sdf.url";
    private static final String UPDATE_CHEBI_MUST_CONTAIN_FORMULA = "update.chebi.mustContainFormula";
    private static final String UPDATE_PUBCHEM_SDF_URL = "update.pubchem.sdf.url";
    private static final String UPDATE_PUBCHEM_MAX_LENGTH = "update.pubchem.maxLength";
    private static Properties properties = null;

    static {
        properties = new Properties();
    }

    public static void initialize() throws FileNotFoundException, IOException {
        if (new File("conf/chemspot.cfg").exists()) {
            ChemSpotConfiguration.initialize("conf/chemspot.cfg");
        } else if (new File("chemspot.cfg").exists()) {
            ChemSpotConfiguration.initialize("chemspot.cfg");
        }
    }

    public static void initialize(String configFilePath) throws FileNotFoundException, IOException {
        ChemSpotConfiguration.initialize(configFilePath, true);
    }

    public static void initialize(String configFilePath, boolean overwrite) throws FileNotFoundException, IOException {
        ChemSpotConfiguration.initialize(new FileInputStream(configFilePath), overwrite);
    }

    public static void initialize(InputStream inStream, boolean overwrite) throws IOException {
        if (overwrite) {
            properties.load(inStream);
        } else {
            Properties temp = new Properties();
            temp.load(inStream);
            temp.putAll((Map<?, ?>)properties);
            properties = temp;
        }
    }

    public static String getProperty(String property) {
        String result2 = properties.getProperty(property);
        if (result2 != null) {
            result2 = result2.trim();
        }
        return result2;
    }

    public static String getProperty(String property, String defaultValue) {
        return properties.getProperty(property, defaultValue);
    }

    public static String getPathToCorpus(Corpus corpus) {
        return ChemSpotConfiguration.getProperty(CORPUS_PREFIX + (Object)((Object)corpus));
    }

    public static String getOutputPath() {
        return ChemSpotConfiguration.getProperty(OUTPUT_PATH);
    }

    public static String getXMIOutputPath() {
        return ChemSpotConfiguration.getProperty(XMI_OUTPUT_PATH);
    }

    public static String getUpdateOutputPath() {
        return ChemSpotConfiguration.getProperty("update.output.path");
    }

    public static boolean isConvertToIob() {
        return "true".equals(ChemSpotConfiguration.getProperty(CONVERT_TO_IOB));
    }

    public static String getSentenceModelPath() {
        return ChemSpotConfiguration.getProperty(SENTENCE_MODEL);
    }

    public static String getCRFModelPath() {
        return ChemSpotConfiguration.getProperty(CRF_MODEL);
    }

    public static String getDictionaryPath() {
        return ChemSpotConfiguration.getProperty(DICTIONARY);
    }

    public static String getDictionaryUpdatePath() {
        return ChemSpotConfiguration.getProperty("update.dict.path");
    }

    public static String getIdsFilePath() {
        return ChemSpotConfiguration.getProperty(IDS);
    }

    public static String getIdsFileUpdatePath() {
        return ChemSpotConfiguration.getProperty("update.ids.path");
    }

    public static String getDrugModelPath() {
        return ChemSpotConfiguration.getProperty(DRUG_MODEL);
    }

    public static boolean isEvaluate() {
        return "true".equals(ChemSpotConfiguration.getProperty(EVALUATION));
    }

    public static boolean isDetailedEvaluation() {
        return "true".equals(ChemSpotConfiguration.getProperty(DETAILED_EVALUATION));
    }

    public static boolean useComponent(Component component) {
        String defaultValue = Arrays.asList(DEFAULT_DEACTIVATED).contains((Object)component) ? "false" : "true";
        return "true".equals(ChemSpotConfiguration.getProperty(COMPONENT_PREFIX + component.toString().toLowerCase(), defaultValue).toLowerCase().trim());
    }

    public static boolean initializeDictionaryFromNormalizer() {
        return "true".equals(ChemSpotConfiguration.getProperty(DICTIONARY_INITIALIZE_FROM_NORMALIZER, "false").toLowerCase());
    }

    public static int getDictionaryFilterLength() {
        return Integer.parseInt(ChemSpotConfiguration.getProperty(DICTIONARY_FILTER_LENGTH, "-1").toLowerCase());
    }

    public static boolean isThreading() {
        return "true".equals(ChemSpotConfiguration.getProperty(THREADING));
    }

    public static int getNumberOfThreads() {
        try {
            return Integer.valueOf(ChemSpotConfiguration.getProperty(THREAD_NR, "4"));
        }
        catch (NumberFormatException e) {
            System.out.println("ERROR: value of property 'threading.number_of_threads' is not a number. Using defalut value 4");
            return 4;
        }
    }

    public static boolean isUpdate(String s) {
        return "true".equals(ChemSpotConfiguration.getProperty(UPDATE_PREFIX + s.toLowerCase()));
    }

    public static URL getChEBISDFUpdateURL() {
        String urlString = ChemSpotConfiguration.getProperty(UPDATE_CHEBI_SDF_URL);
        try {
            return new URL(urlString);
        }
        catch (MalformedURLException e) {
            System.err.println("The ChEBI update URL '" + urlString + "' in your configuration file is not a valid url");
            e.printStackTrace();
            return null;
        }
    }

    public static boolean isChEBIUpdateMustContainFormula() {
        return "true".equals(ChemSpotConfiguration.getProperty(UPDATE_CHEBI_MUST_CONTAIN_FORMULA));
    }

    public static URL getPubChemSDFUpdateURL() {
        String urlString = ChemSpotConfiguration.getProperty(UPDATE_PUBCHEM_SDF_URL);
        try {
            return new URL(urlString);
        }
        catch (MalformedURLException e) {
            System.err.println("The PubChem update URL '" + urlString + "' in your configuration file is not a valid url");
            e.printStackTrace();
            return null;
        }
    }

    public static int getPubChemMaxLength() {
        return Integer.parseInt(ChemSpotConfiguration.getProperty(UPDATE_PUBCHEM_MAX_LENGTH));
    }

    public static boolean isRemoveTemporaryUpdateFiles() {
        return "true".equals(ChemSpotConfiguration.getProperty(UPDATE_REMOVE_TEMPORARY_FILES, "false"));
    }

    public static enum Component {
        TOKENIZER,
        SENTENCE_DETECTOR,
        POS_TAGGER,
        CRF,
        DICTIONARY,
        SUM_TAGGER,
        ABBREV,
        DRUG_TAGGER,
        MENTION_EXPANDER,
        ANNOTATION_MERGER,
        STOPWORD_FILTER,
        NORMALIZER,
        OPSIN,
        FEATURE_GENERATOR,
        CHEMHITS,
        PROFILER;

    }

    public static enum Corpus {
        IOB,
        CRAFT,
        GZ,
        NACTEM,
        PATENT,
        DDI,
        XMI,
        CHEMDNER,
        TXT;

    }
}

