/*
 * Decompiled with CFR 0.152.
 */
package de.berlin.hu.chemspot;

import de.berlin.hu.chemspot.ChemSpotConfiguration;
import de.berlin.hu.chemspot.ChemicalNEREvaluator;
import de.berlin.hu.chemspot.Mention;
import de.berlin.hu.types.PubmedDocument;
import de.berlin.hu.uima.ae.feature.FeatureTokenGenerator;
import de.berlin.hu.util.Constants;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import org.apache.uima.UIMAException;
import org.apache.uima.UIMAFramework;
import org.apache.uima.analysis_engine.AnalysisEngine;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.examples.SourceDocumentInformation;
import org.apache.uima.jcas.JCas;
import org.apache.uima.resource.metadata.TypeSystemDescription;
import org.apache.uima.util.XMLInputSource;
import org.u_compare.shared.semantic.NamedEntity;
import org.u_compare.shared.syntactic.Token;
import org.uimafit.factory.AnalysisEngineFactory;
import org.uimafit.factory.JCasFactory;
import org.uimafit.util.JCasUtil;

public class ChemSpot {
    private static final String CRF_MODEL_RESOURCE_PATH = "resources/banner/model.bin";
    private static final String SENTENCE_MODEL_RESOURCE_PATH = "resources/genia/SentDetectGenia.bin.gz";
    private static Map<Long, JCas> jCases = new HashMap<Long, JCas>();
    private TypeSystemDescription typeSystem;
    private AnalysisEngine posTagger;
    private AnalysisEngine sentenceDetector;
    private AnalysisEngine sentenceConverter;
    private AnalysisEngine tokenConverter;
    private AnalysisEngine crfTagger;
    private AnalysisEngine dictionaryTagger;
    private AnalysisEngine chemicalFormulaTagger;
    private AnalysisEngine abbrevTagger;
    private AnalysisEngine drugTagger;
    private AnalysisEngine annotationMerger;
    private AnalysisEngine fineTokenizer;
    private AnalysisEngine stopwordFilter;
    private AnalysisEngine mentionExpander;
    private AnalysisEngine normalizer;
    private FeatureTokenGenerator featureGenerator;
    private ChemicalNEREvaluator evaluator;
    private static long start = 0L;

    public ChemSpot() {
        this(null, null, null, null);
    }

    public ChemSpot(String pathToCRFModelFile, String pathToSentenceModelFile) {
        this(pathToCRFModelFile, null, pathToSentenceModelFile, null);
    }

    public ChemSpot(String pathToCRFModelFile, String pathToDictionaryFile, String pathToSentenceModelFile) {
        this(pathToCRFModelFile, pathToDictionaryFile, pathToSentenceModelFile, null);
    }

    public ChemSpot(String pathToCRFModelFile, String pathToDictionaryFile, String pathToSentenceModelFile, String pathToIDs) {
        this(pathToCRFModelFile, pathToDictionaryFile, pathToSentenceModelFile, pathToIDs, null);
    }

    public ChemSpot(String pathToCRFModelFile, String pathToDictionaryFile, String pathToSentenceModelFile, String pathToIDs, String pathToDrugModel) {
        try {
            pathToCRFModelFile = pathToCRFModelFile == null ? this.getClass().getClassLoader().getResource(CRF_MODEL_RESOURCE_PATH).toString() : new File(pathToCRFModelFile).toURI().toURL().toString();
            pathToSentenceModelFile = pathToSentenceModelFile == null ? this.getClass().getClassLoader().getResource(SENTENCE_MODEL_RESOURCE_PATH).toString() : new File(pathToSentenceModelFile).toURI().toURL().toString();
            this.typeSystem = UIMAFramework.getXMLParser().parseTypeSystemDescription(new XMLInputSource(this.getClass().getClassLoader().getResource("desc/TypeSystem.xml")));
            if (ChemSpotConfiguration.useComponent(ChemSpotConfiguration.Component.TOKENIZER)) {
                this.fineTokenizer = AnalysisEngineFactory.createAnalysisEngine(UIMAFramework.getXMLParser().parseAnalysisEngineDescription(new XMLInputSource(this.getClass().getClassLoader().getResource("desc/ae/tokenizer/FineGrainedTokenizerAE.xml"))), "_InitialView");
                this.tokenConverter = AnalysisEngineFactory.createPrimitive(UIMAFramework.getXMLParser().parseAnalysisEngineDescription(new XMLInputSource(this.getClass().getClassLoader().getResource("desc/ae/converter/OpenNLPToUCompareTokenConverterAE.xml"))), new Object[0]);
            }
            if (ChemSpotConfiguration.useComponent(ChemSpotConfiguration.Component.POS_TAGGER)) {
                this.posTagger = AnalysisEngineFactory.createAnalysisEngine(UIMAFramework.getXMLParser().parseAnalysisEngineDescription(new XMLInputSource(this.getClass().getClassLoader().getResource("desc/ae/tagger/opennlp/PosTagger.xml"))), "_InitialView");
            }
            if (ChemSpotConfiguration.useComponent(ChemSpotConfiguration.Component.SENTENCE_DETECTOR)) {
                this.sentenceDetector = AnalysisEngineFactory.createPrimitive(UIMAFramework.getXMLParser().parseAnalysisEngineDescription(new XMLInputSource(this.getClass().getClassLoader().getResource("desc/ae/tagger/opennlp/SentenceDetector.xml"))), "opennlp.uima.ModelName", pathToSentenceModelFile);
                this.sentenceConverter = AnalysisEngineFactory.createAnalysisEngine(UIMAFramework.getXMLParser().parseAnalysisEngineDescription(new XMLInputSource(this.getClass().getClassLoader().getResource("desc/ae/converter/OpenNLPToUCompareSentenceConverterAE.xml"))), "_InitialView");
            }
            if (ChemSpotConfiguration.useComponent(ChemSpotConfiguration.Component.CRF)) {
                System.out.println("Loading CRF...");
                this.crfTagger = AnalysisEngineFactory.createPrimitive(UIMAFramework.getXMLParser().parseAnalysisEngineDescription(new XMLInputSource(this.getClass().getClassLoader().getResource("desc/banner/tagger/BANNERTaggerAE.xml"))), "BannerModelFile", pathToCRFModelFile);
            }
            if (ChemSpotConfiguration.useComponent(ChemSpotConfiguration.Component.DICTIONARY)) {
                if (pathToDictionaryFile != null) {
                    if (new File(pathToDictionaryFile).exists()) {
                        System.out.println("Loading dictionary...");
                        this.dictionaryTagger = AnalysisEngineFactory.createPrimitive(UIMAFramework.getXMLParser().parseAnalysisEngineDescription(new XMLInputSource(this.getClass().getClassLoader().getResource("desc/ae/tagger/BricsTaggerAE.xml"))), "DrugBankMatcherDictionaryAutomat", pathToDictionaryFile);
                    } else {
                        System.out.println("Dictionary file '" + pathToDictionaryFile + "' does not exist. Tagging without dictionary...");
                    }
                } else {
                    System.out.println("No dictionary location specified! Tagging without dictionary...");
                }
            }
            if (ChemSpotConfiguration.useComponent(ChemSpotConfiguration.Component.SUM_TAGGER)) {
                this.chemicalFormulaTagger = AnalysisEngineFactory.createAnalysisEngine(UIMAFramework.getXMLParser().parseAnalysisEngineDescription(new XMLInputSource(this.getClass().getClassLoader().getResource("desc/ae/tagger/ChemicalFormulaTaggerAE.xml"))), "_InitialView");
            }
            if (ChemSpotConfiguration.useComponent(ChemSpotConfiguration.Component.ABBREV)) {
                this.abbrevTagger = AnalysisEngineFactory.createAnalysisEngine(UIMAFramework.getXMLParser().parseAnalysisEngineDescription(new XMLInputSource(this.getClass().getClassLoader().getResource("desc/ae/tagger/AbbreviationTaggerAE.xml"))), "_InitialView");
            }
            if (ChemSpotConfiguration.useComponent(ChemSpotConfiguration.Component.DRUG_TAGGER)) {
                if (pathToDrugModel != null) {
                    if (new File(pathToDrugModel).exists()) {
                        System.out.println("Initializing drug tagger...");
                        this.drugTagger = AnalysisEngineFactory.createPrimitive(UIMAFramework.getXMLParser().parseAnalysisEngineDescription(new XMLInputSource(this.getClass().getClassLoader().getResource("desc/ae/tagger/DrugTaggerAE.xml"))), "pathToDrugModel", pathToDrugModel);
                    } else {
                        System.out.println("Drug Model file '" + pathToDrugModel + "' does not exist. Tagging without drug tagger...");
                    }
                } else {
                    System.out.println("No drug model location specified! Tagging without drug tagger...");
                }
            }
            if (ChemSpotConfiguration.useComponent(ChemSpotConfiguration.Component.MENTION_EXPANDER)) {
                this.mentionExpander = AnalysisEngineFactory.createAnalysisEngine(UIMAFramework.getXMLParser().parseAnalysisEngineDescription(new XMLInputSource(this.getClass().getClassLoader().getResource("desc/ae/expander/MentionExpanderAE.xml"))), "_InitialView");
            }
            if (ChemSpotConfiguration.useComponent(ChemSpotConfiguration.Component.ANNOTATION_MERGER)) {
                this.annotationMerger = AnalysisEngineFactory.createAnalysisEngine(UIMAFramework.getXMLParser().parseAnalysisEngineDescription(new XMLInputSource(this.getClass().getClassLoader().getResource("desc/ae/AnnotationMergerAE.xml"))), "_InitialView");
            }
            if (ChemSpotConfiguration.useComponent(ChemSpotConfiguration.Component.NORMALIZER) || ChemSpotConfiguration.useComponent(ChemSpotConfiguration.Component.CHEMHITS)) {
                if (pathToIDs != null) {
                    if (new File(pathToIDs).exists()) {
                        this.normalizer = AnalysisEngineFactory.createPrimitive(UIMAFramework.getXMLParser().parseAnalysisEngineDescription(new XMLInputSource(this.getClass().getClassLoader().getResource("desc/ae/normalizer/NormalizerAE.xml"))), "PathToIDs", pathToIDs);
                        if (ChemSpotConfiguration.useComponent(ChemSpotConfiguration.Component.DICTIONARY) && ChemSpotConfiguration.initializeDictionaryFromNormalizer()) {
                            this.dictionaryTagger = AnalysisEngineFactory.createPrimitive(UIMAFramework.getXMLParser().parseAnalysisEngineDescription(new XMLInputSource(this.getClass().getClassLoader().getResource("desc/ae/tagger/BricsTaggerAE.xml"))), "DrugBankMatcherDictionaryAutomat", "");
                        }
                    } else {
                        System.out.println("Normalization ids file '" + pathToIDs + "' does not exist. Tagging without subsequent normalization...");
                    }
                } else {
                    System.out.println("No location for ids specified! Tagging without subsequent normalization...");
                }
            }
            if (ChemSpotConfiguration.useComponent(ChemSpotConfiguration.Component.STOPWORD_FILTER)) {
                this.stopwordFilter = AnalysisEngineFactory.createAnalysisEngine(UIMAFramework.getXMLParser().parseAnalysisEngineDescription(new XMLInputSource(this.getClass().getClassLoader().getResource("desc/ae/filter/StopwordFilterAE.xml"))), "_InitialView");
            }
            if (ChemSpotConfiguration.useComponent(ChemSpotConfiguration.Component.FEATURE_GENERATOR)) {
                this.featureGenerator = new FeatureTokenGenerator();
            }
            this.setEvaluator(new ChemicalNEREvaluator());
            System.out.println("Finished initializing ChemSpot.");
        }
        catch (UIMAException e) {
            System.err.println("Failed initializing ChemSpot.");
            e.printStackTrace();
        }
        catch (IOException e) {
            System.err.println("Failed initializing ChemSpot.");
            e.printStackTrace();
        }
    }

    public static List<Mention> getMentions(JCas jcas) {
        ArrayList<Mention> mentions = new ArrayList<Mention>();
        Iterator<NamedEntity> entities = JCasUtil.iterator(jcas, NamedEntity.class);
        while (entities.hasNext()) {
            NamedEntity entity = entities.next();
            if ("goldstandard".equals(entity.getSource())) continue;
            mentions.add(new Mention(entity));
        }
        return mentions;
    }

    public static List<Mention> getGoldstandardAnnotations(JCas jcas) {
        ArrayList<Mention> result2 = new ArrayList<Mention>();
        Iterator<NamedEntity> entities = JCasUtil.iterator(jcas, NamedEntity.class);
        while (entities.hasNext()) {
            NamedEntity entity = entities.next();
            if (!"goldstandard".equals(entity.getSource())) continue;
            result2.add(new Mention(entity));
        }
        return result2;
    }

    public static void readFile(JCas jcas, String pathToFile) throws IOException {
        FileInputStream stream = new FileInputStream(new File(pathToFile));
        String text2 = null;
        try {
            FileChannel fc = stream.getChannel();
            MappedByteBuffer bb = fc.map(FileChannel.MapMode.READ_ONLY, 0L, fc.size());
            text2 = Charset.defaultCharset().decode(bb).toString();
        }
        finally {
            stream.close();
        }
        jcas.setDocumentText(text2);
        PubmedDocument pd = new PubmedDocument(jcas);
        pd.setBegin(0);
        pd.setEnd(text2.length());
        pd.setPmid("");
        pd.addToIndexes(jcas);
        SourceDocumentInformation srcDocInfo = new SourceDocumentInformation(jcas);
        srcDocInfo.setUri(new File(pathToFile).getAbsoluteFile().toURI().toString());
        srcDocInfo.setOffsetInSource(0);
        srcDocInfo.setDocumentSize((int)new File(pathToFile).length());
        srcDocInfo.setBegin(0);
        srcDocInfo.setEnd(text2.length());
        srcDocInfo.addToIndexes();
    }

    public static void readGZFile(JCas jcas, String pathToFile) throws IOException {
        File file = new File(pathToFile);
        BufferedReader reader = new BufferedReader(new InputStreamReader(new GZIPInputStream(new FileInputStream(file))));
        StringBuilder textBuffer = new StringBuilder();
        Integer currindex = -1;
        while (reader.ready()) {
            PubmedDocument pmdoc = new PubmedDocument(jcas);
            String s = reader.readLine();
            if (s == null) continue;
            String pmid = s.substring(0, s.indexOf("\t"));
            String annot = s.substring(s.indexOf("\t"));
            pmdoc.setPmid(pmid);
            textBuffer.append(annot).append("\n");
            pmdoc.setBegin(currindex + 1);
            Integer len = annot.length();
            currindex = currindex + len + 1;
            pmdoc.setEnd(currindex);
            pmdoc.addToIndexes();
        }
        String text2 = textBuffer.toString();
        jcas.setDocumentText(text2);
        SourceDocumentInformation srcDocInfo = new SourceDocumentInformation(jcas);
        srcDocInfo.setUri(file.getAbsoluteFile().toURI().toString());
        srcDocInfo.setOffsetInSource(0);
        srcDocInfo.setDocumentSize((int)file.length());
        srcDocInfo.setBegin(0);
        srcDocInfo.setEnd(currindex);
        srcDocInfo.addToIndexes();
    }

    public static void printTime(String action) {
        if (ChemSpotConfiguration.useComponent(ChemSpotConfiguration.Component.PROFILER)) {
            System.out.printf("%s: %.1f s%n", action, (double)(System.currentTimeMillis() - start) / 1000.0);
            start = System.currentTimeMillis();
        }
    }

    private static void startTimer() {
        long l = start = ChemSpotConfiguration.useComponent(ChemSpotConfiguration.Component.PROFILER) ? System.currentTimeMillis() : 0L;
        if (start != 0L) {
            System.out.println("start profiling...");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public List<Mention> tag(JCas jcas) {
        block31: {
            block30: {
                block32: {
                    otherEntities = null;
                    ChemSpot.startTimer();
                    try {
                        try {
                            if (this.fineTokenizer != null) {
                                this.fineTokenizer.process(jcas);
                                ChemSpot.printTime("tokenization");
                            }
                            var3_3 = this;
                            synchronized (var3_3) {
                                if (this.sentenceDetector != null) {
                                    this.sentenceDetector.process(jcas);
                                    ChemSpot.printTime("sentence detector");
                                }
                                if (this.posTagger != null) {
                                    this.posTagger.process(jcas);
                                    ChemSpot.printTime("POS tagger");
                                }
                            }
                            if (this.tokenConverter != null) {
                                this.tokenConverter.process(jcas);
                                ChemSpot.printTime("token converter");
                            }
                            if (this.sentenceConverter != null) {
                                this.sentenceConverter.process(jcas);
                                ChemSpot.printTime("sentence converter");
                            }
                            if (this.crfTagger != null) {
                                this.crfTagger.process(jcas);
                                ChemSpot.printTime("crf tagger");
                            }
                            if (this.dictionaryTagger != null) {
                                this.dictionaryTagger.process(jcas);
                                ChemSpot.printTime("dictionary tagger");
                            }
                            if (this.chemicalFormulaTagger != null) {
                                this.chemicalFormulaTagger.process(jcas);
                                ChemSpot.printTime("chemical formula tagger");
                            }
                            if (this.abbrevTagger != null) {
                                this.abbrevTagger.process(jcas);
                                ChemSpot.printTime("abbreviation tagger");
                            }
                            if (this.drugTagger != null) {
                                this.drugTagger.process(jcas);
                                ChemSpot.printTime("drug tagger");
                            }
                            if (this.featureGenerator != null) {
                                if (this.normalizer != null) {
                                    this.normalizer.process(jcas);
                                }
                                this.featureGenerator.process(jcas, FeatureTokenGenerator.Feature_Phase.PHASE1);
                                ChemSpot.printTime("feature generation phase 1 (+ preliminary normalization run)");
                            }
                            if (this.stopwordFilter != null) {
                                ChemSpot.printTime("stopword filter");
                            }
                            if (this.mentionExpander != null) {
                                this.mentionExpander.process(jcas);
                                ChemSpot.printTime("mention expander");
                            }
                            if (this.featureGenerator != null) {
                                this.featureGenerator.process(jcas, FeatureTokenGenerator.Feature_Phase.PHASE2);
                                ChemSpot.printTime("feature generator phase 2");
                            }
                            if (this.annotationMerger != null) {
                                this.annotationMerger.process(jcas);
                                ChemSpot.printTime("annotation merger");
                            }
                            if (this.featureGenerator != null) {
                                this.featureGenerator.process(jcas, FeatureTokenGenerator.Feature_Phase.PHASE3);
                                ChemSpot.printTime("feature generator phase 3");
                            }
                            if (this.normalizer != null) {
                                this.normalizer.process(jcas);
                                ChemSpot.printTime("normalizer");
                            }
                            if (this.featureGenerator != null) {
                                this.featureGenerator.process(jcas, FeatureTokenGenerator.Feature_Phase.PHASE4);
                                ChemSpot.printTime("feature generator phase 4");
                            }
                            break block30;
                        }
                        catch (AnalysisEngineProcessException e) {
                            System.err.println("Failed to extract chemicals from text.");
                            e.printStackTrace();
                            if (otherEntities == null || otherEntities.isEmpty()) break block31;
                            ** for (ne : otherEntities)
                        }
                    }
                    catch (Throwable var4_11) {
                        if (otherEntities == null || otherEntities.isEmpty()) break block32;
                        ** for (ne : otherEntities)
                    }
lbl-1000:
                    // 1 sources

                    {
                        ne.addToIndexes();
                        continue;
lbl88:
                        // 1 sources

                        break block31;
                    }
lbl-1000:
                    // 1 sources

                    {
                        ne.addToIndexes();
                        continue;
                    }
                }
                throw var4_11;
            }
            if (otherEntities != null && !otherEntities.isEmpty()) {
                for (NamedEntity ne : otherEntities) {
                    ne.addToIndexes();
                }
            }
        }
        return ChemSpot.getMentions(jcas);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Mention> tag(String text2) {
        long threadId = Thread.currentThread().getId();
        if (!jCases.containsKey(threadId)) {
            Map<Long, JCas> map2 = jCases;
            synchronized (map2) {
                try {
                    jCases.put(threadId, JCasFactory.createJCas(this.typeSystem));
                }
                catch (UIMAException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        JCas jcas = jCases.get(threadId);
        jcas.reset();
        jcas.setDocumentText(text2);
        PubmedDocument pd = new PubmedDocument(jcas);
        pd.setBegin(0);
        pd.setEnd(text2.length());
        pd.setPmid("");
        pd.addToIndexes(jcas);
        return this.tag(jcas);
    }

    public static String convertToIOB(JCas jcas) {
        StringBuilder sb = new StringBuilder();
        HashMap goldAnnotations = new HashMap();
        HashMap pipelineAnnotations = new HashMap();
        System.out.println("Converting annotations to IOB format...");
        Iterator<PubmedDocument> abstracts = JCasUtil.iterator(jcas, PubmedDocument.class);
        while (abstracts.hasNext()) {
            PubmedDocument pubmedAbstract = abstracts.next();
            sb.append("### ").append(pubmedAbstract.getPmid()).append("\n");
            int offset = pubmedAbstract.getBegin();
            String pmid = pubmedAbstract.getPmid();
            List<Token> tokens = JCasUtil.selectCovered(Token.class, pubmedAbstract);
            for (Token token2 : tokens) {
                token2.setLabel("O");
            }
            List<NamedEntity> entities = JCasUtil.selectCovered(NamedEntity.class, pubmedAbstract);
            for (NamedEntity entity : entities) {
                ArrayList<NamedEntity> tempArray;
                int firstTokenBegin = 0;
                int lastTokenEnd = 0;
                String id = entity.getId();
                if (id == null) {
                    id = "";
                }
                if (!"goldstandard".equals(entity.getSource())) {
                    if (pipelineAnnotations.containsKey(pmid)) {
                        ((ArrayList)pipelineAnnotations.get(pmid)).add(entity);
                    } else {
                        tempArray = new ArrayList<NamedEntity>();
                        tempArray.add(entity);
                        pipelineAnnotations.put(pmid, tempArray);
                    }
                    List<Token> entityTokens = JCasUtil.selectCovered(Token.class, entity);
                    boolean first = true;
                    for (Token token3 : entityTokens) {
                        if (first) {
                            if (id.isEmpty()) {
                                token3.setLabel("B-CHEMICAL");
                            } else {
                                token3.setLabel("B-CHEMICAL\t" + id);
                            }
                            first = false;
                            firstTokenBegin = token3.getBegin();
                        } else {
                            token3.setLabel("I-CHEMICAL\t" + id);
                        }
                        lastTokenEnd = token3.getEnd();
                    }
                    assert (entity.getBegin() == firstTokenBegin) : String.valueOf(id) + ": " + entity.getBegin() + " -> " + firstTokenBegin;
                    assert (entity.getEnd() == lastTokenEnd) : String.valueOf(id) + ": " + entity.getEnd() + " -> " + lastTokenEnd;
                    continue;
                }
                if (goldAnnotations.containsKey(pmid)) {
                    ((ArrayList)goldAnnotations.get(pmid)).add(entity);
                    continue;
                }
                tempArray = new ArrayList();
                tempArray.add(entity);
                goldAnnotations.put(pmid, tempArray);
            }
            List<Token> tokensToPrint = JCasUtil.selectCovered(Token.class, pubmedAbstract);
            boolean firstToken = true;
            for (Token token4 : tokensToPrint) {
                if (firstToken && token4.getBegin() - offset != 0) {
                    sb.append(" \t0\t").append(token4.getBegin() - offset).append("\t\t|O\n");
                }
                firstToken = false;
                sb.append(token4.getCoveredText()).append("\t").append(token4.getBegin() - offset).append("\t").append(token4.getEnd() - offset).append("\t\t|").append(token4.getLabel()).append("\n");
            }
        }
        return sb.toString();
    }

    public static String serializeAnnotations(JCas jcas) {
        StringBuilder sb = new StringBuilder();
        Iterator<PubmedDocument> documentIterator = JCasUtil.iterator(jcas, PubmedDocument.class);
        while (documentIterator.hasNext()) {
            PubmedDocument document2 = documentIterator.next();
            int offset = document2.getBegin();
            String pmid = document2.getPmid();
            int numberOfEntities = 0;
            Iterator<NamedEntity> entityIterator = JCasUtil.iterator(document2, NamedEntity.class, true, true);
            while (entityIterator.hasNext()) {
                NamedEntity entity = entityIterator.next();
                if (!"goldstandard".equals(entity.getSource())) {
                    int begin = entity.getBegin() - offset - 1;
                    int end = entity.getEnd() - offset - 2;
                    String text2 = entity.getCoveredText();
                    String id = "";
                    Mention m = new Mention(entity);
                    Constants.ChemicalID[] chemicalIDArray = Constants.ChemicalID.values();
                    int n = chemicalIDArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Constants.ChemicalID type = chemicalIDArray[n2];
                        String tempId = m.getId(type);
                        id = String.valueOf(id) + "\t" + (tempId != null && !tempId.isEmpty() ? tempId : "");
                        ++n2;
                    }
                    sb.append(String.valueOf(pmid) + "\t" + begin + "\t" + end + "\t" + text2 + id + "\n");
                }
                ++numberOfEntities;
            }
            if (numberOfEntities != 0) continue;
            sb.append(String.valueOf(pmid) + "\t-1\t-1\t\\N\t\\N\n");
        }
        return sb.toString();
    }

    public ChemicalNEREvaluator getEvaluator() {
        return this.evaluator;
    }

    public void setEvaluator(ChemicalNEREvaluator evaluator) {
        this.evaluator = evaluator;
    }

    public FeatureTokenGenerator getFeatureTokenGenerator() {
        return this.featureGenerator;
    }
}

