/*
 * Decompiled with CFR 0.152.
 */
package de.berlin.hu.chemspot;

import de.berlin.hu.chemspot.ChemSpot;
import de.berlin.hu.chemspot.ChemSpotArguments;
import de.berlin.hu.chemspot.ChemSpotConfiguration;
import de.berlin.hu.chemspot.ChemicalNEREvaluator;
import de.berlin.hu.chemspot.Mention;
import de.berlin.hu.types.PubmedDocument;
import de.berlin.hu.uima.ae.tagger.brics.DictionaryUpdater;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.apache.uima.UIMAException;
import org.apache.uima.UIMAFramework;
import org.apache.uima.cas.impl.XmiCasSerializer;
import org.apache.uima.collection.CollectionException;
import org.apache.uima.collection.CollectionReader;
import org.apache.uima.examples.SourceDocumentInformation;
import org.apache.uima.examples.xmi.XmiCollectionReader;
import org.apache.uima.jcas.JCas;
import org.apache.uima.resource.metadata.TypeSystemDescription;
import org.apache.uima.tools.components.FileSystemCollectionReader;
import org.apache.uima.util.CasCopier;
import org.apache.uima.util.XMLInputSource;
import org.apache.uima.util.XMLSerializer;
import org.u_compare.shared.semantic.NamedEntity;
import org.uimafit.factory.CollectionReaderFactory;
import org.uimafit.factory.JCasFactory;
import org.uimafit.util.JCasUtil;
import org.xml.sax.SAXException;
import uk.co.flamingpenguin.jewel.cli.ArgumentValidationException;
import uk.co.flamingpenguin.jewel.cli.CliFactory;

public class App {
    private static String pathToModelFile;
    private static String pathToSentenceFile;
    private static String pathToDictionaryFile;
    private static String pathToIDsFile;
    private static String pathToDrugModel;
    private static String pathToOutputFile;
    private static boolean convertToIOB;
    private static ChemSpotArguments arguments;
    private static boolean evaluate;
    private static boolean detailedEvaluation;
    private static boolean threaded;
    private static int threadNr;
    private static String pathToTextFile;
    private static String tagFromCommandLine;
    private static Map<ChemSpotConfiguration.Corpus, String> corpora;
    private static ChemSpotConfiguration.Corpus corpus;
    private static String pathToXMIOutput;
    private static List<JCas> jcases;
    private static ChemicalNEREvaluator otherEvaluator;

    static {
        pathToDictionaryFile = "dict.zip";
        pathToIDsFile = "ids.zip";
        pathToDrugModel = "drug-model.bin";
        convertToIOB = false;
        evaluate = false;
        detailedEvaluation = false;
        threaded = false;
        threadNr = 1;
        corpora = new HashMap<ChemSpotConfiguration.Corpus, String>();
        jcases = null;
        otherEvaluator = new ChemicalNEREvaluator();
    }

    private static void initializeFromConfigurationFile(String pathToPropertiesFile) {
        System.out.println("Loading configuration file...");
        try {
            ChemSpotConfiguration.initialize(pathToPropertiesFile);
        }
        catch (FileNotFoundException e) {
            System.out.println("ERROR: The configuration file \"" + pathToPropertiesFile + "\" was not found.");
            return;
        }
        catch (IOException e) {
            System.out.println("ERROR: A problem occurred while reading the properties file \"" + pathToPropertiesFile + "\"");
            e.printStackTrace();
            return;
        }
        pathToSentenceFile = ChemSpotConfiguration.getSentenceModelPath();
        pathToModelFile = ChemSpotConfiguration.getCRFModelPath();
        pathToDictionaryFile = ChemSpotConfiguration.getDictionaryPath();
        pathToDrugModel = ChemSpotConfiguration.getDrugModelPath();
        pathToOutputFile = ChemSpotConfiguration.getOutputPath();
        pathToXMIOutput = ChemSpotConfiguration.getXMIOutputPath();
        convertToIOB = ChemSpotConfiguration.isConvertToIob();
        evaluate = ChemSpotConfiguration.isEvaluate();
        detailedEvaluation = ChemSpotConfiguration.isDetailedEvaluation();
        threaded = ChemSpotConfiguration.isThreading();
        threadNr = ChemSpotConfiguration.getNumberOfThreads();
        pathToIDsFile = ChemSpotConfiguration.getIdsFilePath();
        HashMap<ChemSpotConfiguration.Corpus, String> nonExistent = new HashMap<ChemSpotConfiguration.Corpus, String>();
        Enum[] enumArray = ChemSpotConfiguration.Corpus.values();
        int n = enumArray.length;
        int n2 = 0;
        while (n2 < n) {
            ChemSpotConfiguration.Corpus corpusType = enumArray[n2];
            String pathToCorpus = ChemSpotConfiguration.getPathToCorpus(corpusType);
            if (pathToCorpus != null) {
                if (new File(pathToCorpus).exists()) {
                    corpora.put(corpusType, pathToCorpus);
                } else {
                    nonExistent.put(corpusType, pathToCorpus);
                }
            }
            ++n2;
        }
        if (!nonExistent.isEmpty()) {
            System.out.printf("WARNING: %d corpora were defined, but %s actually exist. Please check your configuration file at \"%s\"%n", corpora.size() + nonExistent.size(), corpora.isEmpty() ? "none" : "only " + corpora.size(), pathToPropertiesFile);
            if (!corpora.isEmpty()) {
                System.out.println("Non-existing corpora:");
                for (ChemSpotConfiguration.Corpus key : nonExistent.keySet()) {
                    System.out.println("  " + (Object)((Object)key) + " --> " + (String)nonExistent.get((Object)key));
                }
            }
        }
        enumArray = ChemSpotConfiguration.Component.values();
        n = enumArray.length;
        int n3 = 0;
        while (n3 < n) {
            Enum component = enumArray[n3];
            if (!ChemSpotConfiguration.useComponent((ChemSpotConfiguration.Component)component)) {
                System.out.printf("%s component is deactivated%n", component.toString().replace('_', ' ').toLowerCase());
            }
            ++n3;
        }
    }

    private static ChemSpotConfiguration.Corpus promptForCorpus() throws IOException {
        ChemSpotConfiguration.Corpus result2 = null;
        if (corpora.isEmpty()) {
            throw new IOException("There are no corpora defined.");
        }
        BufferedReader reader = new BufferedReader(new InputStreamReader(System.in));
        ArrayList<ChemSpotConfiguration.Corpus> definedCorpora = new ArrayList<ChemSpotConfiguration.Corpus>(corpora.keySet());
        Collections.sort(definedCorpora);
        while (result2 == null) {
            System.out.println();
            System.out.println("There are several corpora defined. Which one would you like to use?");
            int i = 1;
            for (ChemSpotConfiguration.Corpus corpus : definedCorpora) {
                System.out.printf("%d: %s%n", new Object[]{i++, corpus});
            }
            System.out.println();
            String input2 = reader.readLine();
            try {
                int k = Integer.valueOf(input2);
                if (k > 0 && k <= definedCorpora.size()) {
                    result2 = (ChemSpotConfiguration.Corpus)((Object)definedCorpora.get(k - 1));
                    continue;
                }
                System.out.println(String.valueOf(k) + " is not a valid index. Please try again.");
            }
            catch (NumberFormatException k) {
                try {
                    ChemSpotConfiguration.Corpus corpus = ChemSpotConfiguration.Corpus.valueOf(input2.toUpperCase());
                    if (definedCorpora.contains((Object)corpus)) {
                        result2 = corpus;
                        continue;
                    }
                    System.out.println("The " + (Object)((Object)corpus) + " corpus is not defined. Please try again.");
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    System.out.println(String.valueOf(input2.isEmpty() ? "Your input" : input2) + " is neither a valid index nor corpus name. Please try again.");
                }
            }
        }
        return result2;
    }

    public static void main(String[] args) throws UIMAException, IOException {
        try {
            arguments = CliFactory.parseArguments(ChemSpotArguments.class, args);
            if (arguments.isPathToPropertiesFile()) {
                App.initializeFromConfigurationFile(arguments.getPathToPropertiesFile());
            }
            if (arguments.isPathToCRFModelFile()) {
                pathToModelFile = arguments.getPathToCRFModelFile();
            }
            if (arguments.isPathToSentenceModelFile()) {
                pathToSentenceFile = arguments.getPathToSentenceModelFile();
            }
            if (arguments.isPathToXMIOutput()) {
                corpora.put(ChemSpotConfiguration.Corpus.XMI, arguments.getPathToXMIOutput());
            }
            if (arguments.isPathToDictionary()) {
                pathToDictionaryFile = arguments.getPathToDictionary();
            }
            if (arguments.isPathToIDs()) {
                pathToIDsFile = arguments.getPathToIDs();
            }
            if (arguments.isPathToDrugModelFile()) {
                pathToDrugModel = arguments.getPathToDrugModelFile();
            }
            if (arguments.isThreadNr()) {
                threaded = true;
                threadNr = arguments.getThreadNr();
            }
            if (arguments.isPathToTextFile()) {
                pathToTextFile = arguments.getPathToTextFile();
            } else if (arguments.isTagCommandLine()) {
                tagFromCommandLine = arguments.getTagCommandLine();
            } else {
                if (arguments.isPathToIOBCorpora()) {
                    corpora.put(ChemSpotConfiguration.Corpus.IOB, arguments.getPathToIOBCorpora());
                }
                if (arguments.isPathToGZCorpus()) {
                    corpora.put(ChemSpotConfiguration.Corpus.GZ, arguments.getPathToGZCorpus());
                }
                if (arguments.isPathToCRAFTCorpus()) {
                    corpora.put(ChemSpotConfiguration.Corpus.CRAFT, arguments.getPathToCRAFTCorpus());
                }
                if (arguments.isPathToXMICorpus()) {
                    corpora.put(ChemSpotConfiguration.Corpus.XMI, arguments.getPathToXMICorpus());
                }
                if (arguments.isPathToNaCTeMCorpus()) {
                    corpora.put(ChemSpotConfiguration.Corpus.NACTEM, arguments.getPathToNaCTeMCorpus());
                }
                if (arguments.isPathToPatentCorpus()) {
                    corpora.put(ChemSpotConfiguration.Corpus.PATENT, arguments.getPathToNaCTeMCorpus());
                }
                if (arguments.isPathToDDICorpus()) {
                    corpora.put(ChemSpotConfiguration.Corpus.DDI, arguments.getPathToDDICorpus());
                }
                if (arguments.isPathToTextCorpus()) {
                    corpora.put(ChemSpotConfiguration.Corpus.TXT, arguments.getPathToTextCorpus());
                }
                if (arguments.isPathToCHEMDNERCorpus()) {
                    corpora.put(ChemSpotConfiguration.Corpus.CHEMDNER, arguments.getPathToCHEMDNERCorpus());
                }
                if (arguments.isUpdate()) {
                    if (pathToDictionaryFile != null && pathToIDsFile != null) {
                        try {
                            DictionaryUpdater.initialize();
                            DictionaryUpdater.updateFiles(new File(pathToDictionaryFile), new File(pathToIDsFile), ChemSpotConfiguration.isRemoveTemporaryUpdateFiles());
                            System.out.println("Update successful.");
                        }
                        catch (IOException e) {
                            System.out.println("Update failed.");
                            e.printStackTrace();
                        }
                    } else {
                        System.out.println("You need to specify a dictionary and id file for update");
                    }
                }
                if (corpora.isEmpty()) {
                    if (arguments.isUpdate()) {
                        System.exit(0);
                    } else {
                        System.out.println("At least one corpus, a text file or a command line argument has to be provided!");
                        App.usage();
                    }
                }
                corpus = corpora.size() == 1 ? corpora.keySet().iterator().next() : App.promptForCorpus();
            }
            detailedEvaluation = arguments.isDetailedEvaluation() ? true : detailedEvaluation;
            evaluate = detailedEvaluation || arguments.isRunEvaluation() ? true : evaluate;
            boolean bl = convertToIOB = arguments.isConvertToIOB() ? true : convertToIOB;
            if (arguments.isPathToOutputFile()) {
                pathToOutputFile = arguments.getPathToOutputFile();
            } else if (pathToOutputFile != null && corpus != null) {
                pathToOutputFile = String.valueOf(pathToOutputFile) + (Object)((Object)corpus) + "/";
            }
        }
        catch (ArgumentValidationException e) {
            System.out.println(e);
            App.usage();
            System.exit(0);
        }
        ChemSpot chemspot = new ChemSpot(pathToModelFile, pathToDictionaryFile, pathToSentenceFile, pathToIDsFile, pathToDrugModel);
        TypeSystemDescription typeSystem = UIMAFramework.getXMLParser().parseTypeSystemDescription(new XMLInputSource(chemspot.getClass().getClassLoader().getResource("desc/TypeSystem.xml")));
        if (tagFromCommandLine != null) {
            List<Mention> mentions = App.runChemSpot(chemspot, typeSystem, tagFromCommandLine, pathToOutputFile, false);
            for (Mention mention : mentions) {
                System.out.printf("%d\t%d\t%s\t%s\t%s\n", mention.getStart(), mention.getEnd(), mention.getText(), mention.getCHID(), mention.getSource());
            }
        } else if (arguments.isPathToTextFile()) {
            JCas jcas = JCasFactory.createJCas(typeSystem);
            if (arguments.isZippedTextFile()) {
                ChemSpot.readGZFile(jcas, pathToTextFile);
            } else {
                ChemSpot.readFile(jcas, pathToTextFile);
            }
            App.runChemSpot(chemspot, jcas, pathToOutputFile, false);
        } else if (corpus != null) {
            String pathToCorpus = corpora.get((Object)corpus);
            CollectionReader reader = null;
            switch (corpus) {
                case IOB: {
                    reader = CollectionReaderFactory.createCollectionReader(UIMAFramework.getXMLParser().parseCollectionReaderDescription(new XMLInputSource(typeSystem.getClass().getClassLoader().getResource("desc/cr/ScaiCorpusCR.xml"))), "InputDirectory", pathToCorpus, "UseGoldStandardAnnotations", true, "GoldstandardTypeSuffix", "", "BrowseSubdirectories", true, "IncludeSuffixes", new String[]{"iob", "iob2"});
                    break;
                }
                case GZ: {
                    reader = CollectionReaderFactory.createCollectionReader(UIMAFramework.getXMLParser().parseCollectionReaderDescription(new XMLInputSource(typeSystem.getClass().getClassLoader().getResource("desc/cr/ZipFileCR.xml"))), "InputDirectory", pathToCorpus);
                    break;
                }
                case CRAFT: {
                    reader = CollectionReaderFactory.createCollectionReader(UIMAFramework.getXMLParser().parseCollectionReaderDescription(new XMLInputSource(typeSystem.getClass().getClassLoader().getResource("desc/cr/CraftCR.xml"))), "InputDirectory", pathToCorpus);
                    break;
                }
                case NACTEM: {
                    reader = CollectionReaderFactory.createCollectionReader(UIMAFramework.getXMLParser().parseCollectionReaderDescription(new XMLInputSource(typeSystem.getClass().getClassLoader().getResource("desc/cr/NaCTeMCollectionReader.xml"))), "InputDirectory", pathToCorpus);
                    break;
                }
                case PATENT: {
                    reader = CollectionReaderFactory.createCollectionReader(UIMAFramework.getXMLParser().parseCollectionReaderDescription(new XMLInputSource(typeSystem.getClass().getClassLoader().getResource("desc/cr/PatentCorpusCollectionReader.xml"))), "InputDirectory", pathToCorpus);
                    break;
                }
                case TXT: {
                    reader = CollectionReaderFactory.createCollectionReader(FileSystemCollectionReader.class, "InputDirectory", pathToCorpus);
                    break;
                }
                case XMI: {
                    reader = CollectionReaderFactory.createCollectionReader(XmiCollectionReader.class, "InputDirectory", pathToCorpus);
                    break;
                }
                case DDI: {
                    reader = CollectionReaderFactory.createCollectionReader(UIMAFramework.getXMLParser().parseCollectionReaderDescription(new XMLInputSource(typeSystem.getClass().getClassLoader().getResource("desc/cr/DDICorpusCR.xml"))), "InputDirectory", pathToCorpus, "BrowseSubdirectories", true);
                    break;
                }
                case CHEMDNER: {
                    reader = CollectionReaderFactory.createCollectionReader(UIMAFramework.getXMLParser().parseCollectionReaderDescription(new XMLInputSource(typeSystem.getClass().getClassLoader().getResource("desc/cr/CHEMDNERCorpusCR.xml"))), "InputDirectory", pathToCorpus);
                    break;
                }
                default: {
                    throw new IOException("Corpus " + (Object)((Object)corpus) + " does not match any known format.");
                }
            }
            App.tagCollection(chemspot, typeSystem, reader, threaded, threadNr);
        }
    }

    private static List<Mention> runChemSpot(ChemSpot chemspot, TypeSystemDescription typeSystem, String text2, String outputPath, boolean evaluate) {
        JCas jcas;
        try {
            jcas = JCasFactory.createJCas(typeSystem);
        }
        catch (UIMAException e) {
            e.printStackTrace();
            return new ArrayList<Mention>();
        }
        jcas.setDocumentText(text2);
        PubmedDocument pd = new PubmedDocument(jcas);
        pd.setBegin(0);
        pd.setEnd(text2.length());
        pd.setPmid("");
        pd.addToIndexes(jcas);
        return App.runChemSpot(chemspot, jcas, outputPath, evaluate);
    }

    private static List<NamedEntity> removeOtherEntities(JCas jcas) {
        ArrayList<NamedEntity> result2 = new ArrayList<NamedEntity>();
        ArrayList<String> sources = new ArrayList<String>();
        Iterator<NamedEntity> entities = JCasUtil.iterator(jcas, NamedEntity.class);
        while (entities.hasNext()) {
            NamedEntity entity = entities.next();
            if ("goldstandard".equals(entity.getSource())) continue;
            if (!sources.contains(entity.getSource())) {
                sources.add(entity.getSource());
            }
            result2.add(entity);
        }
        for (NamedEntity ne : result2) {
            ne.removeFromIndexes();
        }
        if (!sources.isEmpty()) {
            System.out.println("found pre-exisiting entities from: " + sources);
        }
        return result2;
    }

    private static List<Mention> runChemSpot(ChemSpot chemspot, JCas jcas, String outputPath, boolean evaluate) {
        boolean hasOtherEntities = false;
        for (NamedEntity ne : JCasUtil.iterate(jcas, NamedEntity.class)) {
            if ("goldstandard".equals(ne.getSource())) continue;
            hasOtherEntities = true;
            break;
        }
        if (hasOtherEntities) {
            System.out.println("Pre-existing entities found in document. Evaluating and removing them.");
            otherEvaluator.evaluate(jcas);
            App.removeOtherEntities(jcas);
        }
        if (!JCasUtil.iterator(jcas, PubmedDocument.class).hasNext()) {
            PubmedDocument pd = new PubmedDocument(jcas);
            pd.setBegin(0);
            pd.setEnd(jcas.getDocumentText().length());
            pd.setPmid("");
            pd.addToIndexes(jcas);
        }
        List<Mention> mentions = chemspot.tag(jcas);
        if (evaluate) {
            chemspot.getEvaluator().evaluate(jcas);
        }
        if (pathToOutputFile != null && outputPath != null) {
            String output2 = convertToIOB ? ChemSpot.convertToIOB(jcas) : ChemSpot.serializeAnnotations(jcas);
            try {
                FileWriter outputFile;
                FileWriter fileWriter = outputFile = outputPath != null ? new FileWriter(new File(outputPath)) : null;
                if (outputFile != null) {
                    outputFile.write(output2);
                    System.out.println("\nOutput written to: " + outputPath);
                    outputFile.close();
                }
            }
            catch (IOException e) {
                System.err.println("Error while writing ChemSpot output");
                e.printStackTrace();
            }
        }
        if (pathToXMIOutput != null && outputPath != null) {
            try {
                pathToXMIOutput = String.valueOf(pathToXMIOutput) + (!pathToXMIOutput.endsWith("/") && !pathToXMIOutput.endsWith("\\") ? "/" : "");
                File xmiOutputFile = new File(String.valueOf(pathToXMIOutput) + outputPath.replaceFirst(".*/", "").replaceFirst("\\.[^\\.]+$", "") + ".xmi");
                xmiOutputFile.getParentFile().mkdirs();
                FileOutputStream out = new FileOutputStream(xmiOutputFile);
                XmiCasSerializer serializer = new XmiCasSerializer(jcas.getTypeSystem());
                XMLSerializer xmlSerializer = new XMLSerializer(out, false);
                serializer.serialize(jcas.getCas(), xmlSerializer.getContentHandler());
                ((OutputStream)out).close();
                System.out.println("XMI file written to: " + xmiOutputFile.getCanonicalPath());
            }
            catch (SAXException e) {
                e.printStackTrace();
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return mentions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void tagCollection(ChemSpot chemspot, TypeSystemDescription typeSystem, CollectionReader reader, boolean threaded, int threads) throws CollectionException, UIMAException, IOException {
        ExecutorService threadPool = threaded ? Executors.newFixedThreadPool(threads) : null;
        int runNr = 1;
        File outputPath = pathToOutputFile != null ? new File(pathToOutputFile) : (pathToXMIOutput != null ? new File(pathToOutputFile) : null);
        String filename = null;
        String outputPathString = null;
        if (outputPath != null) {
            if (outputPath.getName().contains(".")) {
                filename = outputPath.getName();
                outputPath = outputPath.getAbsoluteFile().getParentFile();
            }
            if (!outputPath.exists()) {
                outputPath.mkdirs();
            }
            outputPathString = !(outputPathString = outputPath.getCanonicalPath().replaceAll("\\\\", "/")).endsWith("/") ? String.valueOf(outputPathString) + "/" : outputPathString;
        }
        JCas jcas = JCasFactory.createJCas(typeSystem);
        if (threaded) {
            jcases = new ArrayList<JCas>();
            int i = 0;
            while (i < threadNr) {
                jcases.add(JCasFactory.createJCas(typeSystem));
                ++i;
            }
        }
        while (reader.hasNext()) {
            Object prefix;
            String fileType;
            jcas.reset();
            reader.getNext(jcas.getCas());
            String outputFilePath = null;
            String string2 = fileType = convertToIOB ? ".iob" : ".chem";
            if (outputPath != null) {
                Iterator<SourceDocumentInformation> srcIterator = JCasUtil.iterator(jcas, SourceDocumentInformation.class);
                if (filename == null && srcIterator.hasNext()) {
                    SourceDocumentInformation src = srcIterator.next();
                    outputFilePath = String.valueOf(src.getUri().replaceFirst(".*/", outputPathString)) + fileType;
                } else {
                    String pmId;
                    Collection<PubmedDocument> documents;
                    if (runNr == 1 && !reader.hasNext() && filename != null) {
                        outputFilePath = String.valueOf(outputPathString) + filename;
                    } else if (JCasUtil.iterate(jcas, PubmedDocument.class).iterator().hasNext() && (documents = JCasUtil.select(jcas, PubmedDocument.class)).size() == 1 && (pmId = documents.iterator().next().getPmid()) != null && !pmId.isEmpty()) {
                        outputFilePath = String.valueOf(outputPathString) + pmId + fileType;
                    }
                    if (outputFilePath == null) {
                        prefix = "";
                        if (filename != null) {
                            int prefixPos = filename.indexOf(46) > -1 ? filename.indexOf(46) : filename.length();
                            prefix = filename.substring(0, prefixPos);
                        }
                        outputFilePath = String.format("%s%s%04d%s", outputPathString, prefix, runNr, fileType);
                    }
                }
            }
            if (threaded) {
                while (jcases.isEmpty()) {
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException srcIterator) {
                        // empty catch block
                    }
                }
                JCas threadJCas = null;
                prefix = jcases;
                synchronized (prefix) {
                    threadJCas = jcases.remove(0);
                    threadJCas.reset();
                    CasCopier.copyCas(jcas.getCas(), threadJCas.getCas(), true);
                }
                ChemSpotRun run2 = new ChemSpotRun(runNr, chemspot, threadJCas, outputFilePath, evaluate);
                threadPool.submit(run2);
            } else {
                App.runChemSpot(chemspot, jcas, outputFilePath, evaluate);
            }
            ++runNr;
            System.out.println();
        }
        if (threaded) {
            try {
                threadPool.shutdown();
                threadPool.awaitTermination(Long.MAX_VALUE, TimeUnit.DAYS);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        if (detailedEvaluation) {
            chemspot.getEvaluator().writeDetailedEvaluationResults(outputPathString);
            if (otherEvaluator.getTP() + otherEvaluator.getFN() + otherEvaluator.getFP() > 0) {
                ArrayList<Mention> normalizedAll = new ArrayList<Mention>(otherEvaluator.getNormalizedAll());
                ArrayList<Mention> normalized = new ArrayList<Mention>(otherEvaluator.getNormalized());
                ArrayList<Mention> normalizedCorrect = new ArrayList<Mention>(otherEvaluator.getNormalizedCorrect());
                normalized.retainAll(chemspot.getEvaluator().getNormalizedCorrect());
                normalizedAll.retainAll(chemspot.getEvaluator().getNormalizedCorrect());
                normalizedCorrect.retainAll(chemspot.getEvaluator().getNormalizedCorrect());
                File normalizedFoundFile = new File(String.valueOf(outputPathString) + "normalizations-correct-by-ChemSpot.txt");
                FileOutputStream writer = new FileOutputStream(normalizedFoundFile);
                otherEvaluator.writeNormalizations(writer, normalizedAll, normalized, normalizedCorrect);
                writer.close();
                System.out.println("Pre-existing normalized entities found by ChemSpot written to: " + normalizedFoundFile.getName());
                normalizedAll = new ArrayList<Mention>(otherEvaluator.getNormalizedAll());
                normalized = new ArrayList<Mention>(otherEvaluator.getNormalized());
                normalizedCorrect = new ArrayList<Mention>(otherEvaluator.getNormalizedCorrect());
                normalized.removeAll(chemspot.getEvaluator().getNormalizedCorrect());
                normalizedAll.removeAll(chemspot.getEvaluator().getNormalizedCorrect());
                normalizedCorrect.removeAll(chemspot.getEvaluator().getNormalizedCorrect());
                File notNormalizedFoundFile = new File(String.valueOf(outputPathString) + "normalizations-not-correct-by-ChemSpot.txt");
                writer = new FileOutputStream(notNormalizedFoundFile);
                otherEvaluator.writeNormalizations(writer, normalizedAll, normalized, normalizedCorrect);
                writer.close();
                System.out.println("Pre-existing normalized entities not found by ChemSpot written to: " + notNormalizedFoundFile.getName());
            }
        }
    }

    private static void usage() {
        System.out.println("usage:");
        System.out.println("  arguments:");
        System.out.println("\t-m path to a CRF model file (internal default model file will be used if not provided)");
        System.out.println("\t-s path to a OpenNLP sentence model file (internal default model file will be used if not provided)o a OpenNLP sentence model file (internal default model file will be used if not provided)");
        System.out.println("\t-d path to a zipped set of brics dictionary automata (parameter defaults to 'dict.zip' if not provided)");
        System.out.println("\t-i path to a zipped tab-separated text file representing a map of terms to ids (parameter defaults to 'ids.zip' if not provided)");
        System.out.println();
        System.out.println("\t-e if this parameter is set, the performance of ChemSpot on a IOB gold-standard corpus (cf. -c) or CRAFT corpus (cf. -C) is evaluated");
        System.out.println("\t-T number of threads to create when processing a document collection");
        System.out.println();
        System.out.println("  input control:");
        System.out.println("\t-c path to a directory containing corpora in IOB format that should be tagged");
        System.out.println("\t-C path to a directory containing CRAFT corpus files in UIMA XMI format that should be tagged");
        System.out.println("\t-g path to a directory containing gzipped text files that should be tagged");
        System.out.println("\t-t path to a text file that should be tagged");
        System.out.println("\t-f path to a directory of text files that should be tagged");
        System.out.println();
        System.out.println("  output control:");
        System.out.println("\t-o path to output file");
        System.out.println("\t-I set if output should be converted to IOB format");
        System.exit(0);
    }

    private static class ChemSpotRun
    implements Runnable {
        private int runNr = -1;
        private ChemSpot chemspot = null;
        private JCas jCas = null;
        private String outputFile;
        private boolean evaluate;

        public ChemSpotRun(int runNr, ChemSpot chemspot, JCas jCas, String outputFile, boolean evaluate) {
            this.runNr = runNr;
            this.chemspot = chemspot;
            this.jCas = jCas;
            this.outputFile = outputFile;
            this.evaluate = evaluate;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            System.out.println("Starting run " + this.runNr);
            App.runChemSpot(this.chemspot, this.jCas, this.outputFile, this.evaluate);
            System.out.println("Run " + this.runNr + " finished");
            List list2 = jcases;
            synchronized (list2) {
                jcases.add(this.jCas);
            }
        }
    }
}

