/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wsdl.util.xml;

import com.ibm.wsdl.util.xml.QNameUtils;
import com.ibm.wsdl.util.xml.XPathUtils;
import java.io.PrintWriter;
import java.util.List;
import java.util.ListIterator;
import java.util.Vector;
import javax.wsdl.Definition;
import javax.wsdl.WSDLException;
import javax.xml.namespace.QName;
import org.w3c.dom.Attr;
import org.w3c.dom.CharacterData;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class DOMUtils {
    private static String NS_URI_XMLNS = "http://www.w3.org/2000/xmlns/";
    private static final String ATTR_XMLNS = "xmlns";

    public static List getAttributes(Element element) {
        String string2 = null;
        Vector<Node> vector = new Vector<Node>();
        NamedNodeMap namedNodeMap = element.getAttributes();
        for (int i = 0; i < namedNodeMap.getLength(); ++i) {
            String string3 = namedNodeMap.item(i).getNodeName();
            string2 = namedNodeMap.item(i).getPrefix();
            if (ATTR_XMLNS.equals(string3) || ATTR_XMLNS.equals(string2)) continue;
            vector.add(namedNodeMap.item(i));
        }
        return vector;
    }

    public static String getAttribute(Element element, String string2) {
        String string3 = null;
        Attr attr2 = element.getAttributeNode(string2);
        if (attr2 != null) {
            string3 = attr2.getValue();
        }
        return string3;
    }

    public static String getAttribute(Element element, String string2, List list2) {
        String string3 = null;
        Attr attr2 = element.getAttributeNode(string2);
        if (attr2 != null) {
            string3 = attr2.getValue();
            list2.remove(attr2);
        }
        return string3;
    }

    public static String getAttributeNS(Element element, String string2, String string3) {
        String string4 = null;
        Attr attr2 = element.getAttributeNodeNS(string2, string3);
        if (attr2 != null) {
            string4 = attr2.getValue();
        }
        return string4;
    }

    public static String getChildCharacterData(Element element) {
        if (element == null) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (Node node = element.getFirstChild(); node != null; node = node.getNextSibling()) {
            switch (node.getNodeType()) {
                case 3: 
                case 4: {
                    CharacterData characterData = (CharacterData)node;
                    stringBuffer.append(characterData.getData());
                }
            }
        }
        return stringBuffer.toString();
    }

    public static Element getFirstChildElement(Element element) {
        for (Node node = element.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node.getNodeType() != 1) continue;
            return (Element)node;
        }
        return null;
    }

    public static Element getNextSiblingElement(Element element) {
        for (Node node = element.getNextSibling(); node != null; node = node.getNextSibling()) {
            if (node.getNodeType() != 1) continue;
            return (Element)node;
        }
        return null;
    }

    public static Element findChildElementWithAttribute(Element element, String string2, String string3) {
        for (Node node = element.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node.getNodeType() != 1 || !string3.equals(DOMUtils.getAttribute((Element)node, string2))) continue;
            return (Element)node;
        }
        return null;
    }

    public static int countKids(Element element, short s) {
        int n = 0;
        for (Node node = element.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node.getNodeType() != s) continue;
            ++n;
        }
        return n;
    }

    public static String getNamespaceURIFromPrefix(Node node, String string2) {
        short s = node.getNodeType();
        Node node2 = null;
        switch (s) {
            case 2: {
                node2 = ((Attr)node).getOwnerElement();
                break;
            }
            case 1: {
                node2 = node;
                break;
            }
            default: {
                node2 = node.getParentNode();
            }
        }
        while (node2 != null && node2.getNodeType() == 1) {
            String string3;
            Element element = (Element)node2;
            String string4 = string3 = string2 == null ? DOMUtils.getAttribute(element, ATTR_XMLNS) : DOMUtils.getAttributeNS(element, NS_URI_XMLNS, string2);
            if (string3 != null) {
                return string3;
            }
            node2 = element.getParentNode();
        }
        return null;
    }

    public static QName getQName(String string2, Element element, Definition definition) throws WSDLException {
        int n = string2.indexOf(58);
        String string3 = n != -1 ? string2.substring(0, n) : null;
        String string4 = string2.substring(n + 1);
        String string5 = DOMUtils.getNamespaceURIFromPrefix(element, string3);
        if (string5 != null) {
            DOMUtils.registerUniquePrefix(string3, string5, definition);
            return new QName(string5, string4);
        }
        String string6 = string3 == null ? "NO_PREFIX_SPECIFIED" : "UNBOUND_PREFIX";
        WSDLException wSDLException = new WSDLException(string6, "Unable to determine namespace of '" + string2 + "'.");
        wSDLException.setLocation(XPathUtils.getXPathExprFromNode(element));
        throw wSDLException;
    }

    public static void registerUniquePrefix(String string2, String string3, Definition definition) {
        String string4 = definition.getNamespace(string2);
        if (string4 != null && string4.equals(string3)) {
            return;
        }
        while (string4 != null && !string4.equals(string3)) {
            string2 = string2 + "_";
            string4 = definition.getNamespace(string2);
        }
        definition.addNamespace(string2, string3);
    }

    public static QName getQualifiedAttributeValue(Element element, String string2, String string3, boolean bl, Definition definition) throws WSDLException {
        String string4 = DOMUtils.getAttribute(element, string2);
        if (string4 != null) {
            return DOMUtils.getQName(string4, element, definition);
        }
        if (bl) {
            WSDLException wSDLException = new WSDLException("INVALID_WSDL", "The '" + string2 + "' attribute must be " + "specified for every " + string3 + " element.");
            wSDLException.setLocation(XPathUtils.getXPathExprFromNode(element));
            throw wSDLException;
        }
        return null;
    }

    public static QName getQualifiedAttributeValue(Element element, String string2, String string3, boolean bl, Definition definition, List list2) throws WSDLException {
        String string4 = null;
        string4 = DOMUtils.getAttribute(element, string2, list2);
        if (string4 != null) {
            return DOMUtils.getQName(string4, element, definition);
        }
        if (bl) {
            WSDLException wSDLException = new WSDLException("INVALID_WSDL", "The '" + string2 + "' attribute must be " + "specified for every " + string3 + " element.");
            wSDLException.setLocation(XPathUtils.getXPathExprFromNode(element));
            throw wSDLException;
        }
        return null;
    }

    public static void throwWSDLException(Element element) throws WSDLException {
        String string2 = QNameUtils.newQName(element).toString();
        WSDLException wSDLException = new WSDLException("INVALID_WSDL", "Encountered unexpected element '" + string2 + "'.");
        wSDLException.setLocation(XPathUtils.getXPathExprFromNode(element));
        throw wSDLException;
    }

    public static void throwWSDLException(Element element, List list2) throws WSDLException {
        Object object;
        String string2 = QNameUtils.newQName(element).toString();
        StringBuffer stringBuffer = new StringBuffer();
        ListIterator listIterator = list2.listIterator();
        while (listIterator.hasNext()) {
            object = QNameUtils.newQName((Attr)listIterator.next()).toString();
            stringBuffer.append((String)object);
            stringBuffer.append(listIterator.hasNext() ? " " : "");
        }
        object = new WSDLException("INVALID_WSDL", "Element '" + string2 + "' contained unexpected attributes: '" + stringBuffer.toString() + "'");
        ((WSDLException)object).setLocation(XPathUtils.getXPathExprFromNode(element));
        throw object;
    }

    public static void printAttribute(String string2, String string3, PrintWriter printWriter) {
        if (string3 != null) {
            printWriter.print(' ' + string2 + "=\"" + DOMUtils.cleanString(string3) + '\"');
        }
    }

    public static void printQualifiedAttribute(QName qName, String string2, Definition definition, PrintWriter printWriter) throws WSDLException {
        if (qName != null) {
            DOMUtils.printAttribute(DOMUtils.getQualifiedValue(qName.getNamespaceURI(), qName.getLocalPart(), definition), string2, printWriter);
        }
    }

    public static void printQualifiedAttribute(QName qName, QName qName2, Definition definition, PrintWriter printWriter) throws WSDLException {
        if (qName2 != null) {
            DOMUtils.printAttribute(DOMUtils.getQualifiedValue(qName.getNamespaceURI(), qName.getLocalPart(), definition), DOMUtils.getQualifiedValue(qName2.getNamespaceURI(), qName2.getLocalPart(), definition), printWriter);
        }
    }

    public static void printQualifiedAttribute(String string2, QName qName, Definition definition, PrintWriter printWriter) throws WSDLException {
        if (qName != null) {
            DOMUtils.printAttribute(string2, DOMUtils.getQualifiedValue(qName.getNamespaceURI(), qName.getLocalPart(), definition), printWriter);
        }
    }

    public static String getQualifiedValue(String string2, String string3, Definition definition) throws WSDLException {
        String string4 = null;
        if (string2 != null && !string2.equals("")) {
            string4 = DOMUtils.getPrefix(string2, definition);
        }
        return (string4 != null && !string4.equals("") ? string4 + ":" : "") + string3;
    }

    public static String getPrefix(String string2, Definition definition) throws WSDLException {
        String string3 = definition.getPrefix(string2);
        if (string3 == null) {
            throw new WSDLException("OTHER_ERROR", "Can't find prefix for '" + string2 + "'. Namespace prefixes must be set on the" + " Definition object using the " + "addNamespace(...) method.");
        }
        return string3;
    }

    public static String cleanString(String string2) {
        if (string2 == null) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        char[] cArray = string2.toCharArray();
        boolean bl = false;
        for (int i = 0; i < cArray.length; ++i) {
            if (!bl) {
                switch (cArray[i]) {
                    case '&': {
                        stringBuffer.append("&amp;");
                        break;
                    }
                    case '\"': {
                        stringBuffer.append("&quot;");
                        break;
                    }
                    case '\'': {
                        stringBuffer.append("&apos;");
                        break;
                    }
                    case '<': {
                        if (cArray.length >= i + 9) {
                            String string3 = new String(cArray, i, 9);
                            if (string3.equals("<![CDATA[")) {
                                stringBuffer.append(string3);
                                i += 8;
                                bl = true;
                                break;
                            }
                            stringBuffer.append("&lt;");
                            break;
                        }
                        stringBuffer.append("&lt;");
                        break;
                    }
                    case '>': {
                        stringBuffer.append("&gt;");
                        break;
                    }
                    default: {
                        stringBuffer.append(cArray[i]);
                        break;
                    }
                }
                continue;
            }
            stringBuffer.append(cArray[i]);
            if (cArray[i] != '>' || cArray[i - 1] != ']' || cArray[i - 2] != ']') continue;
            bl = false;
        }
        return stringBuffer.toString();
    }
}

