/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wsdl.util.xml;

import com.ibm.wsdl.util.ObjectRegistry;
import com.ibm.wsdl.util.StringUtils;
import com.ibm.wsdl.util.xml.DOMUtils;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DOM2Writer {
    private static String NS_URI_XMLNS = "http://www.w3.org/2000/xmlns/";
    private static String NS_URI_XML = "http://www.w3.org/XML/1998/namespace";
    private static Map xmlEncodingMap = new HashMap();

    public static String nodeToString(Node node) {
        StringWriter stringWriter = new StringWriter();
        DOM2Writer.serializeAsXML(node, stringWriter);
        return stringWriter.toString();
    }

    public static void serializeElementAsDocument(Element element, Writer writer) {
        PrintWriter printWriter = new PrintWriter(writer);
        String string2 = writer instanceof OutputStreamWriter ? ((OutputStreamWriter)writer).getEncoding() : null;
        String string3 = DOM2Writer.java2XMLEncoding(string2);
        if (string3 != null) {
            printWriter.println("<?xml version=\"1.0\" encoding=\"" + string3 + "\"?>");
        } else {
            printWriter.println("<?xml version=\"1.0\"?>");
        }
        DOM2Writer.serializeAsXML(element, writer);
    }

    public static void serializeAsXML(Node node, Writer writer) {
        ObjectRegistry objectRegistry = new ObjectRegistry();
        objectRegistry.register("xml", NS_URI_XML);
        PrintWriter printWriter = new PrintWriter(writer);
        String string2 = writer instanceof OutputStreamWriter ? ((OutputStreamWriter)writer).getEncoding() : null;
        DOM2Writer.print(node, objectRegistry, printWriter, DOM2Writer.java2XMLEncoding(string2));
    }

    private static void print(Node node, ObjectRegistry objectRegistry, PrintWriter printWriter, String string2) {
        if (node == null) {
            return;
        }
        boolean bl = false;
        short s = node.getNodeType();
        switch (s) {
            case 9: {
                if (string2 != null) {
                    printWriter.println("<?xml version=\"1.0\" encoding=\"" + string2 + "\"?>");
                } else {
                    printWriter.println("<?xml version=\"1.0\"?>");
                }
                NodeList nodeList = node.getChildNodes();
                if (nodeList == null) break;
                int n = nodeList.getLength();
                for (int i = 0; i < n; ++i) {
                    DOM2Writer.print(nodeList.item(i), objectRegistry, printWriter, string2);
                }
                break;
            }
            case 1: {
                NamedNodeMap namedNodeMap;
                objectRegistry = new ObjectRegistry(objectRegistry);
                printWriter.print('<' + node.getNodeName());
                String string3 = node.getPrefix();
                String string4 = node.getNamespaceURI();
                if (string3 != null && string4 != null) {
                    boolean bl2 = false;
                    try {
                        String string5 = (String)objectRegistry.lookup(string3);
                        if (string4.equals(string5)) {
                            bl2 = true;
                        }
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        // empty catch block
                    }
                    if (!bl2) {
                        DOM2Writer.printNamespaceDecl(node, objectRegistry, printWriter);
                    }
                }
                int n = (namedNodeMap = node.getAttributes()) != null ? namedNodeMap.getLength() : 0;
                for (int i = 0; i < n; ++i) {
                    Attr attr2 = (Attr)namedNodeMap.item(i);
                    printWriter.print(' ' + attr2.getNodeName() + "=\"" + DOM2Writer.normalize(attr2.getValue()) + '\"');
                    String string6 = attr2.getPrefix();
                    String string7 = attr2.getNamespaceURI();
                    if (string6 == null || string7 == null) continue;
                    boolean bl3 = false;
                    try {
                        String string8 = (String)objectRegistry.lookup(string6);
                        if (string7.equals(string8)) {
                            bl3 = true;
                        }
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        // empty catch block
                    }
                    if (bl3) continue;
                    DOM2Writer.printNamespaceDecl(attr2, objectRegistry, printWriter);
                }
                NodeList nodeList = node.getChildNodes();
                if (nodeList != null) {
                    int n2 = nodeList.getLength();
                    boolean bl4 = bl = n2 > 0;
                    if (bl) {
                        printWriter.print('>');
                    }
                    for (int i = 0; i < n2; ++i) {
                        DOM2Writer.print(nodeList.item(i), objectRegistry, printWriter, string2);
                    }
                } else {
                    bl = false;
                }
                if (bl) break;
                printWriter.print("/>");
                break;
            }
            case 5: {
                printWriter.print('&');
                printWriter.print(node.getNodeName());
                printWriter.print(';');
                break;
            }
            case 4: {
                printWriter.print("<![CDATA[");
                printWriter.print(node.getNodeValue());
                printWriter.print("]]>");
                break;
            }
            case 3: {
                printWriter.print(DOM2Writer.normalize(node.getNodeValue()));
                break;
            }
            case 8: {
                printWriter.print("<!--");
                printWriter.print(node.getNodeValue());
                printWriter.print("-->");
                break;
            }
            case 7: {
                printWriter.print("<?");
                printWriter.print(node.getNodeName());
                String string9 = node.getNodeValue();
                if (string9 != null && string9.length() > 0) {
                    printWriter.print(' ');
                    printWriter.print(string9);
                }
                printWriter.println("?>");
            }
        }
        if (s == 1 && bl) {
            printWriter.print("</");
            printWriter.print(node.getNodeName());
            printWriter.print('>');
            bl = false;
        }
    }

    public static String java2XMLEncoding(String string2) {
        return (String)xmlEncodingMap.get(string2);
    }

    private static void printNamespaceDecl(Node node, ObjectRegistry objectRegistry, PrintWriter printWriter) {
        switch (node.getNodeType()) {
            case 2: {
                DOM2Writer.printNamespaceDecl(((Attr)node).getOwnerElement(), node, objectRegistry, printWriter);
                break;
            }
            case 1: {
                DOM2Writer.printNamespaceDecl((Element)node, node, objectRegistry, printWriter);
            }
        }
    }

    private static void printNamespaceDecl(Element element, Node node, ObjectRegistry objectRegistry, PrintWriter printWriter) {
        String string2 = node.getNamespaceURI();
        String string3 = node.getPrefix();
        if (!string2.equals(NS_URI_XMLNS) || !string3.equals("xmlns")) {
            if (DOMUtils.getAttributeNS(element, NS_URI_XMLNS, string3) == null) {
                printWriter.print(" xmlns:" + string3 + "=\"" + string2 + '\"');
            }
        } else {
            string3 = node.getLocalName();
            string2 = node.getNodeValue();
        }
        objectRegistry.register(string3, string2);
    }

    private static String normalize(String string2) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = string2 != null ? string2.length() : 0;
        block7: for (int i = 0; i < n; ++i) {
            char c = string2.charAt(i);
            switch (c) {
                case '<': {
                    stringBuffer.append("&lt;");
                    continue block7;
                }
                case '>': {
                    stringBuffer.append("&gt;");
                    continue block7;
                }
                case '&': {
                    stringBuffer.append("&amp;");
                    continue block7;
                }
                case '\"': {
                    stringBuffer.append("&quot;");
                    continue block7;
                }
                case '\n': {
                    if (i > 0) {
                        char c2 = stringBuffer.charAt(stringBuffer.length() - 1);
                        if (c2 != '\r') {
                            stringBuffer.append(StringUtils.lineSeparator);
                            continue block7;
                        }
                        stringBuffer.append('\n');
                        continue block7;
                    }
                    stringBuffer.append(StringUtils.lineSeparator);
                    continue block7;
                }
                default: {
                    stringBuffer.append(c);
                }
            }
        }
        return stringBuffer.toString();
    }

    static {
        xmlEncodingMap.put(null, "UTF-8");
        xmlEncodingMap.put(System.getProperty("file.encoding"), "UTF-8");
        xmlEncodingMap.put("UTF8", "UTF-8");
        xmlEncodingMap.put("UTF-16", "UTF-16");
        xmlEncodingMap.put("UnicodeBig", "UTF-16");
        xmlEncodingMap.put("UnicodeLittle", "UTF-16");
        xmlEncodingMap.put("ASCII", "US-ASCII");
        xmlEncodingMap.put("ISO8859_1", "ISO-8859-1");
        xmlEncodingMap.put("ISO8859_2", "ISO-8859-2");
        xmlEncodingMap.put("ISO8859_3", "ISO-8859-3");
        xmlEncodingMap.put("ISO8859_4", "ISO-8859-4");
        xmlEncodingMap.put("ISO8859_5", "ISO-8859-5");
        xmlEncodingMap.put("ISO8859_6", "ISO-8859-6");
        xmlEncodingMap.put("ISO8859_7", "ISO-8859-7");
        xmlEncodingMap.put("ISO8859_8", "ISO-8859-8");
        xmlEncodingMap.put("ISO8859_9", "ISO-8859-9");
        xmlEncodingMap.put("ISO8859_13", "ISO-8859-13");
        xmlEncodingMap.put("ISO8859_15_FDIS", "ISO-8859-15");
        xmlEncodingMap.put("GBK", "GBK");
        xmlEncodingMap.put("Big5", "Big5");
    }
}

