/*
 * Decompiled with CFR 0.152.
 */
package cc.mallet.util.tests;

import cc.mallet.util.search.AStar;
import cc.mallet.util.search.AStarState;
import cc.mallet.util.search.SearchNode;
import cc.mallet.util.search.SearchState;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class TestAStar
extends TestCase {
    public TestAStar(String name) {
        super(name);
    }

    public void testSmall() {
        State node5 = new State(5, 0, 0.0, true);
        State node6 = new State(6, 0, 0.0, true);
        State node2 = new State(2, 1, 6.0, false);
        ((State)node2).next[0] = node5;
        ((State)node2).cost[0] = 6.0;
        State node3 = new State(3, 2, 2.0, false);
        ((State)node3).next[0] = node5;
        ((State)node3).cost[0] = 4.0;
        ((State)node3).next[1] = node6;
        ((State)node3).cost[1] = 2.0;
        State node4 = new State(4, 1, 6.0, false);
        ((State)node4).next[0] = node6;
        ((State)node4).cost[0] = 6.0;
        State node0 = new State(0, 2, 4.0, false);
        ((State)node0).next[0] = node2;
        ((State)node0).cost[0] = 2.0;
        ((State)node0).next[1] = node3;
        ((State)node0).cost[1] = 2.0;
        State node1 = new State(1, 2, 3.0, false);
        ((State)node1).next[0] = node3;
        ((State)node1).cost[0] = 1.0;
        ((State)node1).next[1] = node4;
        ((State)node1).cost[1] = 1.0;
        State[][] paths = new State[6][];
        double[] costs = new double[6];
        paths[0] = new State[]{node6, node3, node1};
        costs[0] = 3.0;
        paths[1] = new State[]{node6, node3, node0};
        costs[1] = 4.0;
        paths[2] = new State[]{node5, node3, node1};
        costs[2] = 5.0;
        paths[3] = new State[]{node5, node3, node0};
        costs[3] = 6.0;
        paths[4] = new State[]{node6, node4, node1};
        costs[4] = 7.0;
        paths[5] = new State[]{node5, node2, node0};
        costs[5] = 8.0;
        AStar s = new AStar(new State[]{node0, node1}, 7);
        int i = 0;
        while (s.hasNext()) {
            SearchNode n;
            TestAStar.assertTrue((String)("number of answers > " + i), (i < 6 ? 1 : 0) != 0);
            TestAStar.assertEquals((String)("costs[" + i + "] != " + n.getPriority()), (double)costs[i], (double)n.getPriority(), (double)1.0E-5);
            int j = 0;
            for (n = s.nextAnswer(); n != null; n = n.getParent()) {
                TestAStar.assertTrue((String)("path length > " + j), (j < 3 ? 1 : 0) != 0);
                TestAStar.assertTrue((String)("path[" + i + "][" + j + "] != " + n), (paths[i][j] == n.getState() ? 1 : 0) != 0);
                ++j;
            }
            TestAStar.assertTrue((String)("path length != " + j), (j == 3 ? 1 : 0) != 0);
            ++i;
        }
        TestAStar.assertTrue((String)("number of answers != " + i), (i == 6 ? 1 : 0) != 0);
    }

    public static Test suite() {
        return new TestSuite(TestAStar.class);
    }

    public static void main(String[] args) {
        TestRunner.run((Test)TestAStar.suite());
    }

    private class State
    implements AStarState {
        private double to;
        private State[] next;
        private double[] cost;
        private int id;
        private boolean sink;

        private State(int id, int numEdges, double to2, boolean sink) {
            this.id = id;
            this.next = new State[numEdges];
            this.cost = new double[numEdges];
            this.to = to2;
            this.sink = sink;
        }

        @Override
        public boolean isFinal() {
            return this.sink;
        }

        @Override
        public double completionCost() {
            return this.to;
        }

        @Override
        public SearchState.NextStateIterator getNextStates() {
            return new NextStates();
        }

        public String toString() {
            return "node " + this.id;
        }

        private class NextStates
        extends SearchState.NextStateIterator {
            private int i = 0;

            private NextStates() {
            }

            @Override
            public boolean hasNext() {
                return this.i < State.this.next.length;
            }

            @Override
            public SearchState nextState() {
                return State.this.next[this.i++];
            }

            @Override
            public double cost() {
                return State.this.cost[this.i - 1];
            }
        }
    }
}

