/*
 * Decompiled with CFR 0.152.
 */
package cc.mallet.types;

import cc.mallet.types.Alphabet;
import cc.mallet.types.FeatureSequence;
import cc.mallet.types.FeatureVector;
import cc.mallet.types.Sequence;
import cc.mallet.types.Token;
import cc.mallet.util.PropertyList;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;

public class TokenSequence
extends ArrayList<Token>
implements Sequence,
Serializable {
    PropertyList properties = null;
    private static final long serialVersionUID = 1L;
    private static final int CURRENT_SERIAL_VERSION = 0;

    public TokenSequence(Collection<Token> tokens) {
        super(tokens);
    }

    public TokenSequence() {
    }

    public TokenSequence(int capacity) {
        super(capacity);
    }

    public TokenSequence(Token[] tokens) {
        this(tokens.length);
        for (int i = 0; i < tokens.length; ++i) {
            this.add(tokens[i]);
        }
    }

    public TokenSequence(Object[] tokens) {
        this(tokens.length);
        for (int i = 0; i < tokens.length; ++i) {
            this.add(new Token(tokens[i].toString()));
        }
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("TokenSequence " + super.toString() + "\n");
        for (int i = 0; i < this.size(); ++i) {
            String tt = ((Token)this.get(i)).toString();
            sb.append("Token#" + i + ":");
            sb.append(tt);
            if (tt.endsWith("\n")) continue;
            sb.append("\n");
        }
        return sb.toString();
    }

    public String toStringShort() {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < this.size(); ++i) {
            String tt = ((Token)this.get(i)).toString();
            tt.replaceAll("\n", "");
            if (i > 0) {
                sb.append(" ");
            }
            sb.append(tt);
        }
        return sb.toString();
    }

    public void add(String string2) {
        this.add(new Token(string2));
    }

    @Override
    public Object removeLast() {
        if (this.size() > 0) {
            return this.remove(this.size() - 1);
        }
        return null;
    }

    public void addAll(Object[] objects) {
        for (int i = 0; i < objects.length; ++i) {
            if (objects[i] instanceof Token) {
                this.add((Token)objects[i]);
                continue;
            }
            this.add(new Token(objects[i].toString()));
        }
    }

    public FeatureSequence toFeatureSequence(Alphabet dict) {
        FeatureSequence fs = new FeatureSequence(dict, this.size());
        for (int i = 0; i < this.size(); ++i) {
            fs.add(dict.lookupIndex(((Token)this.get(i)).getText()));
        }
        return fs;
    }

    public FeatureVector toFeatureVector(Alphabet dict) {
        return new FeatureVector(this.toFeatureSequence(dict));
    }

    public void setNumericProperty(String key, double value2) {
        this.properties = PropertyList.add(key, value2, this.properties);
    }

    public void setProperty(String key, Object value2) {
        this.properties = PropertyList.add(key, value2, this.properties);
    }

    public double getNumericProperty(String key) {
        return this.properties.lookupNumber(key);
    }

    public Object getProperty(String key) {
        return this.properties.lookupObject(key);
    }

    public boolean hasProperty(String key) {
        return this.properties.hasProperty(key);
    }

    public PropertyList getProperties() {
        return this.properties;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeInt(0);
        out.defaultWriteObject();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        int version = in.readInt();
        in.defaultReadObject();
    }
}

