/*
 * Decompiled with CFR 0.152.
 */
package cc.mallet.types;

import cc.mallet.types.Alphabet;
import cc.mallet.types.FeatureVector;
import cc.mallet.types.InfoGain;
import cc.mallet.types.Instance;
import cc.mallet.types.InstanceList;
import cc.mallet.types.RankedFeatureVector;

public class PerLabelInfoGain {
    static final float log2 = (float)Math.log(2.0);
    static boolean binary = true;
    static boolean print = false;
    InfoGain[] ig;

    public PerLabelInfoGain(InstanceList ilist) {
        double[][] pcig = PerLabelInfoGain.calcPerLabelInfoGains(ilist);
        Alphabet v = ilist.getDataAlphabet();
        int numClasses = ilist.getTargetAlphabet().size();
        this.ig = new InfoGain[numClasses];
        for (int i = 0; i < numClasses; ++i) {
            this.ig[i] = new InfoGain(v, pcig[i]);
        }
    }

    public InfoGain getInfoGain(int classIndex) {
        return this.ig[classIndex];
    }

    public int getNumClasses() {
        return this.ig.length;
    }

    private static double entropy(double pc, double pnc) {
        assert (Math.abs(pc + pnc - 1.0) < 1.0E-4) : "pc=" + pc + " pnc=" + pnc;
        if (pc == 0.0 || pnc == 0.0) {
            return 0.0;
        }
        float ret = (float)(-pc * Math.log(pc) / (double)log2 - pnc * Math.log(pnc) / (double)log2);
        assert (ret >= 0.0f) : "pc=" + pc + " pnc=" + pnc;
        return ret;
    }

    public static double[][] calcPerLabelInfoGains(InstanceList ilist) {
        int fi;
        assert (binary);
        int numClasses = ilist.getTargetAlphabet().size();
        int numFeatures = ilist.getDataAlphabet().size();
        int numInstances = ilist.size();
        double[][] classFeatureCounts = new double[numClasses][numFeatures];
        int[] featureCounts = new int[numFeatures];
        int[] classCounts = new int[numClasses];
        for (int i = 0; i < ilist.size(); ++i) {
            int classIndex;
            Instance instance = (Instance)ilist.get(i);
            FeatureVector fv = (FeatureVector)instance.getData();
            int n = classIndex = instance.getLabeling().getBestIndex();
            classCounts[n] = classCounts[n] + 1;
            for (int fvi = 0; fvi < fv.numLocations(); ++fvi) {
                int featureIndex = fv.indexAtLocation(fvi);
                double[] dArray = classFeatureCounts[classIndex];
                int n2 = featureIndex;
                dArray[n2] = dArray[n2] + 1.0;
                int n3 = featureIndex;
                featureCounts[n3] = featureCounts[n3] + 1;
                assert (featureCounts[featureIndex] <= numInstances) : "fi=" + featureIndex + "ni=" + numInstances + " fc=" + featureCounts[featureIndex] + " i=" + i;
            }
        }
        Alphabet v = ilist.getDataAlphabet();
        if (print) {
            for (int ci = 0; ci < numClasses; ++ci) {
                System.out.println(ilist.getTargetAlphabet().lookupObject(ci).toString() + "=" + ci);
            }
        }
        double[] classEntropies = new double[numClasses];
        for (int ci = 0; ci < numClasses; ++ci) {
            double pc = (double)classCounts[ci] / (double)numInstances;
            double pnc = ((double)numInstances - (double)classCounts[ci]) / (double)numInstances;
            classEntropies[ci] = PerLabelInfoGain.entropy(pc, pnc);
        }
        for (fi = 0; fi < numFeatures; ++fi) {
            int ci;
            double pf = (double)featureCounts[fi] / (double)numInstances;
            double pnf = ((double)numInstances - (double)featureCounts[fi]) / (double)numInstances;
            assert (pf >= 0.0);
            assert (pnf >= 0.0);
            if (print && fi < 10000) {
                System.out.print(v.lookupObject(fi).toString());
                for (ci = 0; ci < numClasses; ++ci) {
                    System.out.print(" " + classFeatureCounts[ci][fi]);
                }
                System.out.println("");
            }
            for (ci = 0; ci < numClasses; ++ci) {
                if (featureCounts[fi] == 0) {
                    classFeatureCounts[ci][fi] = 0.0;
                    continue;
                }
                double pc = classFeatureCounts[ci][fi] / (double)featureCounts[fi];
                double pnc = ((double)featureCounts[fi] - classFeatureCounts[ci][fi]) / (double)featureCounts[fi];
                double ef = PerLabelInfoGain.entropy(pc, pnc);
                pc = ((double)classCounts[ci] - classFeatureCounts[ci][fi]) / (double)(numInstances - featureCounts[fi]);
                pnc = ((double)(numInstances - featureCounts[fi]) - ((double)classCounts[ci] - classFeatureCounts[ci][fi])) / (double)(numInstances - featureCounts[fi]);
                double enf = PerLabelInfoGain.entropy(pc, pnc);
                classFeatureCounts[ci][fi] = classEntropies[ci] - (pf * ef + pnf * enf);
                if (!print || fi >= 10000) continue;
                System.out.println("pf=" + pf + " ef=" + ef + " pnf=" + pnf + " enf=" + enf + " e=" + classEntropies[ci] + " cig=" + classFeatureCounts[ci][fi]);
            }
        }
        if (print) {
            for (fi = 0; fi < 100; ++fi) {
                String featureName = v.lookupObject(fi).toString();
                for (int ci = 0; ci < numClasses; ++ci) {
                    String className = ilist.getTargetAlphabet().lookupObject(ci).toString();
                    if (!(classFeatureCounts[ci][fi] > 0.1)) continue;
                    System.out.println(featureName + ',' + className + '=' + classFeatureCounts[ci][fi]);
                }
            }
        }
        return classFeatureCounts;
    }

    public static class Factory
    implements RankedFeatureVector.PerLabelFactory {
        @Override
        public RankedFeatureVector[] newRankedFeatureVectors(InstanceList ilist) {
            PerLabelInfoGain x2 = new PerLabelInfoGain(ilist);
            return x2.ig;
        }
    }
}

