/*
 * Decompiled with CFR 0.152.
 */
package cc.mallet.types;

import cc.mallet.types.ConstantMatrix;
import cc.mallet.types.DenseMatrix;

public class Matrixn
extends DenseMatrix
implements Cloneable {
    int numDimensions;
    int[] sizes;
    private static final long serialVersionUID = 7963668115823191655L;

    public Matrixn(double[] vals) {
        this.numDimensions = 1;
        this.sizes = new int[1];
        this.sizes[0] = vals.length;
        this.values = (double[])vals.clone();
    }

    public Matrixn(int[] szs) {
        this.numDimensions = szs.length;
        this.sizes = szs;
        int total = 1;
        for (int j = 0; j < this.numDimensions; ++j) {
            total *= this.sizes[j];
        }
        this.values = new double[total];
    }

    public Matrixn(int[] szs, double[] vals) {
        this.numDimensions = szs.length;
        this.sizes = (int[])szs.clone();
        this.values = (double[])vals.clone();
    }

    @Override
    public int getNumDimensions() {
        return this.numDimensions;
    }

    @Override
    public int getDimensions(int[] szs) {
        for (int i = 0; i < this.numDimensions; ++i) {
            szs[i] = this.sizes[i];
        }
        return this.numDimensions;
    }

    @Override
    public double value(int[] indices) {
        return this.values[this.singleIndex(indices)];
    }

    @Override
    public void setValue(int[] indices, double value2) {
        this.values[this.singleIndex((int[])indices)] = value2;
    }

    @Override
    public ConstantMatrix cloneMatrix() {
        return new Matrixn(this.sizes, this.values);
    }

    public Object clone() {
        return this.cloneMatrix();
    }

    @Override
    public int singleIndex(int[] indices) {
        return Matrixn.singleIndex(this.sizes, indices);
    }

    public static int singleIndex(int[] szs, int[] indices) {
        int idx = 0;
        for (int dim = 0; dim < indices.length; ++dim) {
            idx = idx * szs[dim] + indices[dim];
        }
        return idx;
    }

    @Override
    public void singleToIndices(int single, int[] indices) {
        int size2 = 1;
        for (int i = 0; i < this.numDimensions; ++i) {
            size2 *= this.sizes[i];
        }
        for (int dim = 0; dim < this.numDimensions; ++dim) {
            indices[dim] = single / (size2 /= this.sizes[dim]);
            single %= size2;
        }
    }

    public static void singleToIndices(int single, int[] indices, int[] szs) {
        int numd = indices.length;
        assert (numd == szs.length);
        int size2 = 1;
        for (int i = 0; i < numd; ++i) {
            size2 *= szs[i];
        }
        for (int dim = 0; dim < numd; ++dim) {
            indices[dim] = single / (size2 /= szs[dim]);
            single %= size2;
        }
    }

    public boolean equals(Object o) {
        if (o instanceof Matrixn) {
            Matrixn m2 = (Matrixn)o;
            return this.numDimensions == m2.numDimensions && this.sizes.equals(m2.sizes) && this.values.equals(m2.values);
        }
        return false;
    }

    public double[] toArray() {
        return this.values;
    }

    public static void main(String[] args) {
        int i;
        double[] m1 = new double[]{1.0, 2.0, 3.0, 4.0};
        int[] idx1 = new int[1];
        Matrixn a = new Matrixn(m1);
        System.out.println("Checking 1-D case");
        a.singleToIndices(3, idx1);
        System.out.println(idx1[0]);
        System.out.println(a.singleIndex(idx1));
        System.out.println("Checking 2-D case");
        int[] sizes = new int[]{2, 3};
        m1 = new double[6];
        for (i = 0; i < 6; ++i) {
            m1[i] = 2.0 * (double)i;
        }
        a = new Matrixn(sizes, m1);
        idx1 = new int[2];
        a.singleToIndices(5, idx1);
        System.out.println("5 => (" + idx1[0] + ", " + idx1[1] + ") => " + a.singleIndex(idx1));
        System.out.println(a.value(idx1));
        System.out.println("Checking 3-D case");
        sizes = new int[]{2, 3, 4};
        idx1 = new int[3];
        m1 = new double[24];
        for (i = 0; i < 24; ++i) {
            m1[i] = 2.0 * (double)i;
        }
        a = new Matrixn(sizes, m1);
        a.singleToIndices(21, idx1);
        System.out.println("21 => (" + idx1[0] + " " + idx1[1] + " " + idx1[2] + ") =>" + a.singleIndex(idx1));
        System.out.println(a.value(idx1));
    }
}

