/*
 * Decompiled with CFR 0.152.
 */
package cc.mallet.types;

import cc.mallet.types.ConstantMatrix;
import cc.mallet.types.DenseMatrix;
import cc.mallet.types.FeatureSelection;
import cc.mallet.types.Vector;
import cc.mallet.util.MalletLogger;
import java.util.Arrays;
import java.util.logging.Logger;

@Deprecated
public final class Matrix2
extends DenseMatrix {
    private static Logger logger = MalletLogger.getLogger(Matrix2.class.getName());
    int nr;
    int nc;

    public Matrix2(double[] values2, int nr, int nc) {
        assert (values2.length == nr * nc);
        this.values = values2;
        this.nr = nr;
        this.nc = nc;
    }

    public Matrix2(int nr, int nc) {
        this(new double[nr * nc], nr, nc);
    }

    public Matrix2(double[][] values2) {
        int i;
        this.nr = values2.length;
        this.nc = values2[0].length;
        for (i = 1; i < this.nr; ++i) {
            if (values2[i].length == this.nc) continue;
            throw new IllegalArgumentException("Trying to initialize Matrix with array having columns to different lengths.");
        }
        this.values = new double[this.nr * this.nc];
        for (i = 0; i < this.nr; ++i) {
            System.arraycopy(values2[i], 0, values2, i * this.nc, this.nc);
        }
    }

    public Matrix2(double value2, int nr, int nc) {
        this.nr = nr;
        this.nc = nc;
        this.values = new double[nr * nc];
        Arrays.fill(this.values, value2);
    }

    @Override
    public int getNumDimensions() {
        return 2;
    }

    @Override
    public int getDimensions(int[] sizes) {
        sizes[0] = this.nr;
        sizes[1] = this.nc;
        return 2;
    }

    public double value(int rowIndex, int colIndex) {
        return this.values[this.nc * rowIndex + colIndex];
    }

    public final void arrayCopyInto(double[] array, int startingArrayIndex) {
        System.arraycopy(this.values, 0, array, startingArrayIndex, this.values.length);
    }

    public final void arrayCopyFrom(double[] array, int startingArrayIndex) {
        System.arraycopy(array, startingArrayIndex, this.values, 0, this.values.length);
    }

    public void setValue(int rowIndex, int colIndex, double value2) {
        this.values[this.nc * rowIndex + colIndex] = value2;
    }

    public boolean sizeMatches(ConstantMatrix m) {
        if (m instanceof Matrix2) {
            return ((Matrix2)m).nr == this.nr && ((Matrix2)m).nc == this.nc;
        }
        int[] otherDims = new int[10];
        int numDimensions = this.getDimensions(otherDims);
        return numDimensions == 2 && otherDims[0] == this.nr && otherDims[1] == this.nc;
    }

    public boolean sizeMatches(Matrix2 m) {
        return m.nr == this.nr && m.nc == this.nc;
    }

    public int getNumRows() {
        return this.nr;
    }

    public int getNumCols() {
        return this.nc;
    }

    public Matrix2 transpose() {
        Matrix2 ret = new Matrix2(this.nc, this.nr);
        for (int i = 0; i < this.nr; ++i) {
            for (int j = 0; j < this.nc; ++j) {
                ret.values[j * this.nr + i] = this.values[i * this.nc + j];
            }
        }
        return ret;
    }

    @Override
    public final double value(int[] indices) {
        assert (indices.length == 2);
        return this.values[indices[0] * this.nc + indices[1]];
    }

    @Override
    public final void setValue(int[] indices, double val) {
        assert (indices.length == 2);
        this.values[indices[0] * this.nc + indices[1]] = val;
    }

    @Override
    public final int singleIndex(int[] indices) {
        assert (indices.length == 2);
        return indices[indices[0] * this.nc + indices[1]];
    }

    @Override
    public final void singleToIndices(int i, int[] indices) {
        assert (indices.length == 2);
        assert (i < this.nc * this.nr);
        indices[0] = i / this.nc;
        indices[1] = i % this.nc;
    }

    @Override
    public final double singleValue(int i) {
        return this.values[i];
    }

    public final void setSingle(int i, double value2) {
        this.values[i] = value2;
    }

    @Override
    public final int singleSize() {
        return this.nc * this.nr;
    }

    @Override
    public final ConstantMatrix cloneMatrix() {
        return this.cloneMatrix2();
    }

    public final Matrix2 cloneMatrix2() {
        Matrix2 ret = new Matrix2(this.nr, this.nc);
        System.arraycopy(this.values, 0, ret.values, 0, this.values.length);
        return ret;
    }

    @Override
    public final void setAll(double v) {
        for (int i = 0; i < this.values.length; ++i) {
            this.values[i] = v;
        }
    }

    public final void setAll(double v, FeatureSelection fselection, boolean ifSelected) {
        if (fselection == null) {
            if (ifSelected) {
                logger.info("Matrix2.setAll using FeatureSelection==null");
                this.setAll(v);
            }
        } else {
            logger.info("Matrix2.setAll using FeatureSelection");
            for (int i = 0; i < this.values.length; ++i) {
                if (!(fselection.contains(i) ^ !ifSelected)) continue;
                this.values[i] = v;
            }
        }
    }

    public final void rowSetAll(int ri, double v, FeatureSelection fselection, boolean ifSelected) {
        block4: {
            block3: {
                assert (ri < this.nr);
                if (fselection != null) break block3;
                if (!ifSelected) break block4;
                for (int ci = 0; ci < this.nc; ++ci) {
                    this.values[ri * this.nc + ci] = v;
                }
                break block4;
            }
            for (int ci = 0; ci < this.nc; ++ci) {
                if (!(fselection.contains(ci) ^ !ifSelected)) continue;
                this.values[ri * this.nc + ci] = v;
            }
        }
    }

    public final void plusEquals(int ri, int ci, double value2) {
        assert (ri < this.nr);
        assert (ci < this.nc);
        int n = ri * this.nc + ci;
        this.values[n] = this.values[n] + value2;
    }

    public final void rowPlusEquals(int ri, Vector v, double factor) {
        assert (ri < this.nr);
        for (int vli = 0; vli < v.numLocations(); ++vli) {
            int n = ri * this.nc + v.indexAtLocation(vli);
            this.values[n] = this.values[n] + v.valueAtLocation(vli) * factor;
        }
    }

    public final void rowPlusEquals(int ri, double v, double factor) {
        assert (ri < this.nr);
        for (int vli = 0; vli < this.nc; ++vli) {
            int n = ri * this.nc + vli;
            this.values[n] = this.values[n] + v * factor;
        }
    }

    public final void columnPlusEquals(int ci, Vector v, double factor) {
        assert (ci < this.nc);
        for (int vli = 0; vli < v.numLocations(); ++vli) {
            int n = v.indexAtLocation(vli) * this.nc + ci;
            this.values[n] = this.values[n] + v.valueAtLocation(vli) * factor;
        }
    }

    public final void columnPlusEquals(int ci, double v, double factor) {
        assert (ci < this.nc);
        for (int vli = 0; vli < this.nr; ++vli) {
            int n = vli * this.nc + ci;
            this.values[n] = this.values[n] + v * factor;
        }
    }

    public final double rowDotProduct(int ri, Vector v) {
        double ret = 0.0;
        for (int cil = 0; cil < v.numLocations(); ++cil) {
            int ci = v.indexAtLocation(cil);
            if (ci >= this.nc) continue;
            ret += this.values[ri * this.nc + ci] * v.valueAtLocation(cil);
        }
        return ret;
    }

    public final double rowDotProduct(int ri, Vector v, int maxCi, FeatureSelection selection) {
        double ret = 0.0;
        if (selection != null) {
            for (int cil = 0; cil < v.numLocations(); ++cil) {
                int ci = v.indexAtLocation(cil);
                if (!selection.contains(ci) || ci >= this.nc || ci > maxCi) continue;
                ret += this.values[ri * this.nc + ci] * v.valueAtLocation(cil);
            }
        } else {
            for (int cil = 0; cil < v.numLocations(); ++cil) {
                int ci = v.indexAtLocation(cil);
                if (ci >= this.nc || ci > maxCi) continue;
                ret += this.values[ri * this.nc + ci] * v.valueAtLocation(cil);
            }
        }
        return ret;
    }

    public final double twoNormSquared() {
        double ret = 0.0;
        for (int i = 0; i < this.values.length; ++i) {
            ret += this.values[i] * this.values[i];
        }
        return ret;
    }

    @Override
    public void print() {
        for (int i = 0; i < this.nr; ++i) {
            for (int j = 0; j < this.nc; ++j) {
                System.out.print(" " + this.values[i * this.nc + j]);
            }
            System.out.println("");
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < this.nr; ++i) {
            for (int j = 0; j < this.nc; ++j) {
                sb.append(" " + this.values[i * this.nc + j]);
            }
            sb.append("\n");
        }
        return sb.toString();
    }
}

