/*
 * Decompiled with CFR 0.152.
 */
package cc.mallet.types;

import cc.mallet.types.ConstantMatrix;
import cc.mallet.types.Matrix;
import cc.mallet.util.Maths;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

public abstract class DenseMatrix
implements Matrix,
Serializable {
    double[] values;
    protected boolean hasInfinite;
    private static final long serialVersionUID = 1L;
    private static final int CURRENT_SERIAL_VERSION = 0;
    private static final int NULL_INTEGER = -1;

    @Override
    public abstract int getNumDimensions();

    @Override
    public abstract int getDimensions(int[] var1);

    @Override
    public abstract double value(int[] var1);

    @Override
    public abstract void setValue(int[] var1, double var2);

    @Override
    public abstract ConstantMatrix cloneMatrix();

    @Override
    public abstract int singleIndex(int[] var1);

    @Override
    public abstract void singleToIndices(int var1, int[] var2);

    @Override
    public double singleValue(int i) {
        return this.values[i];
    }

    @Override
    public void setSingleValue(int i, double value2) {
        this.values[i] = value2;
    }

    @Override
    public void incrementSingleValue(int i, double delta) {
        int n = i;
        this.values[n] = this.values[n] + delta;
    }

    @Override
    public void setValueAtLocation(int loc, double value2) {
        this.setSingleValue(loc, value2);
    }

    @Override
    public int singleSize() {
        return this.values.length;
    }

    @Override
    public int numLocations() {
        return this.values.length;
    }

    @Override
    public int location(int index) {
        return index;
    }

    @Override
    public double valueAtLocation(int location) {
        return this.values[location];
    }

    @Override
    public int indexAtLocation(int location) {
        return location;
    }

    @Override
    public void setAll(double v) {
        for (int i = 0; i < this.values.length; ++i) {
            this.values[i] = v;
        }
    }

    @Override
    public void set(ConstantMatrix m) {
        if (m instanceof DenseMatrix) {
            assert (m.singleSize() == this.values.length);
            System.arraycopy(((DenseMatrix)m).values, 0, this.values, 0, this.values.length);
        } else {
            for (int i = m.numLocations() - 1; i >= 0; --i) {
                this.values[m.indexAtLocation((int)i)] = m.valueAtLocation(i);
            }
        }
    }

    @Override
    public void setWithAddend(ConstantMatrix m, double addend) {
        if (m instanceof DenseMatrix) {
            assert (m.singleSize() == this.values.length);
            for (int i = 0; i < this.values.length; ++i) {
                this.values[i] = ((DenseMatrix)m).values[i] + addend;
            }
        } else {
            for (int i = m.numLocations() - 1; i >= 0; --i) {
                this.values[m.indexAtLocation((int)i)] = m.valueAtLocation(i) + addend;
            }
        }
    }

    @Override
    public void setWithFactor(ConstantMatrix m, double factor) {
        if (m instanceof DenseMatrix) {
            assert (m.singleSize() == this.values.length);
            for (int i = 0; i < this.values.length; ++i) {
                this.values[i] = ((DenseMatrix)m).values[i] * factor;
            }
        } else {
            for (int i = m.numLocations() - 1; i >= 0; --i) {
                this.values[m.indexAtLocation((int)i)] = m.valueAtLocation(i) * factor;
            }
        }
    }

    public void plusEquals(double v) {
        int i = 0;
        while (i < this.values.length) {
            int n = i++;
            this.values[n] = this.values[n] + v;
        }
    }

    @Override
    public void plusEquals(ConstantMatrix m) {
        if (m instanceof DenseMatrix) {
            assert (m.singleSize() == this.values.length);
            for (int i = 0; i < this.values.length; ++i) {
                if (Double.isInfinite(this.values[i]) && Double.isInfinite(m.valueAtLocation(i))) {
                    double newValue = m.valueAtLocation(i);
                    if (newValue * this.values[i] < 0.0) {
                        this.values[i] = 0.0;
                        continue;
                    }
                    int n = i;
                    this.values[n] = this.values[n] + newValue;
                    continue;
                }
                int n = i;
                this.values[n] = this.values[n] + m.valueAtLocation(i);
            }
        } else {
            for (int i = m.numLocations() - 1; i >= 0; --i) {
                if (Double.isInfinite(this.values[m.indexAtLocation(i)]) && Double.isInfinite(((DenseMatrix)m).values[i])) {
                    double newValue = m.valueAtLocation(i);
                    if (newValue * this.values[m.indexAtLocation(i)] < 0.0) {
                        this.values[m.indexAtLocation((int)i)] = 0.0;
                        continue;
                    }
                    int n = m.indexAtLocation(i);
                    this.values[n] = this.values[n] + newValue;
                    continue;
                }
                int n = m.indexAtLocation(i);
                this.values[n] = this.values[n] + m.valueAtLocation(i);
            }
        }
    }

    @Override
    public void plusEquals(ConstantMatrix m, double factor) {
        if (m instanceof DenseMatrix) {
            assert (m.singleSize() == this.values.length);
            for (int i = 0; i < this.values.length; ++i) {
                if (Double.isInfinite(this.values[i]) && Double.isInfinite(m.valueAtLocation(i))) {
                    double newValue = factor * m.valueAtLocation(i);
                    if (newValue * this.values[i] < 0.0) {
                        this.values[i] = 0.0;
                        continue;
                    }
                    int n = i;
                    this.values[n] = this.values[n] + newValue;
                    continue;
                }
                int n = i;
                this.values[n] = this.values[n] + m.valueAtLocation(i) * factor;
            }
        } else {
            for (int i = m.numLocations() - 1; i >= 0; --i) {
                if (Double.isInfinite(this.values[m.indexAtLocation(i)]) && Double.isInfinite(m.valueAtLocation(i))) {
                    double newValue = factor * m.valueAtLocation(i);
                    if (newValue * this.values[m.indexAtLocation(i)] < 0.0) {
                        this.values[m.indexAtLocation((int)i)] = 0.0;
                        continue;
                    }
                    int n = m.indexAtLocation(i);
                    this.values[n] = this.values[n] + newValue;
                    continue;
                }
                int n = m.indexAtLocation(i);
                this.values[n] = this.values[n] + m.valueAtLocation(i) * factor;
            }
        }
    }

    @Override
    public void equalsPlus(double factor, ConstantMatrix m) {
        if (m instanceof DenseMatrix) {
            assert (m.singleSize() == this.values.length);
            for (int i = 0; i < this.values.length; ++i) {
                if (Double.isInfinite(this.values[i]) && Double.isInfinite(((DenseMatrix)m).values[i])) {
                    double lhs = factor * this.values[i];
                    double rhs = ((DenseMatrix)m).values[i];
                    if (lhs * rhs < 0.0) {
                        this.values[i] = 0.0;
                        continue;
                    }
                    this.values[i] = lhs + rhs;
                    continue;
                }
                this.values[i] = factor * this.values[i] + ((DenseMatrix)m).values[i];
            }
        } else {
            for (int i = m.numLocations() - 1; i >= 0; --i) {
                if (Double.isInfinite(this.values[m.indexAtLocation(i)]) && Double.isInfinite(((DenseMatrix)m).values[i])) {
                    double rhs;
                    double lhs = factor * this.values[m.indexAtLocation(i)];
                    if (lhs * (rhs = m.valueAtLocation(i)) < 0.0) {
                        this.values[m.indexAtLocation((int)i)] = 0.0;
                        continue;
                    }
                    this.values[m.indexAtLocation((int)i)] = lhs + rhs;
                    continue;
                }
                this.values[m.indexAtLocation((int)i)] = factor * this.values[m.indexAtLocation(i)] + m.valueAtLocation(i);
            }
        }
    }

    @Override
    public void timesEquals(double factor) {
        int i = 0;
        while (i < this.values.length) {
            int n = i++;
            this.values[n] = this.values[n] * factor;
        }
    }

    @Override
    public void elementwiseTimesEquals(ConstantMatrix m) {
        if (m instanceof DenseMatrix) {
            assert (m.singleSize() == this.values.length);
            for (int i = 0; i < this.values.length; ++i) {
                int n = i;
                this.values[n] = this.values[n] * ((DenseMatrix)m).values[i];
            }
        } else {
            for (int i = m.numLocations() - 1; i >= 0; --i) {
                int n = m.indexAtLocation(i);
                this.values[n] = this.values[n] * m.valueAtLocation(i);
            }
        }
    }

    @Override
    public void elementwiseTimesEquals(ConstantMatrix m, double factor) {
        if (m instanceof DenseMatrix) {
            assert (m.singleSize() == this.values.length);
            for (int i = 0; i < this.values.length; ++i) {
                int n = i;
                this.values[n] = this.values[n] * (((DenseMatrix)m).values[i] * factor);
            }
        } else {
            for (int i = m.numLocations() - 1; i >= 0; --i) {
                int n = m.indexAtLocation(i);
                this.values[n] = this.values[n] * (m.valueAtLocation(i) * factor);
            }
        }
    }

    @Override
    public void divideEquals(double factor) {
        int i = 0;
        while (i < this.values.length) {
            int n = i++;
            this.values[n] = this.values[n] / factor;
        }
    }

    @Override
    public void elementwiseDivideEquals(ConstantMatrix m) {
        if (m instanceof DenseMatrix) {
            assert (m.singleSize() == this.values.length);
            for (int i = 0; i < this.values.length; ++i) {
                int n = i;
                this.values[n] = this.values[n] / ((DenseMatrix)m).values[i];
            }
        } else {
            for (int i = m.numLocations() - 1; i >= 0; --i) {
                int n = m.indexAtLocation(i);
                this.values[n] = this.values[n] / m.valueAtLocation(i);
            }
        }
    }

    @Override
    public void elementwiseDivideEquals(ConstantMatrix m, double factor) {
        if (m instanceof DenseMatrix) {
            assert (m.singleSize() == this.values.length);
            for (int i = 0; i < this.values.length; ++i) {
                int n = i;
                this.values[n] = this.values[n] / (((DenseMatrix)m).values[i] * factor);
            }
        } else {
            for (int i = m.numLocations() - 1; i >= 0; --i) {
                int n = m.indexAtLocation(i);
                this.values[n] = this.values[n] / (m.valueAtLocation(i) * factor);
            }
        }
    }

    @Override
    public double dotProduct(ConstantMatrix m) {
        double ret = 0.0;
        if (m instanceof DenseMatrix) {
            assert (m.singleSize() == this.values.length);
            for (int i = 0; i < this.values.length; ++i) {
                ret += this.values[i] * ((DenseMatrix)m).values[i];
            }
        } else {
            for (int i = m.numLocations() - 1; i >= 0; --i) {
                if (m.indexAtLocation(i) >= this.values.length) continue;
                ret += this.values[m.indexAtLocation(i)] * m.valueAtLocation(i);
            }
        }
        return ret;
    }

    @Override
    public double absNorm() {
        double ret = 0.0;
        for (int i = 0; i < this.values.length; ++i) {
            ret += Math.abs(this.values[i]);
        }
        return ret;
    }

    @Override
    public double oneNorm() {
        double ret = 0.0;
        for (int i = 0; i < this.values.length; ++i) {
            ret += this.values[i];
        }
        return ret;
    }

    @Override
    public double twoNorm() {
        double ret = 0.0;
        for (int i = 0; i < this.values.length; ++i) {
            ret += this.values[i] * this.values[i];
        }
        return Math.sqrt(ret);
    }

    @Override
    public double infinityNorm() {
        double max2 = Double.NEGATIVE_INFINITY;
        for (int i = 0; i < this.values.length; ++i) {
            if (!(Math.abs(this.values[i]) > max2)) continue;
            max2 = Math.abs(this.values[i]);
        }
        return max2;
    }

    @Override
    public double oneNormalize() {
        double norm = this.oneNorm();
        int i = 0;
        while (i < this.values.length) {
            int n = i++;
            this.values[n] = this.values[n] / norm;
        }
        return norm;
    }

    @Override
    public double twoNormalize() {
        double norm = this.twoNorm();
        int i = 0;
        while (i < this.values.length) {
            int n = i++;
            this.values[n] = this.values[n] / norm;
        }
        return norm;
    }

    @Override
    public double absNormalize() {
        double norm = this.absNorm();
        if (norm > 0.0) {
            int i = 0;
            while (i < this.values.length) {
                int n = i++;
                this.values[n] = this.values[n] / norm;
            }
        }
        return norm;
    }

    @Override
    public double infinityNormalize() {
        double norm = this.infinityNorm();
        int i = 0;
        while (i < this.values.length) {
            int n = i++;
            this.values[n] = this.values[n] / norm;
        }
        return norm;
    }

    @Override
    public void print() {
        for (int i = 0; i < this.values.length; ++i) {
            System.out.println("DenseMatrix[" + i + "] = " + this.values[i]);
        }
    }

    @Override
    public boolean isNaN() {
        for (int i = 0; i < this.values.length; ++i) {
            if (!Double.isNaN(this.values[i])) continue;
            return true;
        }
        return false;
    }

    public final void substitute(double oldValue, double newValue) {
        for (int i = this.values.length - 1; i >= 0; --i) {
            if (this.values[i] != oldValue) continue;
            this.values[i] = newValue;
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeInt(0);
        if (this.values != null) {
            int size2 = this.values.length;
            out.writeInt(size2);
            for (int i = 0; i < size2; ++i) {
                out.writeDouble(this.values[i]);
            }
        } else {
            out.writeInt(-1);
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.hasInfinite = false;
        int version = in.readInt();
        int size2 = in.readInt();
        if (size2 != -1) {
            this.values = new double[size2];
            for (int i = 0; i < size2; ++i) {
                this.values[i] = in.readDouble();
                if (!Double.isInfinite(this.values[i])) continue;
                this.hasInfinite = true;
            }
        } else {
            this.values = null;
        }
    }

    public static void plusEquals(double[] accumulator, double[] addend) {
        assert (accumulator.length == addend.length);
        for (int i = 0; i < addend.length; ++i) {
            int n = i;
            accumulator[n] = accumulator[n] + addend[i];
        }
    }

    public static void plusEquals(double[] accumulator, double[] addend, double factor) {
        assert (accumulator.length == addend.length);
        for (int i = 0; i < addend.length; ++i) {
            int n = i;
            accumulator[n] = accumulator[n] + factor * addend[i];
        }
    }

    public static void timesEquals(double[] accumulator, double[] product2) {
        assert (accumulator.length == product2.length);
        for (int i = 0; i < product2.length; ++i) {
            int n = i;
            accumulator[n] = accumulator[n] * product2[i];
        }
    }

    public static double infinityNorm(double[] vector) {
        double max2 = Double.NEGATIVE_INFINITY;
        for (int i = 0; i < vector.length; ++i) {
            if (!(Math.abs(vector[i]) > max2)) continue;
            max2 = Math.abs(vector[i]);
        }
        return max2;
    }

    public boolean almostEquals(ConstantMatrix m2) {
        int i;
        if (this.getNumDimensions() != m2.getNumDimensions()) {
            return false;
        }
        if (this.numLocations() != m2.numLocations()) {
            return false;
        }
        int[] dims1 = new int[this.getNumDimensions()];
        int[] dims2 = new int[this.getNumDimensions()];
        this.getDimensions(dims1);
        m2.getDimensions(dims2);
        for (i = 0; i < dims1.length; ++i) {
            if (dims1[i] == dims2[i]) continue;
            return false;
        }
        for (i = 0; i < this.numLocations(); ++i) {
            if (Maths.almostEquals(this.valueAtLocation(i), m2.valueAtLocation(i))) continue;
            return false;
        }
        return true;
    }
}

