/*
 * Decompiled with CFR 0.152.
 */
package cc.mallet.pipe.tsf;

import cc.mallet.pipe.Pipe;
import cc.mallet.types.Instance;
import cc.mallet.types.Token;
import cc.mallet.types.TokenSequence;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Reader;
import java.io.Serializable;
import java.util.Hashtable;
import java.util.StringTokenizer;

public class TrieLexiconMembership
extends Pipe
implements Serializable {
    String name;
    boolean ignoreCase;
    TrieLexicon lexicon;
    private static final long serialVersionUID = 1L;
    private static final int CURRENT_SERIAL_VERSION = 0;

    public TrieLexiconMembership(String name, Reader lexiconReader, boolean ignoreCase) {
        this.name = name;
        this.lexicon = new TrieLexicon(name, ignoreCase);
        LineNumberReader reader = new LineNumberReader(lexiconReader);
        while (true) {
            String line;
            try {
                line = reader.readLine();
            }
            catch (IOException e) {
                throw new IllegalStateException();
            }
            if (line == null) break;
            this.lexicon.add(line);
        }
        if (this.lexicon.size() == 0) {
            throw new IllegalArgumentException("Empty lexicon");
        }
    }

    public TrieLexiconMembership(String name, Reader lexiconReader, boolean ignoreCase, boolean includeDelims, String delim) {
        this.name = name;
        this.lexicon = new TrieLexicon(name, ignoreCase);
        LineNumberReader reader = new LineNumberReader(lexiconReader);
        while (true) {
            String line;
            try {
                line = reader.readLine();
            }
            catch (IOException e) {
                throw new IllegalStateException();
            }
            if (line == null) break;
            this.lexicon.add(line, includeDelims, delim);
        }
        if (this.lexicon.size() == 0) {
            throw new IllegalArgumentException("Empty lexicon");
        }
    }

    public TrieLexiconMembership(String name, File lexiconFile, boolean ignoreCase) throws FileNotFoundException {
        this(name, new BufferedReader(new FileReader(lexiconFile)), ignoreCase);
    }

    public TrieLexiconMembership(String name, File lexiconFile, boolean ignoreCase, boolean includeDelims, String delim) throws FileNotFoundException {
        this(name, new BufferedReader(new FileReader(lexiconFile)), ignoreCase, includeDelims, delim);
    }

    public TrieLexiconMembership(File lexiconFile, boolean ignoreCase) throws FileNotFoundException {
        this(lexiconFile.getName(), lexiconFile, ignoreCase);
    }

    public TrieLexiconMembership(File lexiconFile) throws FileNotFoundException {
        this(lexiconFile.getName(), lexiconFile, true);
    }

    @Override
    public Instance pipe(Instance carrier) {
        TokenSequence ts = (TokenSequence)carrier.getData();
        this.lexicon.addFeatures(ts);
        return carrier;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeInt(0);
        out.writeObject(this.name);
        out.writeObject(this.lexicon);
        out.writeBoolean(this.ignoreCase);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        int version = in.readInt();
        this.name = (String)in.readObject();
        this.lexicon = (TrieLexicon)in.readObject();
        this.ignoreCase = in.readBoolean();
    }

    private static class TrieLexicon
    implements Serializable {
        static final String END_OF_WORD_TOKEN = "end_of_word";
        String name;
        boolean ignoreCase;
        Hashtable lex;
        int size;
        private static final long serialVersionUID = 1L;
        private static final int CURRENT_SERIAL_VERSION = 0;

        public TrieLexicon(String name, boolean ignoreCase) {
            this.name = name;
            this.ignoreCase = ignoreCase;
            this.lex = new Hashtable();
            this.size = 0;
        }

        public void add(String word) {
            this.add(word, false, " ");
        }

        public void add(String word, boolean includeDelims, String delim) {
            boolean newWord = false;
            StringTokenizer st = new StringTokenizer(word, delim, includeDelims);
            Hashtable currentLevel = this.lex;
            while (st.hasMoreTokens()) {
                String token2 = st.nextToken();
                if (this.ignoreCase) {
                    token2 = token2.toLowerCase();
                }
                if (!currentLevel.containsKey(token2)) {
                    currentLevel.put(token2, new Hashtable());
                    newWord = true;
                }
                currentLevel = (Hashtable)currentLevel.get(token2);
            }
            currentLevel.put(END_OF_WORD_TOKEN, "");
            if (newWord) {
                ++this.size;
            }
        }

        public void addFeatures(TokenSequence ts) {
            int i = 0;
            while (i < ts.size()) {
                int j = this.endOfWord(ts, i);
                if (j == -1) {
                    ++i;
                    continue;
                }
                while (i <= j) {
                    Token t = (Token)ts.get(i);
                    t.setFeatureValue(this.name, 1.0);
                    ++i;
                }
            }
        }

        private int endOfWord(TokenSequence ts, int start) {
            if (start < 0 || start >= ts.size()) {
                System.err.println("Lexicon.lastIndexOf: error - out of TokenSequence boundaries");
                return -1;
            }
            Hashtable currentLevel = this.lex;
            int end = -1;
            for (int i = start; i < ts.size(); ++i) {
                Token t = (Token)ts.get(i);
                String s = t.getText();
                if (this.ignoreCase) {
                    s = s.toLowerCase();
                }
                if ((currentLevel = (Hashtable)currentLevel.get(s)) == null) {
                    return end;
                }
                if (!currentLevel.containsKey(END_OF_WORD_TOKEN)) continue;
                end = i;
            }
            return end;
        }

        public int size() {
            return this.size;
        }

        private void writeObject(ObjectOutputStream out) throws IOException {
            out.writeInt(0);
            out.writeObject(this.name);
            out.writeObject(this.lex);
            out.writeBoolean(this.ignoreCase);
            out.writeInt(this.size);
        }

        private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
            int version = in.readInt();
            this.name = (String)in.readObject();
            this.lex = (Hashtable)in.readObject();
            this.ignoreCase = in.readBoolean();
            this.size = in.readInt();
        }
    }
}

