/*
 * Decompiled with CFR 0.152.
 */
package cc.mallet.pipe.tsf;

import cc.mallet.pipe.Pipe;
import cc.mallet.types.Instance;
import cc.mallet.types.Token;
import cc.mallet.types.TokenSequence;
import cc.mallet.util.PropertyList;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.regex.Pattern;

public class OffsetConjunctions
extends Pipe
implements Serializable {
    int[][] conjunctions;
    boolean includeOriginalSingletons;
    Pattern featureRegex;
    static final int maxWindowSize = 50;
    static final PropertyList[] startfs = new PropertyList[50];
    static final PropertyList[] endfs = new PropertyList[50];
    private static final long serialVersionUID = 1L;
    private static final int CURRENT_SERIAL_VERSION = 0;
    private static final int NULL_INTEGER = -1;

    private static void initStartEndFs() {
        for (int i = 0; i < 50; ++i) {
            OffsetConjunctions.startfs[i] = PropertyList.add("<START" + i + ">", 1.0, null);
            OffsetConjunctions.endfs[i] = PropertyList.add("<END" + i + ">", 1.0, null);
        }
    }

    public OffsetConjunctions(boolean includeOriginalSingletons, Pattern featureRegex, int[][] conjunctions) {
        this.conjunctions = conjunctions;
        this.featureRegex = featureRegex;
        this.includeOriginalSingletons = includeOriginalSingletons;
    }

    public OffsetConjunctions(boolean includeOriginalSingletons, int[][] conjunctions) {
        this(includeOriginalSingletons, null, conjunctions);
    }

    public OffsetConjunctions(int[][] conjunctions) {
        this(true, conjunctions);
    }

    @Override
    public Instance pipe(Instance carrier) {
        int i;
        TokenSequence ts = (TokenSequence)carrier.getData();
        int tsSize = ts.size();
        PropertyList[] oldfs = null;
        PropertyList[] newfs = null;
        try {
            oldfs = new PropertyList[ts.size()];
        }
        catch (Exception e) {
            System.err.println("Exception allocating oldfs: " + e);
        }
        try {
            newfs = new PropertyList[ts.size()];
        }
        catch (Exception e) {
            System.err.println("Exception allocating newfs: " + e);
        }
        for (i = 0; i < tsSize; ++i) {
            oldfs[i] = ((Token)ts.get(i)).getFeatures();
        }
        if (this.includeOriginalSingletons) {
            for (i = 0; i < tsSize; ++i) {
                newfs[i] = ((Token)ts.get(i)).getFeatures();
            }
        }
        for (i = 0; i < tsSize; ++i) {
            for (int j = 0; j < this.conjunctions.length; ++j) {
                PropertyList.Iterator[] iters = this.getOffsetIters(this.conjunctions, j, tsSize, i, oldfs);
                if (iters == null) continue;
                int[] iterIndices = new int[iters.length];
                for (int ii = 0; ii < iterIndices.length; ++ii) {
                    iterIndices[ii] = -1;
                }
                newfs[i] = this.makeConjunctions(iters, 0, this.conjunctions, j, tsSize, newfs[i], i, oldfs, iterIndices);
            }
        }
        for (i = 0; i < ts.size(); ++i) {
            ((Token)ts.get(i)).setFeatures(newfs[i]);
        }
        return carrier;
    }

    private PropertyList makeConjunctions(PropertyList.Iterator[] iters, int currIndex, int[][] conjunctions, int j, int tsSize, PropertyList newfs, int tsi, PropertyList[] oldfs, int[] iterIndices) {
        if (iters.length == currIndex) {
            if (this.redundant(conjunctions, j, iterIndices)) {
                return newfs;
            }
            String newFeature = "";
            double newValue = 1.0;
            for (int i = 0; i < iters.length; ++i) {
                String s = iters[i].getKey();
                if (this.featureRegex != null && !this.featureRegex.matcher(s).matches()) {
                    return newfs;
                }
                newFeature = newFeature + (i == 0 ? "" : "_&_") + s + (conjunctions[j][i] == 0 ? "" : "@" + conjunctions[j][i]);
                newValue *= iters[i].getNumericValue();
            }
            newfs = PropertyList.add(newFeature, newValue, newfs);
        } else {
            while (iters[currIndex].hasNext()) {
                iters[currIndex].next();
                int n = currIndex;
                iterIndices[n] = iterIndices[n] + 1;
                newfs = this.makeConjunctions(iters, currIndex + 1, conjunctions, j, tsSize, newfs, tsi, oldfs, iterIndices);
            }
            iters[currIndex] = this.getOffsetIter(conjunctions, j, currIndex, tsSize, tsi, oldfs);
            iterIndices[currIndex] = -1;
        }
        return newfs;
    }

    private boolean redundant(int[][] conjunctions, int j, int[] iterIndices) {
        for (int i = 1; i < iterIndices.length; ++i) {
            if (conjunctions[j][i - 1] != conjunctions[j][i] || iterIndices[i] > iterIndices[i - 1]) continue;
            return true;
        }
        return false;
    }

    private PropertyList.Iterator[] getOffsetIters(int[][] conjunctions, int j, int tsSize, int tsi, PropertyList[] oldfs) {
        PropertyList.Iterator[] iters = new PropertyList.Iterator[conjunctions[j].length];
        for (int iteri = 0; iteri < iters.length; ++iteri) {
            iters[iteri] = this.getOffsetIter(conjunctions, j, iteri, tsSize, tsi, oldfs);
            if (iters[iteri] != null) continue;
            return null;
        }
        return iters;
    }

    private PropertyList.Iterator getOffsetIter(int[][] conjunctions, int j, int iteri, int tsSize, int tsi, PropertyList[] oldfs) {
        Object iter2 = tsi + conjunctions[j][iteri] < 0 ? startfs[-(tsi + conjunctions[j][iteri]) - 1].iterator() : (conjunctions[j][iteri] + tsi > tsSize - 1 ? endfs[tsi + conjunctions[j][iteri] - tsSize].iterator() : (oldfs[conjunctions[j][iteri] + tsi] == null ? null : oldfs[tsi + conjunctions[j][iteri]].iterator()));
        return iter2;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeInt(0);
        int size1 = this.conjunctions == null ? -1 : this.conjunctions.length;
        out.writeInt(size1);
        if (size1 != -1) {
            for (int i = 0; i < size1; ++i) {
                int size2 = this.conjunctions[i] == null ? -1 : this.conjunctions[i].length;
                out.writeInt(size2);
                if (size2 == -1) continue;
                for (int j = 0; j < size2; ++j) {
                    out.writeInt(this.conjunctions[i][j]);
                }
            }
        }
        out.writeBoolean(this.includeOriginalSingletons);
        out.writeObject(this.featureRegex);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        int version = in.readInt();
        int size1 = in.readInt();
        if (startfs[0] == null) {
            OffsetConjunctions.initStartEndFs();
        }
        if (size1 == -1) {
            this.conjunctions = null;
        } else {
            this.conjunctions = new int[size1][];
            for (int i = 0; i < size1; ++i) {
                int size2 = in.readInt();
                if (size2 == -1) {
                    this.conjunctions[i] = null;
                    continue;
                }
                this.conjunctions[i] = new int[size2];
                for (int j = 0; j < size2; ++j) {
                    this.conjunctions[i][j] = in.readInt();
                }
            }
        }
        this.includeOriginalSingletons = in.readBoolean();
        this.featureRegex = (Pattern)in.readObject();
    }

    static {
        OffsetConjunctions.initStartEndFs();
    }
}

