/*
 * Decompiled with CFR 0.152.
 */
package cc.mallet.pipe.tsf;

import cc.mallet.pipe.Pipe;
import cc.mallet.types.Instance;
import cc.mallet.types.Token;
import cc.mallet.types.TokenSequence;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class CountMatches
extends Pipe {
    public static final int INTEGER_COUNT = 0;
    public static final int BINARY_COUNT = 1;
    public static final int NORMALIZED_COUNT = 2;
    public static final int OVER_MAX = 3;
    Pattern regex;
    String feature;
    boolean normalizeByCharLength = false;
    boolean countIsBinary = false;

    public CountMatches(String featureName, Pattern regex, int countType) {
        this.feature = featureName;
        this.regex = regex;
        if (countType == 1) {
            this.countIsBinary = true;
        } else if (countType == 2) {
            this.normalizeByCharLength = true;
        } else if (countType >= 3) {
            throw new IllegalArgumentException("Bad countType.");
        }
    }

    public CountMatches(String featureName, Pattern regex) {
        this(featureName, regex, 0);
    }

    @Override
    public Instance pipe(Instance carrier) {
        TokenSequence ts = (TokenSequence)carrier.getData();
        for (int i = 0; i < ts.size(); ++i) {
            int count2 = 0;
            Token t = (Token)ts.get(i);
            Matcher matcher = this.regex.matcher(t.getText());
            while (matcher.find()) {
                ++count2;
                if (!this.countIsBinary) continue;
            }
            if (count2 <= 0) continue;
            t.setFeatureValue(this.feature, this.normalizeByCharLength ? (double)count2 / (double)t.getText().length() : (double)count2);
        }
        return carrier;
    }
}

