/*
 * Decompiled with CFR 0.152.
 */
package cc.mallet.pipe.iterator;

import cc.mallet.types.Instance;
import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.regex.Pattern;

public class UnlabeledFileIterator
implements Iterator<Instance> {
    FileFilter fileFilter;
    ArrayList<File> fileArray;
    Iterator<File> subIterator;
    File[] startingDirectories;
    int[] minFileIndex;
    int fileCount;
    public static final Pattern STARTING_DIRECTORIES = Pattern.compile("_STARTING_DIRECTORIES_");
    public static final Pattern FIRST_DIRECTORY = Pattern.compile("/?([^/]*)/.+");
    public static final Pattern LAST_DIRECTORY = Pattern.compile(".*/([^/]+)/[^/]+");
    public static final Pattern ALL_DIRECTORIES = Pattern.compile("^(.*)/[^/]+");

    public ArrayList<File> getFileArray() {
        return this.fileArray;
    }

    protected UnlabeledFileIterator(File[] directories, FileFilter fileFilter) {
        this.startingDirectories = directories;
        this.fileFilter = fileFilter;
        this.minFileIndex = new int[directories.length];
        this.fileArray = new ArrayList();
        for (int i = 0; i < directories.length; ++i) {
            if (!directories[i].isDirectory()) {
                throw new IllegalArgumentException(directories[i].getAbsolutePath() + " is not a directory.");
            }
            this.minFileIndex[i] = this.fileArray.size();
            this.fillFileArray(directories[i], fileFilter, this.fileArray);
        }
        this.subIterator = this.fileArray.iterator();
        this.fileCount = 0;
        String[] dirStrings = new String[directories.length];
        for (int i = 0; i < directories.length; ++i) {
            dirStrings[i] = directories[i].toString();
        }
    }

    public static File[] stringArray2FileArray(String[] sa) {
        File[] ret = new File[sa.length];
        for (int i = 0; i < sa.length; ++i) {
            ret[i] = new File(sa[i]);
        }
        return ret;
    }

    public UnlabeledFileIterator(String[] directories, FileFilter ff) {
        this(UnlabeledFileIterator.stringArray2FileArray(directories), ff);
    }

    public UnlabeledFileIterator(File directory, FileFilter fileFilter) {
        this(new File[]{directory}, fileFilter);
    }

    public UnlabeledFileIterator(File directory) {
        this(new File[]{directory}, null);
    }

    public UnlabeledFileIterator(File[] directories) {
        this(directories, null);
    }

    public UnlabeledFileIterator(String directory) {
        this(new File[]{new File(directory)}, null);
    }

    public UnlabeledFileIterator(String directory, FileFilter filter2) {
        this(new File[]{new File(directory)}, filter2);
    }

    private int fillFileArray(File directory, FileFilter filter2, ArrayList<File> files) {
        int count2 = 0;
        File[] directoryContents = directory.listFiles();
        for (int i = 0; i < directoryContents.length; ++i) {
            if (directoryContents[i].isDirectory()) {
                count2 += this.fillFileArray(directoryContents[i], filter2, files);
                continue;
            }
            if (filter2 != null && !filter2.accept(directoryContents[i])) continue;
            files.add(directoryContents[i]);
            ++count2;
        }
        return count2;
    }

    @Override
    public Instance next() {
        File nextFile = this.subIterator.next();
        ++this.fileCount;
        return new Instance(nextFile, null, nextFile.toURI(), null);
    }

    @Override
    public void remove() {
        throw new IllegalStateException("This Iterator<Instance> does not support remove().");
    }

    public File nextFile() {
        return this.subIterator.next();
    }

    @Override
    public boolean hasNext() {
        return this.subIterator.hasNext();
    }
}

