/*
 * Decompiled with CFR 0.152.
 */
package cc.mallet.optimize.tests;

import cc.mallet.optimize.Optimizable;
import cc.mallet.types.MatrixOps;
import cc.mallet.util.MalletLogger;
import cc.mallet.util.Maths;
import java.util.Random;
import java.util.logging.Logger;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class TestOptimizable
extends TestCase {
    private static Logger logger = MalletLogger.getLogger(TestOptimizable.class.getName());
    private static int numComponents = -1;

    public TestOptimizable(String name) {
        super(name);
    }

    public static void setNumComponents(int n) {
        numComponents = n;
    }

    public static boolean testGetSetParameters(Optimizable maxable) {
        int i;
        System.out.println("TestMaximizable testGetSetParameters");
        double[] parameters = new double[maxable.getNumParameters()];
        maxable.getParameters(parameters);
        for (i = 0; i < parameters.length; ++i) {
            parameters[i] = i;
        }
        maxable.setParameters(parameters);
        MatrixOps.setAll(parameters, 0.0);
        maxable.getParameters(parameters);
        for (i = 0; i < parameters.length; ++i) {
            TestOptimizable.assertTrue((parameters[i] == (double)i ? 1 : 0) != 0);
        }
        return true;
    }

    public static double testValueAndGradientInDirection(Optimizable.ByGradientValue maxable, double[] direction) {
        int numParameters = maxable.getNumParameters();
        assert (numParameters == direction.length);
        double[] oldParameters = new double[numParameters];
        double[] parameters = new double[numParameters];
        double[] normalizedDirection = (double[])direction.clone();
        System.arraycopy(direction, 0, normalizedDirection, 0, numParameters);
        MatrixOps.absNormalize(normalizedDirection);
        double value2 = maxable.getValue();
        double[] analyticGradient = new double[numParameters];
        maxable.getParameters(parameters);
        maxable.getParameters(oldParameters);
        maxable.getValueGradient(analyticGradient);
        double directionGradient = MatrixOps.dotProduct(analyticGradient, normalizedDirection);
        double epsilon = 0.1 / MatrixOps.absNorm(analyticGradient);
        double tolerance = 1.0E-5 * directionGradient;
        System.out.println("epsilon = " + epsilon + " tolerance=" + tolerance);
        MatrixOps.plusEquals(parameters, normalizedDirection, epsilon);
        maxable.setParameters(parameters);
        double epsValue = maxable.getValue();
        double slope = (epsValue - value2) / epsilon;
        System.out.println("value=" + value2 + " epsilon=" + epsilon + " epsValue=" + epsValue + " slope = " + slope + " gradient=" + directionGradient);
        assert (!Double.isNaN(slope));
        double slopeDifference = Math.abs(slope - directionGradient);
        logger.info("TestMaximizable : slope tolerance = " + tolerance + ": gradient slope = " + directionGradient + ", value+epsilon slope = " + slope + ": slope difference = " + slopeDifference);
        maxable.setParameters(oldParameters);
        assert (Math.abs(slopeDifference) < tolerance) : "Slope difference " + slopeDifference + " is greater than tolerance " + tolerance;
        return slopeDifference;
    }

    public static double testValueAndGradientCurrentParameters(Optimizable.ByGradientValue maxable) {
        double[] parameters = new double[maxable.getNumParameters()];
        double value2 = maxable.getValue();
        double[] analyticGradient = new double[maxable.getNumParameters()];
        double[] empiricalGradient = new double[maxable.getNumParameters()];
        maxable.getParameters(parameters);
        maxable.getValueGradient(analyticGradient);
        maxable.getValueGradient(empiricalGradient);
        double norm = Math.max(0.1, MatrixOps.absNorm(analyticGradient));
        double epsilon = 0.1 / norm;
        double tolerance = epsilon * 5.0;
        System.out.println("epsilon = " + epsilon + " tolerance=" + tolerance);
        int sampleParameterInterval = -1;
        if (numComponents > 0) {
            sampleParameterInterval = Math.max(1, parameters.length / numComponents);
            logger.info("Will check every " + sampleParameterInterval + "-th component.");
        }
        for (int i = 0; i < parameters.length; ++i) {
            if (parameters.length >= sampleParameterInterval && i % sampleParameterInterval != 0) continue;
            double param2 = parameters[i];
            parameters[i] = param2 + epsilon;
            maxable.setParameters(parameters);
            double epsValue = maxable.getValue();
            double slope = (epsValue - value2) / epsilon;
            System.out.println("value=" + value2 + " epsValue=" + epsValue + " slope[" + i + "] = " + slope + " gradient[]=" + analyticGradient[i]);
            assert (!Double.isNaN(slope));
            logger.info("TestMaximizable checking singleIndex " + i + ": gradient slope = " + analyticGradient[i] + ", value+epsilon slope = " + slope + ": slope difference = " + (slope - analyticGradient[i]));
            empiricalGradient[i] = slope;
            parameters[i] = param2;
        }
        System.out.println("analyticGradient.twoNorm = " + MatrixOps.twoNorm(analyticGradient));
        System.out.println("empiricalGradient.twoNorm = " + MatrixOps.twoNorm(empiricalGradient));
        MatrixOps.timesEquals(analyticGradient, 1.0 / MatrixOps.twoNorm(analyticGradient));
        MatrixOps.timesEquals(empiricalGradient, 1.0 / MatrixOps.twoNorm(empiricalGradient));
        double dot = MatrixOps.dotProduct(analyticGradient, empiricalGradient);
        if (Maths.almostEquals(dot, 1.0)) {
            logger.info("TestMaximizable angle is zero.");
            return 0.0;
        }
        double angle = Math.acos(dot);
        logger.info("TestMaximizable angle = " + angle);
        if (Math.abs(angle) > tolerance) {
            throw new IllegalStateException("Gradient/Value mismatch: angle=" + angle + " tol: " + tolerance);
        }
        if (Double.isNaN(angle)) {
            throw new IllegalStateException("Gradient/Value error: angle is NaN!");
        }
        return angle;
    }

    public static boolean testValueAndGradient(Optimizable.ByGradientValue maxable) {
        double[] parameters = new double[maxable.getNumParameters()];
        MatrixOps.setAll(parameters, 0.0);
        maxable.setParameters(parameters);
        TestOptimizable.testValueAndGradientCurrentParameters(maxable);
        MatrixOps.setAll(parameters, 0.0);
        double[] delta = new double[maxable.getNumParameters()];
        maxable.getValueGradient(delta);
        logger.info("Gradient two-Norm = " + MatrixOps.twoNorm(delta));
        logger.info("  max parameter change = " + MatrixOps.infinityNorm(delta) * -0.001);
        MatrixOps.timesEquals(delta, -1.0E-4);
        MatrixOps.plusEquals(parameters, delta);
        maxable.setParameters(parameters);
        TestOptimizable.testValueAndGradientCurrentParameters(maxable);
        return true;
    }

    public static boolean testValueAndGradientRandomParameters(Optimizable.ByGradientValue maxable, Random r) {
        double[] params = new double[maxable.getNumParameters()];
        for (int i = 0; i < params.length; ++i) {
            params[i] = r.nextDouble();
            if (!r.nextBoolean()) continue;
            params[i] = -params[i];
        }
        maxable.setParameters(params);
        TestOptimizable.testValueAndGradientCurrentParameters(maxable);
        return true;
    }

    public void testTestValueAndGradient() {
        SimplePoly maxable = new SimplePoly();
        TestOptimizable.testValueAndGradient(maxable);
        try {
            WrongSimplePoly badMaxable = new WrongSimplePoly();
            TestOptimizable.testValueAndGradient(badMaxable);
            TestOptimizable.fail((String)"WrongSimplyPoly should fail testMaxmiziable!");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static Test suite() {
        return new TestSuite(TestOptimizable.class);
    }

    protected void setUp() {
    }

    public static void main(String[] args) {
        TestRunner.run((Test)TestOptimizable.suite());
    }

    static class WrongSimplePoly
    extends SimplePoly {
        WrongSimplePoly() {
        }

        @Override
        public void getValueGradient(double[] buffer) {
            buffer[0] = 3.0 * this.params[0];
        }
    }

    static class SimplePoly
    implements Optimizable.ByGradientValue {
        double[] params = new double[1];

        SimplePoly() {
        }

        @Override
        public void getParameters(double[] doubleArray) {
            doubleArray[0] = this.params[0];
        }

        @Override
        public int getNumParameters() {
            return 1;
        }

        @Override
        public double getParameter(int n) {
            return this.params[0];
        }

        @Override
        public void setParameters(double[] doubleArray) {
            this.params[0] = doubleArray[0];
        }

        @Override
        public void setParameter(int n, double d) {
            this.params[n] = d;
        }

        @Override
        public double getValue() {
            return 3.0 * this.params[0] * this.params[0] - 5.0 * this.params[0] + 2.0;
        }

        @Override
        public void getValueGradient(double[] buffer) {
            buffer[0] = 3.0 * this.params[0] - 5.0;
        }
    }
}

