/*
 * Decompiled with CFR 0.152.
 */
package cc.mallet.grmm.util;

import cc.mallet.grmm.types.Factor;
import cc.mallet.grmm.types.FactorGraph;
import cc.mallet.grmm.types.Variable;
import java.io.IOException;
import java.io.Writer;

public class ModelWriter {
    public static void writeModel(FactorGraph fg, Writer w) {
        try {
            ModelWriter.writeVariables(fg, w);
            w.write("\n");
            ModelWriter.writeFactors(fg, w);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static void writeVariables(FactorGraph fg, Writer w) throws IOException {
        for (int vi = 0; vi < fg.numVariables(); ++vi) {
            Variable var = fg.getVariable(vi);
            int nOuts = var.getNumOutcomes();
            String outStr = nOuts == -1 ? "continuous" : Integer.toString(nOuts);
            w.write("VAR " + var.getLabel() + " : " + outStr + "\n");
        }
    }

    private static void writeFactors(FactorGraph fg, Writer w) throws IOException {
        for (int fi = 0; fi < fg.factors().size(); ++fi) {
            Factor f2 = fg.getFactor(fi);
            w.write(f2.prettyOutputString());
            w.write("\n");
        }
    }
}

