/*
 * Decompiled with CFR 0.152.
 */
package cc.mallet.grmm.types;

import cc.mallet.grmm.types.AbstractFactor;
import cc.mallet.grmm.types.Assignment;
import cc.mallet.grmm.types.ConstantFactor;
import cc.mallet.grmm.types.Factor;
import cc.mallet.grmm.types.HashVarSet;
import cc.mallet.grmm.types.VarSet;
import cc.mallet.grmm.types.Variable;
import cc.mallet.util.Maths;
import cc.mallet.util.Randoms;

public class UniNormalFactor
extends AbstractFactor {
    private Variable var;
    private double mean;
    private double variance;

    public UniNormalFactor(Variable var, double mean, double variance) {
        super(new HashVarSet(new Variable[]{var}));
        if (!var.isContinuous()) {
            throw new IllegalArgumentException();
        }
        if (variance <= 0.0) {
            throw new IllegalArgumentException();
        }
        this.var = var;
        this.mean = mean;
        this.variance = variance;
    }

    @Override
    protected Factor extractMaxInternal(VarSet varSet) {
        throw new UnsupportedOperationException();
    }

    @Override
    public double value(Assignment assn) {
        double x2 = assn.getDouble(this.var);
        return 1.0 / Math.sqrt(Math.PI * 2 * this.variance) * Math.exp(-1.0 / (2.0 * this.variance) * (x2 - this.mean) * (x2 - this.mean));
    }

    @Override
    protected double lookupValueInternal(int i) {
        throw new UnsupportedOperationException();
    }

    @Override
    protected Factor marginalizeInternal(VarSet varsToKeep) {
        if (varsToKeep.contains(this.var)) {
            return this.duplicate();
        }
        return new ConstantFactor(1.0);
    }

    @Override
    public Factor normalize() {
        return this;
    }

    @Override
    public Assignment sample(Randoms r) {
        double val = r.nextGaussian(this.mean, this.variance);
        return new Assignment(this.var, val);
    }

    @Override
    public boolean almostEquals(Factor p, double epsilon) {
        return this.equals(p);
    }

    @Override
    public Factor duplicate() {
        return new UniNormalFactor(this.var, this.mean, this.variance);
    }

    @Override
    public boolean isNaN() {
        return Double.isNaN(this.mean) || Double.isNaN(this.variance);
    }

    @Override
    public String dumpToString() {
        return this.toString();
    }

    public String toString() {
        return "[NormalFactor " + this.var + " " + this.mean + " ... " + this.variance + " ]";
    }

    @Override
    public Factor slice(Assignment assn) {
        if (assn.containsVar(this.var)) {
            return new ConstantFactor(this.value(assn));
        }
        return this.duplicate();
    }

    @Override
    public void multiplyBy(Factor f2) {
        double val;
        if (f2 instanceof ConstantFactor && Maths.almostEquals(val = f2.value(new Assignment()), 1.0)) {
            return;
        }
        throw new UnsupportedOperationException("Can't multiply NormalFactor by " + f2);
    }

    @Override
    public void divideBy(Factor f2) {
        double val;
        if (f2 instanceof ConstantFactor && Maths.almostEquals(val = f2.value(new Assignment()), 1.0)) {
            return;
        }
        throw new UnsupportedOperationException("Can't divide NormalFactor by " + f2);
    }
}

