/*
 * Decompiled with CFR 0.152.
 */
package cc.mallet.grmm.types;

import cc.mallet.grmm.inference.Inferencer;
import cc.mallet.grmm.types.AbstractTableFactor;
import cc.mallet.grmm.types.Assignment;
import cc.mallet.grmm.types.AssignmentIterator;
import cc.mallet.grmm.types.CPT;
import cc.mallet.grmm.types.DiscreteFactor;
import cc.mallet.grmm.types.Factor;
import cc.mallet.grmm.types.HashVarSet;
import cc.mallet.grmm.types.SkeletonFactor;
import cc.mallet.grmm.types.TableFactor;
import cc.mallet.grmm.types.VarSet;
import cc.mallet.grmm.types.Variable;
import cc.mallet.types.Alphabet;
import cc.mallet.types.Matrix;
import cc.mallet.types.RankedFeatureVector;
import cc.mallet.types.SparseMatrixn;
import cc.mallet.util.Maths;
import gnu.trove.TDoubleArrayList;
import gnu.trove.TIntArrayList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;

public class Factors {
    public static CPT normalizeAsCpt(AbstractTableFactor ptl, Variable var) {
        Assignment assn;
        double[] sums = new double[ptl.numLocations()];
        Arrays.fill(sums, Double.NEGATIVE_INFINITY);
        HashVarSet neighbors = new HashVarSet(ptl.varSet());
        neighbors.remove(var);
        AssignmentIterator it = ptl.assignmentIterator();
        while (it.hasNext()) {
            assn = it.assignment();
            Assignment nbrAssn = (Assignment)assn.marginalizeOut(var);
            int idx = nbrAssn.singleIndex();
            sums[idx] = Maths.sumLogProb(ptl.logValue(assn), sums[idx]);
            it.advance();
        }
        it = ptl.assignmentIterator();
        while (it.hasNext()) {
            assn = it.assignment();
            double oldVal = ptl.logValue(assn);
            Assignment nbrAssn = (Assignment)assn.marginalizeOut(var);
            double logZ = sums[nbrAssn.singleIndex()];
            if (Double.isInfinite(oldVal) && Double.isInfinite(logZ)) {
                ptl.setLogValue(assn, Double.NEGATIVE_INFINITY);
            } else {
                ptl.setLogValue(assn, oldVal - logZ);
            }
            it.advance();
        }
        return new CPT(ptl, var);
    }

    public static Factor average(Factor ptl1, Factor ptl2, double weight) {
        TableFactor mptl1 = (TableFactor)ptl1;
        TableFactor mptl2 = (TableFactor)ptl2;
        return TableFactor.hackyMixture(mptl1, mptl2, weight);
    }

    public static double oneDistance(Factor bel1, Factor bel2) {
        VarSet vs2;
        VarSet vs1 = bel1.varSet();
        if (!vs1.equals(vs2 = bel2.varSet())) {
            throw new IllegalArgumentException("Attempt to take distancebetween mismatching potentials " + bel1 + " and " + bel2);
        }
        double dist = 0.0;
        AssignmentIterator it = bel1.assignmentIterator();
        while (it.hasNext()) {
            Assignment assn = it.assignment();
            dist += Math.abs(bel1.value(assn) - bel2.value(assn));
            it.advance();
        }
        return dist;
    }

    public static TableFactor retainMass(DiscreteFactor ptl, double alpha) {
        int[] idxs = new int[ptl.numLocations()];
        double[] vals = new double[ptl.numLocations()];
        for (int i = 0; i < idxs.length; ++i) {
            idxs[i] = ptl.indexAtLocation(i);
            vals[i] = ptl.logValue(i);
        }
        RankedFeatureVector rfv = new RankedFeatureVector(new Alphabet(), idxs, vals);
        TIntArrayList idxList = new TIntArrayList();
        TDoubleArrayList valList = new TDoubleArrayList();
        double mass = Double.NEGATIVE_INFINITY;
        double logAlpha = Math.log(alpha);
        for (int rank = 0; rank < rfv.numLocations(); ++rank) {
            int idx = rfv.getIndexAtRank(rank);
            double val = rfv.value(idx);
            mass = Maths.sumLogProb(mass, val);
            idxList.add(idx);
            valList.add(val);
            if (mass > logAlpha) break;
        }
        int[] szs = Factors.computeSizes(ptl);
        SparseMatrixn m = new SparseMatrixn(szs, idxList.toNativeArray(), valList.toNativeArray());
        TableFactor result2 = new TableFactor(Factors.computeVars(ptl));
        result2.setValues(m);
        return result2;
    }

    public static int[] computeSizes(Factor result2) {
        int nv = result2.varSet().size();
        int[] szs = new int[nv];
        for (int i = 0; i < nv; ++i) {
            Variable var = result2.getVariable(i);
            szs[i] = var.getNumOutcomes();
        }
        return szs;
    }

    public static Variable[] computeVars(Factor result2) {
        int nv = result2.varSet().size();
        Variable[] vars = new Variable[nv];
        for (int i = 0; i < nv; ++i) {
            Variable var;
            vars[i] = var = result2.getVariable(i);
        }
        return vars;
    }

    public static double mutualInformation(Factor factor) {
        VarSet vs = factor.varSet();
        if (vs.size() != 2) {
            throw new IllegalArgumentException("Factor must have size 2");
        }
        Factor marg1 = factor.marginalize(vs.get(0));
        Factor marg2 = factor.marginalize(vs.get(1));
        double result2 = 0.0;
        AssignmentIterator it = factor.assignmentIterator();
        while (it.hasNext()) {
            Assignment assn = (Assignment)it.next();
            result2 += factor.value(assn) * (factor.logValue(assn) - marg1.logValue(assn) - marg2.logValue(assn));
        }
        return result2;
    }

    public static double KL(AbstractTableFactor f1, AbstractTableFactor f2) {
        double result2 = 0.0;
        for (int loc = 0; loc < f1.numLocations(); ++loc) {
            double val1 = f1.valueAtLocation(loc);
            double val2 = f2.value(f1.indexAtLocation(loc));
            if (!(val1 > 1.0E-5)) continue;
            result2 += val1 * Math.log(val1 / val2);
        }
        return result2;
    }

    public static Factor mix(AbstractTableFactor f1, AbstractTableFactor f2, double alpha) {
        return AbstractTableFactor.hackyMixture(f1, f2, alpha);
    }

    public static double euclideanDistance(AbstractTableFactor f1, AbstractTableFactor f2) {
        double result2 = 0.0;
        for (int loc = 0; loc < f1.numLocations(); ++loc) {
            double val1 = f1.valueAtLocation(loc);
            double val2 = f2.value(f1.indexAtLocation(loc));
            result2 += (val1 - val2) * (val1 - val2);
        }
        return Math.sqrt(result2);
    }

    public static double l1Distance(AbstractTableFactor f1, AbstractTableFactor f2) {
        double result2 = 0.0;
        for (int loc = 0; loc < f1.numLocations(); ++loc) {
            double val1 = f1.valueAtLocation(loc);
            double val2 = f2.value(f1.indexAtLocation(loc));
            result2 += Math.abs(val1 - val2);
        }
        return result2;
    }

    public static Factor asFactor(final Inferencer inf) {
        return new SkeletonFactor(){

            @Override
            public double value(Assignment assn) {
                Factor factor = inf.lookupMarginal(assn.varSet());
                return factor.value(assn);
            }

            @Override
            public Factor marginalize(Variable[] vars) {
                return inf.lookupMarginal(new HashVarSet(vars));
            }

            @Override
            public Factor marginalize(Collection vars) {
                return inf.lookupMarginal(new HashVarSet(vars));
            }

            @Override
            public Factor marginalize(Variable var) {
                return inf.lookupMarginal(new HashVarSet(new Variable[]{var}));
            }

            @Override
            public Factor marginalizeOut(Variable var) {
                throw new UnsupportedOperationException();
            }

            @Override
            public Factor marginalizeOut(VarSet varset) {
                throw new UnsupportedOperationException();
            }

            @Override
            public VarSet varSet() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public static Variable[] discreteVarsOf(Factor fg) {
        ArrayList<Variable> vars = new ArrayList<Variable>();
        VarSet vs = fg.varSet();
        for (int vi = 0; vi < vs.size(); ++vi) {
            Variable var = vs.get(vi);
            if (var.isContinuous()) continue;
            vars.add(var);
        }
        return vars.toArray(new Variable[vars.size()]);
    }

    public static Variable[] continuousVarsOf(Factor fg) {
        ArrayList<Variable> vars = new ArrayList<Variable>();
        VarSet vs = fg.varSet();
        for (int vi = 0; vi < vs.size(); ++vi) {
            Variable var = vs.get(vi);
            if (!var.isContinuous()) continue;
            vars.add(var);
        }
        return vars.toArray(new Variable[vars.size()]);
    }

    public static double corr(Factor factor) {
        if (factor.varSet().size() != 2) {
            throw new IllegalArgumentException("corr() only works on Factors of size 2, tried " + factor);
        }
        Variable v0 = factor.varSet().get(0);
        Variable v1 = factor.varSet().get(1);
        double eXY = 0.0;
        AssignmentIterator it = factor.assignmentIterator();
        while (it.hasNext()) {
            Assignment assn = (Assignment)it.next();
            int val0 = assn.get(v0);
            int val1 = assn.get(v1);
            eXY += factor.value(assn) * (double)val0 * (double)val1;
        }
        double eX = Factors.mean(factor.marginalize(v0));
        double eY = Factors.mean(factor.marginalize(v1));
        return eXY - eX * eY;
    }

    private static double mean(Factor factor) {
        if (factor.varSet().size() != 1) {
            throw new IllegalArgumentException("mean() only works on Factors of size 1, tried " + factor);
        }
        Variable v0 = factor.varSet().get(0);
        double mean = 0.0;
        AssignmentIterator it = factor.assignmentIterator();
        while (it.hasNext()) {
            Assignment assn = (Assignment)it.next();
            int val0 = assn.get(v0);
            mean += factor.value(assn) * (double)val0;
        }
        return mean;
    }

    public static Factor multiplyAll(Collection factors) {
        Factor first = (Factor)factors.iterator().next();
        if (factors.size() == 1) {
            return first.duplicate();
        }
        HashVarSet vs = new HashVarSet();
        for (Factor phi : factors) {
            vs.addAll(phi.varSet());
        }
        Factor result2 = first.duplicate();
        for (Factor phi : factors) {
            result2.multiplyBy(phi);
        }
        return result2;
    }

    public static double distLinf(AbstractTableFactor f1, AbstractTableFactor f2) {
        Matrix m1 = f1.getLogValueMatrix();
        Matrix m2 = f2.getLogValueMatrix();
        return Factors.matrixDistLinf(m1, m2);
    }

    public static double distValueLinf(AbstractTableFactor f1, AbstractTableFactor f2) {
        Matrix m1 = f1.getValueMatrix();
        Matrix m2 = f2.getValueMatrix();
        return Factors.matrixDistLinf(m1, m2);
    }

    private static double matrixDistLinf(Matrix m1, Matrix m2) {
        int nl2;
        double max2 = 0.0;
        int nl1 = m1.singleSize();
        if (nl1 != (nl2 = m2.singleSize())) {
            return Double.POSITIVE_INFINITY;
        }
        for (int l = 0; l < nl1; ++l) {
            double val2;
            double val1 = m1.singleValue(l);
            double diff2 = val1 > (val2 = m2.singleValue(l)) ? val1 - val2 : val2 - val1;
            max2 = diff2 > max2 ? diff2 : max2;
        }
        return max2;
    }

    public static double logErrorRange(AbstractTableFactor f1, AbstractTableFactor f2) {
        int nl2;
        double error_min = Double.MAX_VALUE;
        double error_max = 0.0;
        Matrix m1 = f1.getLogValueMatrix();
        Matrix m2 = f2.getLogValueMatrix();
        int nl1 = m1.singleSize();
        if (nl1 != (nl2 = m2.singleSize())) {
            return Double.POSITIVE_INFINITY;
        }
        for (int l = 0; l < nl1; ++l) {
            double val2;
            double val1 = m1.singleValue(l);
            double diff2 = val1 > (val2 = m2.singleValue(l)) ? val1 - val2 : val2 - val1;
            error_max = diff2 > error_max ? diff2 : error_max;
            error_min = diff2 < error_min ? diff2 : error_min;
        }
        return error_max - error_min;
    }
}

