/*
 * Decompiled with CFR 0.152.
 */
package cc.mallet.grmm.learning.extract;

import bsh.EvalError;
import cc.mallet.extract.Extraction;
import cc.mallet.extract.ExtractionEvaluator;
import cc.mallet.grmm.inference.Inferencer;
import cc.mallet.grmm.learning.ACRF;
import cc.mallet.grmm.learning.ACRFEvaluator;
import cc.mallet.grmm.learning.ACRFTrainer;
import cc.mallet.grmm.learning.AcrfSerialEvaluator;
import cc.mallet.grmm.learning.DefaultAcrfTrainer;
import cc.mallet.grmm.learning.GenericAcrfData2TokenSequence;
import cc.mallet.grmm.learning.MultiSegmentationEvaluatorACRF;
import cc.mallet.grmm.learning.extract.ACRFExtractor;
import cc.mallet.grmm.learning.extract.ACRFExtractorTrainer;
import cc.mallet.pipe.Input2CharSequence;
import cc.mallet.pipe.Noop;
import cc.mallet.pipe.Pipe;
import cc.mallet.pipe.SerialPipes;
import cc.mallet.pipe.TokenSequence2FeatureVectorSequence;
import cc.mallet.pipe.iterator.FileListIterator;
import cc.mallet.pipe.iterator.LineGroupIterator;
import cc.mallet.types.Instance;
import cc.mallet.types.InstanceList;
import cc.mallet.util.BshInterpreter;
import cc.mallet.util.CommandOption;
import cc.mallet.util.FileUtils;
import cc.mallet.util.MalletLogger;
import cc.mallet.util.Timing;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.logging.Logger;
import java.util.regex.Pattern;

public class AcrfExtractorTui {
    private static final Logger logger = MalletLogger.getLogger(AcrfExtractorTui.class.getName());
    private static CommandOption.File outputPrefix = new CommandOption.File(AcrfExtractorTui.class, "output-prefix", "FILENAME", true, null, "Directory to write saved model to.", null);
    private static CommandOption.File modelFile = new CommandOption.File(AcrfExtractorTui.class, "model-file", "FILENAME", true, null, "Text file describing model structure.", null);
    private static CommandOption.File trainFile = new CommandOption.File(AcrfExtractorTui.class, "training", "FILENAME", true, null, "File containing training data.", null);
    private static CommandOption.File testFile = new CommandOption.File(AcrfExtractorTui.class, "testing", "FILENAME", true, null, "File containing testing data.", null);
    private static CommandOption.Integer numLabelsOption = new CommandOption.Integer(AcrfExtractorTui.class, "num-labels", "INT", true, -1, "If supplied, number of labels on each line of input file.  Otherwise, the token ---- must separate labels from features.", null);
    private static CommandOption.String trainerOption = new CommandOption.String(AcrfExtractorTui.class, "trainer", "STRING", true, "ACRFExtractorTrainer", "Specification of trainer type.", null);
    private static CommandOption.String inferencerOption = new CommandOption.String(AcrfExtractorTui.class, "inferencer", "STRING", true, "LoopyBP", "Specification of inferencer.", null);
    private static CommandOption.String maxInferencerOption = new CommandOption.String(AcrfExtractorTui.class, "max-inferencer", "STRING", true, "LoopyBP.createForMaxProduct()", "Specification of inferencer.", null);
    private static CommandOption.String evalOption = new CommandOption.String(AcrfExtractorTui.class, "eval", "STRING", true, "LOG", "Evaluator to use.  Java code grokking performed.", null);
    private static CommandOption.String extractionEvalOption = new CommandOption.String(AcrfExtractorTui.class, "extraction-eval", "STRING", true, "PerDocumentF1", "Evaluator to use.  Java code grokking performed.", null);
    private static CommandOption.Integer checkpointIterations = new CommandOption.Integer(AcrfExtractorTui.class, "checkpoint", "INT", true, -1, "Save a copy after every ___ iterations.", null);
    static CommandOption.Boolean cacheUnrolledGraph = new CommandOption.Boolean(AcrfExtractorTui.class, "cache-graphs", "true|false", true, true, "Whether to use memory-intensive caching.", null);
    static CommandOption.Boolean perTemplateTrain = new CommandOption.Boolean(AcrfExtractorTui.class, "per-template-train", "true|false", true, false, "Whether to pretrain templates before joint training.", null);
    static CommandOption.Integer pttIterations = new CommandOption.Integer(AcrfExtractorTui.class, "per-template-iterations", "INTEGER", false, 100, "How many training iterations for each step of per-template-training.", null);
    static CommandOption.Integer randomSeedOption = new CommandOption.Integer(AcrfExtractorTui.class, "random-seed", "INTEGER", true, 0, "The random seed for randomly selecting a proportion of the instance list for training", null);
    static CommandOption.Boolean useTokenText = new CommandOption.Boolean(AcrfExtractorTui.class, "use-token-text", "true|false", true, true, "If true, first feature in list is assumed to be token identity, and is treated specially.", null);
    private static CommandOption.Boolean labelsAtEnd = new CommandOption.Boolean(AcrfExtractorTui.class, "labels-at-end", "INT", true, false, "If true, then label is at end of each line, rather than beginning.", null);
    static CommandOption.Boolean trainingIsList = new CommandOption.Boolean(AcrfExtractorTui.class, "training-is-list", "true|false", true, false, "If true, training option gives list of files to read for training.", null);
    private static CommandOption.File dataDir = new CommandOption.File(AcrfExtractorTui.class, "data-dir", "FILENAME", true, null, "If training-is-list, base directory in which training files located.", null);
    private static BshInterpreter interpreter = AcrfExtractorTui.setupInterpreter();

    public static void main(String[] args) throws IOException, EvalError {
        AcrfExtractorTui.doProcessOptions(AcrfExtractorTui.class, args);
        Timing timing = new Timing();
        GenericAcrfData2TokenSequence basePipe = !numLabelsOption.wasInvoked() ? new GenericAcrfData2TokenSequence() : new GenericAcrfData2TokenSequence(AcrfExtractorTui.numLabelsOption.value);
        if (!AcrfExtractorTui.useTokenText.value) {
            basePipe.setFeaturesIncludeToken(false);
            basePipe.setIncludeTokenText(false);
        }
        basePipe.setLabelsAtEnd(AcrfExtractorTui.labelsAtEnd.value);
        SerialPipes tokPipe = new SerialPipes(new Pipe[]{AcrfExtractorTui.trainingIsList.value ? new Input2CharSequence() : new Noop(), basePipe});
        Iterator<Instance> trainSource = AcrfExtractorTui.constructIterator(AcrfExtractorTui.trainFile.value, AcrfExtractorTui.dataDir.value, AcrfExtractorTui.trainingIsList.value);
        Iterator<Instance> testSource = testFile.wasInvoked() ? AcrfExtractorTui.constructIterator(AcrfExtractorTui.testFile.value, AcrfExtractorTui.dataDir.value, AcrfExtractorTui.trainingIsList.value) : null;
        ACRF.Template[] tmpls = AcrfExtractorTui.parseModelFile(AcrfExtractorTui.modelFile.value);
        ACRFExtractorTrainer trainer = AcrfExtractorTui.createTrainer(AcrfExtractorTui.trainerOption.value);
        ACRFEvaluator eval = AcrfExtractorTui.createEvaluator(AcrfExtractorTui.evalOption.value);
        ExtractionEvaluator extractionEval = AcrfExtractorTui.createExtractionEvaluator(AcrfExtractorTui.extractionEvalOption.value);
        Inferencer inf = AcrfExtractorTui.createInferencer(AcrfExtractorTui.inferencerOption.value);
        Inferencer maxInf = AcrfExtractorTui.createInferencer(AcrfExtractorTui.maxInferencerOption.value);
        trainer.setPipes(tokPipe, new TokenSequence2FeatureVectorSequence()).setDataSource(trainSource, testSource).setEvaluator(eval).setTemplates(tmpls).setInferencer(inf).setViterbiInferencer(maxInf).setCheckpointDirectory(AcrfExtractorTui.outputPrefix.value).setNumCheckpointIterations(AcrfExtractorTui.checkpointIterations.value).setCacheUnrolledGraphs(AcrfExtractorTui.cacheUnrolledGraph.value).setUsePerTemplateTrain(AcrfExtractorTui.perTemplateTrain.value).setPerTemplateIterations(AcrfExtractorTui.pttIterations.value);
        logger.info("Starting training...");
        ACRFExtractor extor = trainer.trainExtractor();
        timing.tick("Training");
        FileUtils.writeGzippedObject(new File(AcrfExtractorTui.outputPrefix.value, "extor.ser.gz"), extor);
        timing.tick("Serializing");
        InstanceList testing = trainer.getTestingData();
        if (testing != null) {
            eval.test(extor.getAcrf(), testing, "Final results");
        }
        if (extractionEval != null && testing != null) {
            Extraction extraction = extor.extract(testing);
            extractionEval.evaluate(extraction);
            timing.tick("Evaluting");
        }
        System.out.println("Total time (ms) = " + timing.elapsedTime());
    }

    private static BshInterpreter setupInterpreter() {
        BshInterpreter interpreter = CommandOption.getInterpreter();
        try {
            interpreter.eval("import edu.umass.cs.mallet.base.extract.*");
            interpreter.eval("import edu.umass.cs.mallet.grmm.inference.*");
            interpreter.eval("import edu.umass.cs.mallet.grmm.learning.*");
            interpreter.eval("import edu.umass.cs.mallet.grmm.learning.templates.*");
            interpreter.eval("import edu.umass.cs.mallet.grmm.learning.extract.*");
        }
        catch (EvalError e) {
            throw new RuntimeException(e);
        }
        return interpreter;
    }

    private static Iterator<Instance> constructIterator(File trainFile, File dataDir, boolean isList) throws IOException {
        if (isList) {
            return new FileListIterator(trainFile, dataDir, null, null, true);
        }
        return new LineGroupIterator(new FileReader(trainFile), Pattern.compile("^\\s*$"), true);
    }

    public static ACRFEvaluator createEvaluator(String spec) throws EvalError {
        if (spec.indexOf(40) >= 0) {
            return (ACRFEvaluator)interpreter.eval(spec);
        }
        LinkedList<String> toks = new LinkedList<String>(Arrays.asList(spec.split("\\s+")));
        return AcrfExtractorTui.createEvaluator(toks);
    }

    private static ExtractionEvaluator createExtractionEvaluator(String spec) throws EvalError {
        if (spec.indexOf(40) >= 0) {
            return (ExtractionEvaluator)interpreter.eval(spec);
        }
        spec = "new " + spec + "Evaluator ()";
        return (ExtractionEvaluator)interpreter.eval(spec);
    }

    private static ACRFEvaluator createEvaluator(LinkedList toks) {
        String type = (String)toks.removeFirst();
        if (type.equalsIgnoreCase("SEGMENT")) {
            int slice2 = Integer.parseInt((String)toks.removeFirst());
            if (toks.size() % 2 != 0) {
                throw new RuntimeException("Error in --eval " + AcrfExtractorTui.evalOption.value + ": Every start tag must have a continue.");
            }
            int numTags = toks.size() / 2;
            Object[] startTags = new String[numTags];
            Object[] continueTags = new String[numTags];
            for (int i = 0; i < numTags; ++i) {
                startTags[i] = (String)toks.removeFirst();
                continueTags[i] = (String)toks.removeFirst();
            }
            return new MultiSegmentationEvaluatorACRF(startTags, continueTags, slice2);
        }
        if (type.equalsIgnoreCase("LOG")) {
            return new DefaultAcrfTrainer.LogEvaluator();
        }
        if (type.equalsIgnoreCase("SERIAL")) {
            ArrayList<ACRFEvaluator> evals = new ArrayList<ACRFEvaluator>();
            while (!toks.isEmpty()) {
                evals.add(AcrfExtractorTui.createEvaluator(toks));
            }
            return new AcrfSerialEvaluator(evals);
        }
        throw new RuntimeException("Error in --eval " + AcrfExtractorTui.evalOption.value + ": illegal evaluator " + type);
    }

    private static ACRFExtractorTrainer createTrainer(String spec) throws EvalError {
        String cmd = spec.indexOf(40) >= 0 ? spec : (spec.endsWith("Trainer") ? "new " + spec + "()" : "new " + spec + "Trainer()");
        Object trainer = interpreter.eval(cmd);
        if (trainer instanceof ACRFExtractorTrainer) {
            return (ACRFExtractorTrainer)trainer;
        }
        if (trainer instanceof DefaultAcrfTrainer) {
            return new ACRFExtractorTrainer().setTrainingMethod((ACRFTrainer)trainer);
        }
        throw new RuntimeException("Don't know what to do with trainer " + trainer);
    }

    private static Inferencer createInferencer(String spec) throws EvalError {
        String cmd = spec.indexOf(40) >= 0 ? spec : "new " + spec + "()";
        Object inf = interpreter.eval(cmd);
        if (inf instanceof Inferencer) {
            return (Inferencer)inf;
        }
        throw new RuntimeException("Don't know what to do with inferencer " + inf);
    }

    public static void doProcessOptions(Class childClass, String[] args) {
        CommandOption.List options = new CommandOption.List("", new CommandOption[0]);
        options.add(childClass);
        options.process(args);
        options.logOptions(Logger.getLogger(""));
    }

    private static ACRF.Template[] parseModelFile(File mdlFile) throws IOException, EvalError {
        BufferedReader in = new BufferedReader(new FileReader(mdlFile));
        ArrayList<Object> tmpls = new ArrayList<Object>();
        String line = in.readLine();
        while (line != null) {
            Object tmpl = interpreter.eval(line);
            if (!(tmpl instanceof ACRF.Template)) {
                throw new RuntimeException("Error in " + mdlFile + " line " + in.toString() + ":\n  Object " + tmpl + " not a template");
            }
            tmpls.add(tmpl);
            line = in.readLine();
        }
        return tmpls.toArray(new ACRF.Template[0]);
    }
}

