/*
 * Decompiled with CFR 0.152.
 */
package cc.mallet.grmm.learning;

import cc.mallet.extract.StringSpan;
import cc.mallet.extract.StringTokenization;
import cc.mallet.grmm.util.LabelsAssignment;
import cc.mallet.pipe.Pipe;
import cc.mallet.types.Alphabet;
import cc.mallet.types.Instance;
import cc.mallet.types.Label;
import cc.mallet.types.LabelAlphabet;
import cc.mallet.types.Labels;
import cc.mallet.types.LabelsSequence;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;

public class GenericAcrfData2TokenSequence
extends Pipe {
    private ArrayList labelDicts = new ArrayList();
    private int numLabels = -1;
    private boolean includeTokenText = true;
    private String textFeaturePrefix = "WORD=";
    private boolean featuresIncludeToken = true;
    private boolean labelsAtEnd = false;
    private static final long serialVersionUID = 1L;
    private static final int CURRENT_SERIAL_VERSION = 2;

    public GenericAcrfData2TokenSequence() {
        super(new Alphabet(), new LabelAlphabet());
        this.labelDicts.add(this.getTargetAlphabet());
    }

    public GenericAcrfData2TokenSequence(int numLabels) {
        super(new Alphabet(), new LabelAlphabet());
        this.numLabels = numLabels;
        this.labelDicts.add(this.getTargetAlphabet());
    }

    public void setIncludeTokenText(boolean includeTokenText) {
        this.includeTokenText = includeTokenText;
    }

    public void setFeaturesIncludeToken(boolean featuresIncludeToken) {
        this.featuresIncludeToken = featuresIncludeToken;
    }

    public boolean getFeaturesIncludeToken() {
        return this.featuresIncludeToken;
    }

    public void setTextFeaturePrefix(String textFeaturePrefix) {
        this.textFeaturePrefix = textFeaturePrefix;
    }

    public LabelAlphabet getLabelAlphabet(int lvl) {
        return (LabelAlphabet)this.labelDicts.get(lvl);
    }

    public int numLevels() {
        return this.labelDicts.size();
    }

    @Override
    public Instance pipe(Instance carrier) {
        if (!(carrier.getData() instanceof CharSequence)) {
            throw new ClassCastException("Needed a String; got " + carrier.getData());
        }
        String input2 = String.valueOf(carrier.getData());
        String[] lines2 = input2.split("\n");
        Object[] spans = new StringSpan[lines2.length];
        Labels[] lbls = new Labels[lines2.length];
        StringBuffer buf = new StringBuffer();
        Alphabet dict = this.getDataAlphabet();
        for (int i = 0; i < lines2.length; ++i) {
            String line = lines2[i];
            String[] toks = line.split("\\s+");
            int j = 0;
            ArrayList<Label> thisLabels = new ArrayList<Label>();
            if (!this.labelsAtEnd) {
                while (!this.isLabelSeparator(toks, j)) {
                    thisLabels.add(this.labelForTok(toks[j], j));
                    ++j;
                }
                if (j < toks.length && toks[j].equals("----")) {
                    ++j;
                }
                lbls[i] = new Labels(thisLabels.toArray(new Label[thisLabels.size()]));
            }
            int maxFeatureIdx = this.labelsAtEnd ? toks.length - this.numLabels : toks.length;
            String text2 = "*???*";
            if (this.featuresIncludeToken && j < maxFeatureIdx) {
                text2 = toks[j++];
            }
            int start = buf.length();
            buf.append(text2);
            int end = buf.length();
            buf.append(" ");
            StringSpan span2 = new StringSpan(buf, start, end);
            while (j < maxFeatureIdx) {
                span2.setFeatureValue(toks[j].intern(), 1.0);
                ++j;
            }
            if (this.includeTokenText) {
                span2.setFeatureValue((this.textFeaturePrefix + text2).intern(), 1.0);
            }
            if (this.labelsAtEnd) {
                int firstLblIdx = j;
                while (j < toks.length) {
                    thisLabels.add(this.labelForTok(toks[j], j - firstLblIdx));
                    ++j;
                }
                lbls[i] = new Labels(thisLabels.toArray(new Label[thisLabels.size()]));
            }
            spans[i] = span2;
        }
        StringTokenization tokenization = new StringTokenization(buf);
        tokenization.addAll(spans);
        carrier.setData(tokenization);
        carrier.setTarget(new LabelsAssignment(new LabelsSequence(lbls)));
        return carrier;
    }

    private Label labelForTok(String tok, int lvl) {
        while (this.labelDicts.size() <= lvl) {
            this.labelDicts.add(new LabelAlphabet());
        }
        LabelAlphabet dict = (LabelAlphabet)this.labelDicts.get(lvl);
        return dict.lookupLabel(tok);
    }

    private boolean isLabelSeparator(String[] toks, int j) {
        if (this.numLabels > 0) {
            return j >= this.numLabels;
        }
        return toks[j].equals("----");
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        out.writeInt(2);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        int version = in.readInt();
        if (version <= 1) {
            this.featuresIncludeToken = true;
        }
    }

    public boolean isLabelsAtEnd() {
        return this.labelsAtEnd;
    }

    public void setLabelsAtEnd(boolean labelsAtEnd) {
        this.labelsAtEnd = labelsAtEnd;
    }
}

