/*
 * Decompiled with CFR 0.152.
 */
package cc.mallet.grmm.learning;

import cc.mallet.grmm.learning.ACRF;
import cc.mallet.grmm.util.GeneralUtils;
import cc.mallet.types.InstanceList;
import cc.mallet.util.FileUtils;
import java.io.File;
import java.io.IOException;
import java.util.List;

public abstract class ACRFEvaluator {
    private int numIterToSkip = 10;
    private int numIterToWait = 1;
    private File outputPrefix;

    public void setNumIterToSkip(int n) {
        this.numIterToSkip = n;
    }

    public void setNumIterToWait(int n) {
        this.numIterToWait = n;
    }

    public abstract boolean evaluate(ACRF var1, int var2, InstanceList var3, InstanceList var4, InstanceList var5);

    public abstract void test(InstanceList var1, List var2, String var3);

    public void test(ACRF acrf, InstanceList data2, String description) {
        List ret = acrf.getBestLabels(data2);
        this.test(data2, ret, description);
    }

    public void setOutputPrefix(File file) {
        this.outputPrefix = file;
    }

    protected File makeOutputFile() {
        try {
            String name = GeneralUtils.classShortName(this);
            return FileUtils.uniqueFile(this.outputPrefix, name, ".log");
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected boolean shouldDoEvaluate(int iter2) {
        if (iter2 < this.numIterToWait) {
            return false;
        }
        return this.numIterToSkip <= 0 || iter2 % this.numIterToSkip == 0;
    }
}

