/*
 * Decompiled with CFR 0.152.
 */
package cc.mallet.grmm.inference.gbp;

import cc.mallet.grmm.inference.gbp.Region;
import cc.mallet.grmm.inference.gbp.RegionEdge;
import cc.mallet.grmm.types.Factor;
import cc.mallet.grmm.types.VarSet;
import cc.mallet.grmm.types.Variable;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

class RegionGraph {
    private Set regions = new THashSet();
    private List edges = new ArrayList();

    void add(Region parent, Region child) {
        if (!this.isConnected(parent, child)) {
            this.addRegion(parent);
            this.addRegion(child);
            child.isRoot = false;
            if (parent.children == null) {
                parent.children = new ArrayList();
            }
            parent.children.add(child);
            if (child.parents == null) {
                child.parents = new ArrayList();
            }
            child.parents.add(parent);
            this.edges.add(new RegionEdge(parent, child));
        }
    }

    private boolean isConnected(Region parent, Region child) {
        return parent.children.contains(child);
    }

    private void addRegion(Region region) {
        if (this.regions.add(region)) {
            if (region.index != -1) {
                throw new IllegalArgumentException("Region " + region + " has already been added to a different region graph.");
            }
            region.index = this.regions.size() - 1;
        }
    }

    int size() {
        return this.regions.size();
    }

    Iterator iterator() {
        return this.regions.iterator();
    }

    Iterator edgeIterator() {
        return this.edges.iterator();
    }

    public void computeInferenceCaches() {
        this.computeDescendants();
        this.includeDescendantFactors();
        this.computeFactorsToSend();
        this.computeCountingNumbers();
        this.computeCousins();
        this.computeNeighboringParents();
        this.computeLoopingMessages();
    }

    private void includeDescendantFactors() {
        Iterator it = this.iterator();
        while (it.hasNext()) {
            Region region = (Region)it.next();
            for (Region descendant2 : region.descendants) {
                region.factors.addAll(descendant2.factors);
            }
        }
    }

    private void computeLoopingMessages() {
        Iterator it = this.edgeIterator();
        while (it.hasNext()) {
            RegionEdge edge = (RegionEdge)it.next();
            Region to2 = edge.to;
            ArrayList<RegionEdge> result2 = new ArrayList<RegionEdge>();
            for (Region cousin : edge.cousins) {
                if (cousin == edge.from) continue;
                for (Region cousinChild : cousin.children) {
                    if (cousinChild != to2 && !to2.descendants.contains(cousinChild)) continue;
                    result2.add(this.findEdge(cousin, cousinChild));
                }
            }
            edge.loopingMessages = result2;
        }
    }

    private void computeCountingNumbers() {
        LinkedList<Region> queue = new LinkedList<Region>();
        for (Region region : this.regions) {
            if (!region.isRoot) continue;
            queue.add(region);
        }
        while (!queue.isEmpty()) {
            Region region = (Region)queue.removeFirst();
            int parentCnt = 0;
            for (Region parent : region.parents) {
                parentCnt += parent.countingNumber;
            }
            region.countingNumber = 1 - parentCnt;
            queue.addAll(region.children);
        }
    }

    private void computeFactorsToSend() {
        for (RegionEdge edge : this.edges) {
            edge.initializeFactorsToSend();
        }
    }

    private void computeCousins() {
        Iterator it = this.edgeIterator();
        while (it.hasNext()) {
            RegionEdge edge = (RegionEdge)it.next();
            THashSet<Region> cousins = new THashSet<Region>(edge.from.descendants);
            cousins.removeAll(edge.to.descendants);
            cousins.remove(edge.to);
            cousins.add(edge.from);
            edge.cousins = cousins;
        }
    }

    private void computeDescendants() {
        for (Region region : this.regions) {
            if (!region.isRoot) continue;
            this.computeDescendantsRec(region);
        }
    }

    private void computeDescendantsRec(Region region) {
        THashSet<Region> descendants = new THashSet<Region>(region.children.size());
        for (Region child : region.children) {
            this.computeDescendantsRec(child);
            descendants.add(child);
            descendants.addAll(child.descendants);
        }
        region.descendants = descendants;
    }

    private void computeNeighboringParents() {
        Iterator it = this.edgeIterator();
        while (it.hasNext()) {
            RegionEdge edge = (RegionEdge)it.next();
            edge.neighboringParents = new ArrayList();
            LinkedList l = new LinkedList(this.regions);
            l.removeAll(edge.from.descendants);
            l.remove(edge.from);
            for (Region uncle : l) {
                for (Region cousin : uncle.children) {
                    if (!edge.cousins.contains(cousin)) continue;
                    edge.neighboringParents.add(this.findEdge(uncle, cousin));
                }
            }
        }
    }

    private RegionEdge findEdge(Region uncle, Region cousin) {
        int idx = this.edges.indexOf(new RegionEdge(uncle, cousin));
        return (RegionEdge)this.edges.get(idx);
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("REGION GRAPH\nRegions:\n");
        for (Region region : this.regions) {
            buf.append("\n    ");
            buf.append(region);
        }
        buf.append("\nEdges:");
        for (RegionEdge edge : this.edges) {
            buf.append("\n   ");
            buf.append(edge.from);
            buf.append(" --> ");
            buf.append(edge.to);
        }
        buf.append("\n");
        return buf.toString();
    }

    public boolean contains(Region region) {
        return this.regions.contains(region);
    }

    public Region findRegion(Factor ptl, boolean doCreate) {
        VarSet allVars = ptl.varSet();
        for (Region region : this.regions) {
            if (region.vars.size() != allVars.size() || !region.vars.containsAll(allVars)) continue;
            return region;
        }
        if (doCreate) {
            Region region = new Region(ptl);
            this.addRegion(region);
            return region;
        }
        return null;
    }

    public Region findRegion(Variable var, boolean doCreate) {
        for (Region region : this.regions) {
            if (region.vars.size() != 1 || !region.vars.contains(var)) continue;
            return region;
        }
        if (doCreate) {
            Region region = new Region(var);
            this.addRegion(region);
            return region;
        }
        return null;
    }

    public Region findContainingRegion(Variable variable) {
        Region ret = null;
        for (Region region : this.regions) {
            if (!region.vars.contains(variable) || ret != null && region.vars.size() >= ret.vars.size()) continue;
            ret = region;
        }
        return ret;
    }

    public Region findContainingRegion(VarSet varSet) {
        Region ret = null;
        for (Region region : this.regions) {
            if (!region.vars.containsAll(varSet) || ret != null && region.vars.size() >= ret.vars.size()) continue;
            ret = region;
        }
        return ret;
    }

    public int numEdges() {
        return this.edges.size();
    }
}

