/*
 * Decompiled with CFR 0.152.
 */
package cc.mallet.grmm.inference.gbp;

import cc.mallet.grmm.inference.gbp.AbstractMessageStrategy;
import cc.mallet.grmm.inference.gbp.MessageArray;
import cc.mallet.grmm.inference.gbp.Region;
import cc.mallet.grmm.inference.gbp.RegionEdge;
import cc.mallet.grmm.inference.gbp.RegionGraph;
import cc.mallet.grmm.types.DiscreteFactor;
import cc.mallet.grmm.types.Factor;
import cc.mallet.grmm.types.Factors;
import cc.mallet.grmm.types.TableFactor;
import java.util.Iterator;

public class FullMessageStrategy
extends AbstractMessageStrategy {
    private static final boolean debug = false;
    private static final boolean debugLite = false;

    @Override
    public void sendMessage(RegionEdge edge) {
        Factor product2 = this.msgProduct(edge);
        Region from2 = edge.from;
        Region to2 = edge.to;
        for (Factor ptl : edge.factorsToSend) {
            product2.multiplyBy(ptl);
        }
        TableFactor result2 = (TableFactor)product2.marginalize(to2.vars);
        result2.normalize();
        this.newMessages.setMessage(from2, to2, result2);
    }

    private boolean willBeNaN(Factor product2, Factor otherMsg) {
        Factor p2 = product2.duplicate();
        p2.divideBy(otherMsg);
        return p2.isNaN();
    }

    private boolean willBeNaN2(Factor product2, Factor otherMsg) {
        Factor p2 = product2.duplicate();
        p2.multiplyBy(otherMsg);
        return p2.isNaN();
    }

    @Override
    public MessageArray averageMessages(RegionGraph rg, MessageArray a1, MessageArray a2, double inertiaWeight) {
        MessageArray arr = new MessageArray(rg);
        Iterator it = rg.edgeIterator();
        while (it.hasNext()) {
            RegionEdge edge = (RegionEdge)it.next();
            DiscreteFactor msg1 = a1.getMessage(edge.from, edge.to);
            DiscreteFactor msg2 = a2.getMessage(edge.from, edge.to);
            if (msg1 == null) continue;
            TableFactor averaged = (TableFactor)Factors.average(msg1, msg2, inertiaWeight);
            arr.setMessage(edge.from, edge.to, averaged);
        }
        return arr;
    }
}

