/*
 * Decompiled with CFR 0.152.
 */
package cc.mallet.fst.tests;

import cc.mallet.fst.FeatureTransducer;
import cc.mallet.fst.MaxLatticeDefault;
import cc.mallet.fst.SumLatticeDefault;
import cc.mallet.types.Alphabet;
import cc.mallet.types.ArrayListSequence;
import cc.mallet.types.Multinomial;
import java.util.Iterator;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class TestFeatureTransducer
extends TestCase {
    FeatureTransducer transducer;
    ArrayListSequence seq;
    double seqWeight;

    public TestFeatureTransducer(String name) {
        super(name);
    }

    public void setUp() {
        System.out.println("Setup");
        FeatureTransducer t = this.transducer = new FeatureTransducer();
        t.addState("0", 0.0, Double.NEGATIVE_INFINITY, new String[]{"a", "b"}, new String[]{"x", "y"}, new double[]{44.0, 66.0}, new String[]{"0", "1"});
        t.addState("1", Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, new String[]{"c", "d", "d"}, new String[]{"x", "y", "z"}, new double[]{44.0, 11.0, 66.0}, new String[]{"1", "1", "2"});
        t.addState("2", Double.NEGATIVE_INFINITY, 8.0, new String[]{"e"}, new String[]{"z"}, new double[]{11.0}, new String[]{"2"});
        this.seq = new ArrayListSequence();
        Alphabet dict = this.transducer.getInputAlphabet();
        this.seq.add("a");
        this.seq.add("a");
        this.seq.add("b");
        this.seq.add("c");
        this.seq.add("d");
        this.seq.add("e");
        this.seqWeight = 283.0;
    }

    public void testInitialState() {
        Iterator<FeatureTransducer.State> iter2 = this.transducer.initialStateIterator();
        int count2 = 0;
        while (iter2.hasNext()) {
            ++count2;
            FeatureTransducer.State state = iter2.next();
            TestFeatureTransducer.assertTrue((boolean)state.getName().equals("0"));
        }
        TestFeatureTransducer.assertTrue((count2 == 1 ? 1 : 0) != 0);
    }

    public void testForwardBackward() {
        SumLatticeDefault lattice = new SumLatticeDefault(this.transducer, this.seq);
        System.out.println("weight= " + lattice.getTotalWeight());
        TestFeatureTransducer.assertTrue((lattice.getTotalWeight() == this.seqWeight ? 1 : 0) != 0);
    }

    public void testViterbi() {
        double weight = new MaxLatticeDefault(this.transducer, this.seq).bestWeight();
        System.out.println("weight = " + weight);
        TestFeatureTransducer.assertTrue((weight == this.seqWeight ? 1 : 0) != 0);
    }

    public void testEstimate() {
        this.transducer.setTrainable(true);
        SumLatticeDefault lattice = new SumLatticeDefault(this.transducer, this.seq);
        double oldWeight = lattice.getTotalWeight();
        this.transducer.estimate();
        lattice = new SumLatticeDefault(this.transducer, this.seq);
        double newWeight = lattice.getTotalWeight();
        System.out.println("oldWeight=" + oldWeight + " newWeight=" + newWeight);
        TestFeatureTransducer.assertTrue((newWeight < oldWeight ? 1 : 0) != 0);
    }

    public void testIncrement() {
        this.transducer.setTrainable(true);
        SumLatticeDefault lattice = new SumLatticeDefault(this.transducer, this.seq);
        double oldWeight = lattice.getTotalWeight();
        System.out.println("State 0 transition estimator");
        Multinomial.Estimator est = ((FeatureTransducer.State)this.transducer.getState(0)).getTransitionEstimator();
        est.print();
        TestFeatureTransducer.assertTrue((est.getCount(0) == 2.0 ? 1 : 0) != 0);
        TestFeatureTransducer.assertTrue((est.getCount(1) == 1.0 ? 1 : 0) != 0);
    }

    public static Test suite() {
        return new TestSuite(TestFeatureTransducer.class);
    }

    public static void main(String[] args) {
        TestRunner.run((Test)TestFeatureTransducer.suite());
    }
}

