/*
 * Decompiled with CFR 0.152.
 */
package cc.mallet.fst.confidence;

import cc.mallet.fst.Segment;
import cc.mallet.fst.SumLatticeDefault;
import cc.mallet.fst.Transducer;
import cc.mallet.pipe.Noop;
import cc.mallet.pipe.iterator.SegmentIterator;
import cc.mallet.types.Instance;
import cc.mallet.types.InstanceList;
import cc.mallet.util.MalletLogger;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Vector;
import java.util.logging.Logger;

public abstract class TransducerConfidenceEstimator
implements Serializable {
    private static Logger logger = MalletLogger.getLogger(TransducerConfidenceEstimator.class.getName());
    protected Transducer model;
    Vector segmentConfidences;

    public TransducerConfidenceEstimator(Transducer model) {
        this.model = model;
    }

    public double estimateConfidenceFor(Segment segment) {
        return this.estimateConfidenceFor(segment, null);
    }

    public abstract double estimateConfidenceFor(Segment var1, SumLatticeDefault var2);

    public Vector getSegmentConfidences() {
        return this.segmentConfidences;
    }

    public Segment[] rankSegmentsByConfidence(InstanceList ilist, Object[] startTags, Object[] continueTags) {
        ArrayList<Segment> segmentList = new ArrayList<Segment>();
        SegmentIterator iter2 = new SegmentIterator(this.model, ilist, startTags, continueTags);
        if (this.segmentConfidences == null) {
            this.segmentConfidences = new Vector();
        }
        while (iter2.hasNext()) {
            Segment segment = iter2.nextSegment();
            double confidence = this.estimateConfidenceFor(segment);
            segment.setConfidence(confidence);
            logger.fine("confidence=" + segment.getConfidence() + " for segment\n" + segment.sequenceToString() + "\n");
            segmentList.add(segment);
        }
        Collections.sort(segmentList);
        Segment[] ret = new Segment[1];
        ret = segmentList.toArray(ret);
        return ret;
    }

    public Segment[] rankSegmentsByConfidence(Instance instance, Object[] startTags, Object[] continueTags) {
        InstanceList ilist = new InstanceList(new Noop(instance.getDataAlphabet(), instance.getTargetAlphabet()));
        ilist.add(instance);
        return this.rankSegmentsByConfidence(ilist, startTags, continueTags);
    }

    public Transducer getTransducer() {
        return this.model;
    }
}

