/*
 * Decompiled with CFR 0.152.
 */
package cc.mallet.fst.confidence;

import cc.mallet.fst.Segment;
import cc.mallet.fst.SumLatticeConstrained;
import cc.mallet.fst.SumLatticeDefault;
import cc.mallet.fst.Transducer;
import cc.mallet.fst.confidence.TransducerConfidenceEstimator;
import cc.mallet.types.Sequence;

public class ConstrainedForwardBackwardConfidenceEstimator
extends TransducerConfidenceEstimator {
    private static final long serialVersionUID = 1L;

    public ConstrainedForwardBackwardConfidenceEstimator(Transducer model) {
        super(model);
    }

    @Override
    public double estimateConfidenceFor(Segment segment, SumLatticeDefault cachedLattice) {
        Sequence predSequence = segment.getPredicted();
        Sequence input2 = segment.getInput();
        SumLatticeDefault lattice = cachedLattice == null ? new SumLatticeDefault(this.model, input2) : cachedLattice;
        SumLatticeConstrained constrainedLattice = new SumLatticeConstrained(this.model, input2, null, segment, predSequence);
        double latticeWeight = lattice.getTotalWeight();
        double constrainedLatticeWeight = constrainedLattice.getTotalWeight();
        double confidence = Math.exp(latticeWeight - constrainedLatticeWeight);
        return confidence;
    }
}

