/*
 * Decompiled with CFR 0.152.
 */
package cc.mallet.fst.confidence;

import cc.mallet.fst.Segment;
import cc.mallet.fst.confidence.InstanceWithConfidence;
import cc.mallet.fst.confidence.PipedInstanceWithConfidence;
import cc.mallet.types.FeatureVector;
import cc.mallet.types.Sequence;
import java.util.Collections;
import java.util.Comparator;
import java.util.Vector;

public class ConfidenceEvaluator {
    static int DEFAULT_NUM_BINS = 20;
    Vector confidences;
    int nBins;
    int numCorrect;

    public ConfidenceEvaluator(Vector confidences, int nBins) {
        this.confidences = confidences;
        this.nBins = nBins;
        this.numCorrect = this.getNumCorrectEntities();
        Collections.sort(confidences, new ConfidenceComparator());
    }

    public ConfidenceEvaluator(Vector confidences) {
        this(confidences, DEFAULT_NUM_BINS);
    }

    public ConfidenceEvaluator(Segment[] segments, boolean sorted2) {
        this.confidences = new Vector();
        for (int i = 0; i < segments.length; ++i) {
            this.confidences.add(new EntityConfidence(segments[i].getConfidence(), segments[i].correct(), segments[i].getInput(), segments[i].getStart(), segments[i].getEnd()));
        }
        if (!sorted2) {
            Collections.sort(this.confidences, new ConfidenceComparator());
        }
        this.nBins = DEFAULT_NUM_BINS;
        this.numCorrect = this.getNumCorrectEntities();
    }

    public ConfidenceEvaluator(InstanceWithConfidence[] instances, boolean sorted2) {
        this.confidences = new Vector();
        for (int i = 0; i < instances.length; ++i) {
            Sequence input2 = (Sequence)instances[i].getInstance().getData();
            this.confidences.add(new EntityConfidence(instances[i].getConfidence(), instances[i].correct(), input2, 0, input2.size() - 1));
        }
        if (!sorted2) {
            Collections.sort(this.confidences, new ConfidenceComparator());
        }
        this.nBins = DEFAULT_NUM_BINS;
        this.numCorrect = this.getNumCorrectEntities();
    }

    public ConfidenceEvaluator(PipedInstanceWithConfidence[] instances, boolean sorted2) {
        this.confidences = new Vector();
        for (int i = 0; i < instances.length; ++i) {
            this.confidences.add(new EntityConfidence(instances[i].getConfidence(), instances[i].correct(), null, 0, 1));
        }
        if (!sorted2) {
            Collections.sort(this.confidences, new ConfidenceComparator());
        }
        this.nBins = DEFAULT_NUM_BINS;
        this.numCorrect = this.getNumCorrectEntities();
    }

    public double pointBiserialCorrelation() {
        double x0bar = this.getAverageIncorrectConfidence();
        double x1bar = this.getAverageCorrectConfidence();
        double p = (double)this.numCorrect / (double)this.size();
        double sx = this.getConfidenceStandardDeviation();
        return (x1bar - x0bar) * Math.sqrt(p * (1.0 - p)) / sx;
    }

    public double getAveragePrecision() {
        int nc = 0;
        int ni = 0;
        double totalPrecision = 0.0;
        for (int i = this.confidences.size() - 1; i >= 0; --i) {
            EntityConfidence c = (EntityConfidence)this.confidences.get(i);
            if (c.correct()) {
                totalPrecision += (double)(++nc) / (double)(nc + ni);
                continue;
            }
            ++ni;
        }
        return totalPrecision / (double)nc;
    }

    public double getWorstAveragePrecision() {
        int ni = this.confidences.size() - this.numCorrect;
        double totalPrecision = 0.0;
        for (int nc = 1; nc <= this.numCorrect; ++nc) {
            totalPrecision += (double)nc / (double)(nc + ni);
        }
        return totalPrecision / (double)this.numCorrect;
    }

    public double getConfidenceSum() {
        double sum2 = 0.0;
        for (int i = 0; i < this.size(); ++i) {
            sum2 += ((EntityConfidence)this.confidences.get(i)).confidence();
        }
        return sum2;
    }

    public double getConfidenceMean() {
        return this.getConfidenceSum() / (double)this.size();
    }

    public double getConfidenceStandardDeviation() {
        double mean = this.getConfidenceMean();
        double sumSquaredDifference = 0.0;
        for (int i = 0; i < this.size(); ++i) {
            double conf = ((EntityConfidence)this.confidences.get(i)).confidence();
            sumSquaredDifference += (conf - mean) * (conf - mean);
        }
        return Math.sqrt(sumSquaredDifference / (double)this.size());
    }

    public double correlation() {
        double xSum = 0.0;
        double xSumOfSquares = 0.0;
        double ySum = 0.0;
        double ySumOfSquares = 0.0;
        double xySum = 0.0;
        for (int i = 0; i < this.size(); ++i) {
            double value2 = ((EntityConfidence)this.confidences.get(i)).correct() ? 1.0 : -1.0;
            xSum += value2;
            xSumOfSquares += value2 * value2;
            double conf = ((EntityConfidence)this.confidences.get(i)).confidence();
            ySum += conf;
            ySumOfSquares += conf * conf;
            xySum += value2 * conf;
        }
        double xVariance = xSumOfSquares - xSum * xSum / (double)this.size();
        double yVariance = ySumOfSquares - ySum * ySum / (double)this.size();
        double crossVariance = xySum - xSum * ySum / (double)this.size();
        return crossVariance / Math.sqrt(xVariance * yVariance);
    }

    public double[] getAccuracyCoverageValues() {
        double[] values2 = new double[this.nBins];
        int step = 100 / this.nBins;
        for (int i = 0; i < values2.length; ++i) {
            values2[i] = this.accuracyAtCoverage((double)step * (double)(i + 1) / 100.0);
        }
        return values2;
    }

    public String accuracyCoverageValuesToString() {
        String buf = "";
        double[] vals = this.getAccuracyCoverageValues();
        int step = 100 / this.nBins;
        for (int i = 0; i < vals.length; ++i) {
            buf = buf + (double)step * (double)(i + 1) / 100.0 + "\t" + vals[i] + "\n";
        }
        return buf;
    }

    public double[][] getAccuracyRecallValues(int totalTrue) {
        double[][] values2 = new double[this.nBins][2];
        int step = 100 / this.nBins;
        for (int i = 0; i < this.nBins; ++i) {
            values2[i] = new double[2];
            double coverage = (double)step * (double)(i + 1) / 100.0;
            values2[i][1] = this.accuracyAtCoverage(coverage);
            int numCorrect = this.numCorrectAtCoverage(coverage);
            values2[i][0] = (double)numCorrect / (double)totalTrue;
        }
        return values2;
    }

    public String accuracyRecallValuesToString(int totalTrue) {
        String buf = "";
        double[][] vals = this.getAccuracyRecallValues(totalTrue);
        for (int i = 0; i < this.nBins; ++i) {
            buf = buf + vals[i][0] + "\t" + vals[i][1] + "\n";
        }
        return buf;
    }

    public double accuracyAtCoverage(double cov) {
        assert (cov <= 1.0 && cov > 0.0);
        int numPoints = (int)Math.round((double)this.size() * cov);
        return (double)this.numCorrectAtCoverage(cov) / (double)numPoints;
    }

    public int numCorrectAtCoverage(double cov) {
        assert (cov <= 1.0 && cov > 0.0);
        int numPoints = (int)Math.round((double)this.size() * cov);
        int numCorrect = 0;
        for (int i = 0; i < numPoints; ++i) {
            if (!((EntityConfidence)this.confidences.get(this.size() - i - 1)).correct()) continue;
            ++numCorrect;
        }
        return numCorrect;
    }

    public double getAverageAccuracy() {
        int numCorrect = 0;
        double totalArea = 0.0;
        for (int i = this.confidences.size() - 1; i >= 0; --i) {
            if (((EntityConfidence)this.confidences.get(i)).correct()) {
                ++numCorrect;
            }
            totalArea += (double)numCorrect / (double)(this.confidences.size() - i);
        }
        return totalArea / (double)this.confidences.size();
    }

    public int numCorrect() {
        return this.numCorrect;
    }

    private int getNumCorrectEntities() {
        int sum2 = 0;
        for (int i = 0; i < this.confidences.size(); ++i) {
            EntityConfidence ec = (EntityConfidence)this.confidences.get(i);
            if (!ec.correct()) continue;
            ++sum2;
        }
        return sum2;
    }

    public double getAverageIncorrectConfidence() {
        double sum2 = 0.0;
        for (int i = 0; i < this.confidences.size(); ++i) {
            EntityConfidence ec = (EntityConfidence)this.confidences.get(i);
            if (ec.correct()) continue;
            sum2 += ec.confidence();
        }
        return sum2 / ((double)this.size() - (double)this.numCorrect);
    }

    public double getAverageCorrectConfidence() {
        double sum2 = 0.0;
        for (int i = 0; i < this.confidences.size(); ++i) {
            EntityConfidence ec = (EntityConfidence)this.confidences.get(i);
            if (!ec.correct()) continue;
            sum2 += ec.confidence();
        }
        return sum2 / (double)this.numCorrect;
    }

    public int size() {
        return this.confidences.size();
    }

    public String toString() {
        StringBuffer toReturn = new StringBuffer();
        for (int i = 0; i < this.size(); ++i) {
            toReturn.append(((EntityConfidence)this.confidences.get(i)).toString() + " ");
        }
        return toReturn.toString();
    }

    private class ConfidenceComparator
    implements Comparator {
        private ConfidenceComparator() {
        }

        public final int compare(Object a, Object b) {
            double x2 = ((EntityConfidence)a).confidence();
            double y = ((EntityConfidence)b).confidence();
            double difference = x2 - y;
            int toReturn = 0;
            if (difference > 0.0) {
                toReturn = 1;
            } else if (difference < 0.0) {
                toReturn = -1;
            }
            return toReturn;
        }
    }

    public static class EntityConfidence {
        double confidence;
        boolean correct;
        String entity;

        public EntityConfidence(double conf, boolean corr, String text2) {
            this.confidence = conf;
            this.correct = corr;
            this.entity = text2;
        }

        public EntityConfidence(double conf, boolean corr, Sequence input2, int start, int end) {
            this.confidence = conf;
            this.correct = corr;
            StringBuffer buff = new StringBuffer();
            if (input2 != null) {
                for (int j = start; j <= end; ++j) {
                    FeatureVector fv = (FeatureVector)input2.get(j);
                    for (int k = 0; k < fv.numLocations(); ++k) {
                        String featureName = fv.getAlphabet().lookupObject(fv.indexAtLocation(k)).toString();
                        if (!featureName.startsWith("W=") || featureName.indexOf("@") != -1) continue;
                        buff.append(featureName.substring(featureName.indexOf(61) + 1) + " ");
                    }
                }
            }
            this.entity = buff.toString();
        }

        public double confidence() {
            return this.confidence;
        }

        public boolean correct() {
            return this.correct;
        }

        public String toString() {
            StringBuffer toReturn = new StringBuffer();
            toReturn.append(this.entity + " / " + this.confidence + " / " + (this.correct ? "correct" : "incorrect") + "\n");
            return toReturn.toString();
        }
    }
}

