/*
 * Decompiled with CFR 0.152.
 */
package cc.mallet.fst;

import cc.mallet.fst.Transducer;
import cc.mallet.types.Alphabet;
import cc.mallet.types.Multinomial;
import cc.mallet.types.Sequence;
import cc.mallet.util.MalletLogger;
import gnu.trove.TIntObjectHashMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.logging.Logger;

public class FeatureTransducer
extends Transducer {
    private static Logger logger = MalletLogger.getLogger(FeatureTransducer.class.getName());
    Alphabet inputAlphabet;
    Alphabet outputAlphabet;
    ArrayList<State> states = new ArrayList();
    ArrayList<State> initialStates = new ArrayList();
    HashMap<String, State> name2state = new HashMap();
    Multinomial.Estimator initialStateCounts;
    Multinomial.Estimator finalStateCounts;
    boolean trainable = false;
    private static final long serialVersionUID = 1L;

    public FeatureTransducer(Alphabet inputAlphabet, Alphabet outputAlphabet) {
        this.inputAlphabet = inputAlphabet;
        this.outputAlphabet = outputAlphabet;
    }

    public FeatureTransducer(Alphabet dictionary) {
        this(dictionary, dictionary);
    }

    public FeatureTransducer() {
        this(new Alphabet());
    }

    public Alphabet getInputAlphabet() {
        return this.inputAlphabet;
    }

    public Alphabet getOutputAlphabet() {
        return this.outputAlphabet;
    }

    public void addState(String name, double initialWeight, double finalWeight, int[] inputs, int[] outputs, double[] weights, String[] destinationNames) {
        if (this.name2state.get(name) != null) {
            throw new IllegalArgumentException("State with name `" + name + "' already exists.");
        }
        State s = new State(name, this.states.size(), initialWeight, finalWeight, inputs, outputs, weights, destinationNames, this);
        this.states.add(s);
        if (initialWeight < Double.NEGATIVE_INFINITY) {
            this.initialStates.add(s);
        }
        this.name2state.put(name, s);
        this.setTrainable(false);
    }

    public void addState(String name, double initialWeight, double finalWeight, Object[] inputs, Object[] outputs, double[] weights, String[] destinationNames) {
        this.addState(name, initialWeight, finalWeight, this.inputAlphabet.lookupIndices(inputs, true), this.outputAlphabet.lookupIndices(outputs, true), weights, destinationNames);
    }

    @Override
    public int numStates() {
        return this.states.size();
    }

    @Override
    public Transducer.State getState(int index) {
        return this.states.get(index);
    }

    @Override
    public Iterator<State> initialStateIterator() {
        return this.initialStates.iterator();
    }

    public boolean isTrainable() {
        return this.trainable;
    }

    public void setTrainable(boolean f2) {
        this.trainable = f2;
        if (f2) {
            this.initialStateCounts = new Multinomial.LaplaceEstimator(this.states.size());
            this.finalStateCounts = new Multinomial.LaplaceEstimator(this.states.size());
        } else {
            this.initialStateCounts = null;
            this.finalStateCounts = null;
        }
        for (int i = 0; i < this.numStates(); ++i) {
            ((State)this.getState(i)).setTrainable(f2);
        }
    }

    public void reset() {
        if (this.trainable) {
            this.initialStateCounts.reset();
            this.finalStateCounts.reset();
            for (int i = 0; i < this.numStates(); ++i) {
                ((State)this.getState(i)).reset();
            }
        }
    }

    public void estimate() {
        if (this.initialStateCounts == null || this.finalStateCounts == null) {
            throw new IllegalStateException("This transducer not currently trainable.");
        }
        Multinomial initialStateDistribution = this.initialStateCounts.estimate();
        Multinomial finalStateDistribution = this.finalStateCounts.estimate();
        for (int i = 0; i < this.states.size(); ++i) {
            State s = this.states.get(i);
            s.initialWeight = initialStateDistribution.logProbability(i);
            s.finalWeight = finalStateDistribution.logProbability(i);
            s.estimate();
        }
    }

    protected class Transition {
        int input;
        int output;
        double weight;
        int index;
        String destinationName;
        State destination = null;
        Transition nextWithSameInput;

        public Transition(int input2, int output2, double weight, State sourceState, String destinationName) {
            this.input = input2;
            this.output = output2;
            this.weight = weight;
            this.nextWithSameInput = (Transition)sourceState.input2transitions.get(input2);
            sourceState.input2transitions.put(input2, this);
            this.destinationName = destinationName;
        }

        public State getDestinationState() {
            if (this.destination == null) {
                this.destination = FeatureTransducer.this.name2state.get(this.destinationName);
                assert (this.destination != null);
            }
            return this.destination;
        }
    }

    protected class TransitionIterator
    extends Transducer.TransitionIterator {
        int index;
        Transition transition;
        State source;
        int input;

        public TransitionIterator(State source) {
            this.source = source;
            this.input = -1;
            this.index = -1;
            this.transition = null;
        }

        public TransitionIterator(State source, int input2) {
            this.source = source;
            this.input = input2;
            this.index = -2;
            this.transition = (Transition)source.input2transitions.get(input2);
        }

        @Override
        public boolean hasNext() {
            if (this.index >= -1) {
                return this.index < this.source.transitions.length - 1;
            }
            return this.index == -2 ? this.transition != null : this.transition.nextWithSameInput != null;
        }

        @Override
        public Transducer.State nextState() {
            if (this.index >= -1) {
                this.transition = this.source.transitions[++this.index];
            } else if (this.index == -2) {
                this.index = -3;
            } else {
                this.transition = this.transition.nextWithSameInput;
            }
            return this.transition.getDestinationState();
        }

        @Override
        public int getIndex() {
            return this.index;
        }

        @Override
        public Object getInput() {
            return FeatureTransducer.this.inputAlphabet.lookupObject(this.transition.input);
        }

        @Override
        public Object getOutput() {
            return FeatureTransducer.this.outputAlphabet.lookupObject(this.transition.output);
        }

        @Override
        public double getWeight() {
            return this.transition.weight;
        }

        @Override
        public Transducer.State getSourceState() {
            return this.source;
        }

        @Override
        public Transducer.State getDestinationState() {
            return this.transition.getDestinationState();
        }

        public void incrementCount(double count2) {
            logger.info("FeatureTransducer incrementCount " + count2);
            this.source.transitionCounts.increment(this.transition.index, count2);
        }
    }

    public class State
    extends Transducer.State {
        String name;
        int index;
        double initialWeight;
        double finalWeight;
        Transition[] transitions;
        TIntObjectHashMap input2transitions;
        Multinomial.Estimator transitionCounts;
        FeatureTransducer transducer;
        private static final long serialVersionUID = 1L;

        protected State(String name, int index, double initialWeight, double finalWeight, int[] inputs, int[] outputs, double[] weights, String[] destinationNames, FeatureTransducer transducer) {
            assert (inputs.length == outputs.length && inputs.length == weights.length && inputs.length == destinationNames.length);
            this.transducer = transducer;
            this.name = name;
            this.index = index;
            this.initialWeight = initialWeight;
            this.finalWeight = finalWeight;
            this.transitions = new Transition[inputs.length];
            this.input2transitions = new TIntObjectHashMap();
            this.transitionCounts = null;
            for (int i = 0; i < inputs.length; ++i) {
                this.transitions[i] = new Transition(inputs[i], outputs[i], weights[i], this, destinationNames[i]);
                this.transitions[i].index = i;
            }
        }

        @Override
        public Transducer getTransducer() {
            return this.transducer;
        }

        @Override
        public double getInitialWeight() {
            return this.initialWeight;
        }

        @Override
        public double getFinalWeight() {
            return this.finalWeight;
        }

        @Override
        public void setInitialWeight(double v) {
            this.initialWeight = v;
        }

        @Override
        public void setFinalWeight(double v) {
            this.finalWeight = v;
        }

        private void setTrainable(boolean f2) {
            this.transitionCounts = f2 ? new Multinomial.LaplaceEstimator(this.transitions.length) : null;
        }

        public Multinomial.Estimator getTransitionEstimator() {
            return this.transitionCounts;
        }

        private void reset() {
            if (this.transitionCounts != null) {
                this.transitionCounts.reset();
            }
        }

        @Override
        public int getIndex() {
            return this.index;
        }

        @Override
        public Transducer.TransitionIterator transitionIterator(Sequence input2, int inputPosition, Sequence output2, int outputPosition) {
            if (inputPosition < 0 || outputPosition < 0 || output2 != null) {
                throw new UnsupportedOperationException("Not yet implemented.");
            }
            if (input2 == null) {
                return this.transitionIterator();
            }
            return this.transitionIterator(input2, inputPosition);
        }

        @Override
        public Transducer.TransitionIterator transitionIterator(Sequence inputSequence, int inputPosition) {
            int inputIndex = FeatureTransducer.this.inputAlphabet.lookupIndex(inputSequence.get(inputPosition), false);
            if (inputIndex == -1) {
                throw new IllegalArgumentException("Input not in dictionary.");
            }
            return this.transitionIterator(inputIndex);
        }

        public Transducer.TransitionIterator transitionIterator(Object o) {
            int inputIndex = FeatureTransducer.this.inputAlphabet.lookupIndex(o, false);
            if (inputIndex == -1) {
                throw new IllegalArgumentException("Input not in dictionary.");
            }
            return this.transitionIterator(inputIndex);
        }

        public Transducer.TransitionIterator transitionIterator(int input2) {
            return new TransitionIterator(this, input2);
        }

        @Override
        public Transducer.TransitionIterator transitionIterator() {
            return new TransitionIterator(this);
        }

        @Override
        public String getName() {
            return this.name;
        }

        public void incrementInitialCount(double count2) {
            if (FeatureTransducer.this.initialStateCounts == null) {
                throw new IllegalStateException("Transducer is not currently trainable.");
            }
            FeatureTransducer.this.initialStateCounts.increment(this.index, count2);
        }

        public void incrementFinalCount(double count2) {
            if (FeatureTransducer.this.finalStateCounts == null) {
                throw new IllegalStateException("Transducer is not currently trainable.");
            }
            FeatureTransducer.this.finalStateCounts.increment(this.index, count2);
        }

        private void estimate() {
            if (this.transitionCounts == null) {
                throw new IllegalStateException("Transducer is not currently trainable.");
            }
            Multinomial transitionDistribution = this.transitionCounts.estimate();
            for (int i = 0; i < this.transitions.length; ++i) {
                this.transitions[i].weight = transitionDistribution.logProbability(i);
            }
        }
    }
}

