/*
 * Decompiled with CFR 0.152.
 */
package cc.mallet.extract;

import cc.mallet.extract.Field;
import cc.mallet.extract.LabeledSpan;
import cc.mallet.extract.LabeledSpans;
import cc.mallet.types.Label;
import gnu.trove.THashMap;
import java.util.Iterator;

public class Record {
    private THashMap fieldMap;
    private String name;

    public Record(String name, LabeledSpans spans) {
        this.name = name;
        this.fieldMap = new THashMap();
        for (int i = 0; i < spans.size(); ++i) {
            LabeledSpan span2 = spans.getLabeledSpan(i);
            if (span2.isBackground()) continue;
            Label tag = span2.getLabel();
            Field field2 = (Field)this.fieldMap.get(tag);
            if (field2 == null) {
                field2 = new Field(span2);
                this.fieldMap.put(tag, field2);
                continue;
            }
            field2.addFiller(span2);
        }
    }

    public String getName() {
        return this.name;
    }

    public Field getField(Label name) {
        return (Field)this.fieldMap.get(name);
    }

    public Iterator fieldsIterator() {
        return this.fieldMap.values().iterator();
    }
}

