/*
 * Decompiled with CFR 0.152.
 */
package cc.mallet.extract;

import cc.mallet.extract.LabeledSpan;
import cc.mallet.extract.LabeledSpans;
import cc.mallet.extract.Span;
import cc.mallet.extract.StringSpan;
import cc.mallet.extract.Tokenization;
import cc.mallet.extract.TokenizationFilter;
import cc.mallet.types.Label;
import cc.mallet.types.LabelAlphabet;
import cc.mallet.types.Sequence;
import java.io.Serializable;

public class DefaultTokenizationFilter
implements TokenizationFilter,
Serializable {
    @Override
    public LabeledSpans constructLabeledSpans(LabelAlphabet dict, Object document2, Label backgroundTag, Tokenization input2, Sequence seq2) {
        LabeledSpans labeled = new LabeledSpans(document2);
        this.addSpansFromTags(labeled, input2, seq2, dict, backgroundTag);
        return labeled;
    }

    private void addSpansFromTags(LabeledSpans labeled, Tokenization input2, Sequence tags, LabelAlphabet dict, Label backgroundTag) {
        int i = 0;
        int docidx = 0;
        while (i < tags.size()) {
            Label nextTag;
            Label thisTag = dict.lookupLabel(tags.get(i).toString());
            int startTokenIdx = i;
            while (i < tags.size() && thisTag == (nextTag = dict.lookupLabel(tags.get(i).toString()))) {
                ++i;
            }
            int endTokenIdx = i;
            Span span2 = input2.subspan(startTokenIdx, endTokenIdx);
            this.addBackgroundIfNecessary(labeled, (StringSpan)span2, docidx, backgroundTag);
            docidx = ((StringSpan)span2).getEndIdx();
            labeled.add(new LabeledSpan(span2, thisTag, thisTag == backgroundTag));
        }
    }

    private void addBackgroundIfNecessary(LabeledSpans labeled, StringSpan span2, int docidx, Label background) {
        int nextIdx = span2.getStartIdx();
        if (docidx < nextIdx) {
            StringSpan newSpan = new StringSpan((CharSequence)span2.getDocument(), docidx, nextIdx);
            labeled.add(new LabeledSpan(newSpan, background, true));
        }
    }
}

