/*
 * Decompiled with CFR 0.152.
 */
package cc.mallet.cluster.util;

import cc.mallet.cluster.Clustering;
import cc.mallet.pipe.Noop;
import cc.mallet.types.Instance;
import cc.mallet.types.InstanceList;
import cc.mallet.util.Randoms;

public class ClusterUtils {
    public static InstanceList combineLists(InstanceList li, InstanceList lj) {
        int i;
        InstanceList newList = new InstanceList(li.getPipe());
        for (i = 0; i < li.size(); ++i) {
            newList.add((Instance)li.get(i));
        }
        for (i = 0; i < lj.size(); ++i) {
            newList.add((Instance)lj.get(i));
        }
        return newList;
    }

    public static Clustering mergeClusters(Clustering clustering, int labeli, int labelj) {
        int idx;
        int i;
        if (labeli == labelj) {
            return clustering;
        }
        InstanceList instances = clustering.getInstances();
        for (i = 0; i < instances.size(); ++i) {
            idx = clustering.getLabel(i);
            if (idx != labelj) continue;
            clustering.setLabel(i, labeli);
        }
        clustering.setNumLabels(clustering.getNumClusters() - 1);
        for (i = 0; i < instances.size(); ++i) {
            idx = clustering.getLabel(i);
            if (idx <= labelj) continue;
            clustering.setLabel(i, idx - 1);
        }
        return clustering;
    }

    public static Clustering mergeInstances(Clustering clustering, int[] instances) {
        for (int i = 0; i < instances.length; ++i) {
            for (int j = i + 1; j < instances.length; ++j) {
                int labeli = clustering.getLabel(instances[i]);
                int labelj = clustering.getLabel(instances[j]);
                clustering = ClusterUtils.mergeClusters(clustering, labeli, labelj);
            }
        }
        return clustering;
    }

    public static int[] getCombinedInstances(Clustering clustering, int i, int j) {
        int[] ci = clustering.getIndicesWithLabel(i);
        int[] cj = clustering.getIndicesWithLabel(j);
        int[] merged = new int[ci.length + cj.length];
        System.arraycopy(ci, 0, merged, 0, ci.length);
        System.arraycopy(cj, 0, merged, ci.length, cj.length);
        return merged;
    }

    public static Clustering mergeInstances(Clustering clustering, int i, int j) {
        return ClusterUtils.mergeInstances(clustering, new int[]{i, j});
    }

    public static Clustering createSingletonClustering(InstanceList instances) {
        int[] labels = new int[instances.size()];
        for (int i = 0; i < labels.length; ++i) {
            labels[i] = i;
        }
        return new Clustering(instances, labels.length, labels);
    }

    public static Clustering createRandomClustering(InstanceList instances, Randoms random) {
        Clustering clustering = ClusterUtils.createSingletonClustering(instances);
        int numMerges = 2 + random.nextInt(instances.size() - 2);
        for (int i = 0; i < numMerges; ++i) {
            clustering = ClusterUtils.mergeInstances(clustering, random.nextInt(instances.size()), random.nextInt(instances.size()));
        }
        return clustering;
    }

    public static Clustering shatterInstances(Clustering clustering, int[] indices) {
        for (int i = 0; i < indices.length - 1; ++i) {
            clustering.setLabel(indices[i], clustering.getNumClusters());
            clustering.setNumLabels(clustering.getNumClusters() + 1);
        }
        return clustering;
    }

    public static InstanceList makeList(Instance i, Instance j) {
        InstanceList list2 = new InstanceList(new Noop(i.getDataAlphabet(), i.getTargetAlphabet()));
        list2.add(i);
        list2.add(j);
        return list2;
    }

    public static Clustering copyWithNewLabels(Clustering clustering) {
        int[] oldLabels = clustering.getLabels();
        int[] newLabels = new int[oldLabels.length];
        System.arraycopy(oldLabels, 0, newLabels, 0, oldLabels.length);
        return new Clustering(clustering.getInstances(), clustering.getNumClusters(), newLabels);
    }

    public static Clustering mergeInstancesWithSameLabel(Clustering clustering) {
        InstanceList list2 = clustering.getInstances();
        for (int i = 0; i < list2.size(); ++i) {
            Instance ii = (Instance)list2.get(i);
            int li = clustering.getLabel(i);
            for (int j = i + 1; j < list2.size(); ++j) {
                Instance ij = (Instance)list2.get(j);
                int lj = clustering.getLabel(j);
                if (li == lj || !ii.getLabeling().equals(ij.getLabeling())) continue;
                clustering = ClusterUtils.mergeClusters(clustering, li, lj);
            }
        }
        return clustering;
    }

    public static Clustering copyAndMergeClusters(Clustering clustering, int i, int j) {
        return ClusterUtils.mergeClusters(ClusterUtils.copyWithNewLabels(clustering), i, j);
    }

    public static Clustering copyAndMergeInstances(Clustering clustering, int i, int j) {
        return ClusterUtils.copyAndMergeInstances(clustering, new int[]{i, j});
    }

    public static Clustering copyAndMergeInstances(Clustering clustering, int[] instances) {
        return ClusterUtils.mergeInstances(ClusterUtils.copyWithNewLabels(clustering), instances);
    }
}

