/*
 * Decompiled with CFR 0.152.
 */
package cc.mallet.cluster.evaluate;

import cc.mallet.cluster.Clustering;
import cc.mallet.cluster.evaluate.ClusteringEvaluator;
import cc.mallet.types.InstanceList;

public class BCubedEvaluator
extends ClusteringEvaluator {
    double macroPrecision = 0.0;
    double macroRecall = 0.0;
    int macroNumInstances = 0;

    @Override
    public String evaluate(Clustering truth, Clustering predicted) {
        double[] vals = this.getEvaluationScores(truth, predicted);
        return "pr=" + vals[0] + " re=" + vals[1] + " f1=" + vals[2];
    }

    @Override
    public String evaluateTotals() {
        double pr = this.macroPrecision / (double)this.macroNumInstances;
        double re = this.macroRecall / (double)this.macroNumInstances;
        double f1 = 2.0 * pr * re / (pr + re);
        return "pr=" + pr + " re=" + re + " f1=" + f1;
    }

    @Override
    public double[] getEvaluationScores(Clustering truth, Clustering predicted) {
        double precision = 0.0;
        double recall2 = 0.0;
        InstanceList instances = truth.getInstances();
        for (int i = 0; i < instances.size(); ++i) {
            int trueLabel = truth.getLabel(i);
            int predLabel = predicted.getLabel(i);
            int[] trueIndices = truth.getIndicesWithLabel(trueLabel);
            int[] predIndices = predicted.getIndicesWithLabel(predLabel);
            int correct = 0;
            for (int j = 0; j < predIndices.length; ++j) {
                for (int k = 0; k < trueIndices.length; ++k) {
                    if (trueIndices[k] != predIndices[j]) continue;
                    ++correct;
                }
            }
            precision += (double)correct / (double)predIndices.length;
            recall2 += (double)correct / (double)trueIndices.length;
        }
        this.macroPrecision += precision;
        this.macroRecall += recall2;
        this.macroNumInstances += instances.size();
        return new double[]{precision /= (double)instances.size(), recall2 /= (double)instances.size(), 2.0 * precision * recall2 / (precision + recall2)};
    }
}

