/*
 * Decompiled with CFR 0.152.
 */
package cc.mallet.cluster.clustering_scorer;

import cc.mallet.cluster.Clustering;
import cc.mallet.cluster.clustering_scorer.ClusteringScorer;
import cc.mallet.cluster.iterator.AllPairsIterator;
import cc.mallet.cluster.neighbor_evaluator.AgglomerativeNeighbor;
import cc.mallet.cluster.neighbor_evaluator.NeighborEvaluator;
import cc.mallet.cluster.util.ClusterUtils;
import cc.mallet.types.Instance;

public class PairwiseScorer
implements ClusteringScorer {
    NeighborEvaluator evaluator;

    public PairwiseScorer(NeighborEvaluator evaluator) {
        this.evaluator = evaluator;
    }

    @Override
    public double score(Clustering clustering) {
        Clustering singletons = ClusterUtils.createSingletonClustering(clustering.getInstances());
        double total = 0.0;
        int count2 = 0;
        AllPairsIterator iter2 = new AllPairsIterator(singletons);
        while (iter2.hasNext()) {
            Instance instance = iter2.next();
            AgglomerativeNeighbor neighbor = (AgglomerativeNeighbor)instance.getData();
            double score = this.evaluator.evaluate(neighbor);
            int[][] clusters = neighbor.getOldClusters();
            total = clustering.getLabel(clusters[0][0]) == clustering.getLabel(clusters[1][0]) ? (total += score) : (total += 1.0 - score);
            ++count2;
        }
        return total / (double)count2;
    }
}

