/*
 * Decompiled with CFR 0.152.
 */
package cc.mallet.classify;

import cc.mallet.classify.Classification;
import cc.mallet.classify.Classifier;
import cc.mallet.classify.constraints.pr.MaxEntPRConstraint;
import cc.mallet.pipe.Pipe;
import cc.mallet.types.FeatureVector;
import cc.mallet.types.Instance;
import cc.mallet.types.LabelVector;
import cc.mallet.types.MatrixOps;
import java.util.ArrayList;

public class PRAuxClassifier
extends Classifier {
    private static final long serialVersionUID = 1L;
    private int numLabels;
    private double[][] parameters;
    private ArrayList<MaxEntPRConstraint> constraints;

    public PRAuxClassifier(Pipe pipe, ArrayList<MaxEntPRConstraint> constraints) {
        super(pipe);
        this.constraints = constraints;
        this.parameters = new double[constraints.size()][];
        for (int i = 0; i < constraints.size(); ++i) {
            this.parameters[i] = new double[constraints.get(i).numDimensions()];
        }
        this.numLabels = pipe.getTargetAlphabet().size();
    }

    public void getClassificationScores(Instance instance, double[] scores) {
        FeatureVector input2 = (FeatureVector)instance.getData();
        for (MaxEntPRConstraint feature : this.constraints) {
            feature.preProcess(input2);
        }
        for (int li = 0; li < this.numLabels; ++li) {
            int ci = 0;
            for (MaxEntPRConstraint feature : this.constraints) {
                int n = li;
                scores[n] = scores[n] + feature.getScore(input2, li, this.parameters[ci]);
                ++ci;
            }
        }
    }

    public void getClassificationProbs(Instance instance, double[] scores) {
        this.getClassificationScores(instance, scores);
        MatrixOps.expNormalize(scores);
    }

    @Override
    public Classification classify(Instance instance) {
        double[] scores = new double[this.numLabels];
        this.getClassificationScores(instance, scores);
        return new Classification(instance, this, new LabelVector(this.getLabelAlphabet(), scores));
    }

    public double[][] getParameters() {
        return this.parameters;
    }

    public ArrayList<MaxEntPRConstraint> getConstraintFeatures() {
        return this.constraints;
    }

    public void zeroExpectations() {
        for (MaxEntPRConstraint constraint : this.constraints) {
            constraint.zeroExpectations();
        }
    }
}

