/*
 * Decompiled with CFR 0.152.
 */
package bsh.util;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.Socket;
import java.util.StringTokenizer;

class HttpdConnection
extends Thread {
    Socket client;
    BufferedReader in;
    OutputStream out;
    PrintStream pout;
    boolean isHttp1;

    HttpdConnection(Socket socket) {
        this.client = socket;
        this.setPriority(4);
    }

    public void run() {
        try {
            Object object;
            this.in = new BufferedReader(new InputStreamReader(this.client.getInputStream()));
            this.out = this.client.getOutputStream();
            this.pout = new PrintStream(this.out);
            String string2 = this.in.readLine();
            if (string2 == null) {
                this.error(400, "Empty Request");
            }
            if (string2.toLowerCase().indexOf("http/1.") != -1) {
                while (!((String)(object = this.in.readLine())).equals("") && object != null) {
                }
                this.isHttp1 = true;
            }
            if (((StringTokenizer)(object = new StringTokenizer(string2))).countTokens() < 2) {
                this.error(400, "Bad Request");
            } else {
                String string3 = ((StringTokenizer)object).nextToken();
                if (string3.equals("GET")) {
                    this.serveFile(((StringTokenizer)object).nextToken());
                } else {
                    this.error(400, "Bad Request");
                }
            }
            this.client.close();
        }
        catch (IOException iOException) {
            System.out.println("I/O error " + iOException);
            try {
                this.client.close();
            }
            catch (Exception exception) {}
        }
    }

    private void serveFile(String string2) throws FileNotFoundException, IOException {
        if (string2.equals("/")) {
            string2 = "/remote/remote.html";
        }
        if (string2.startsWith("/remote/")) {
            string2 = "/bsh/util/lib/" + string2.substring(8);
        }
        if (string2.startsWith("/java")) {
            this.error(404, "Object Not Found");
        } else {
            try {
                System.out.println("sending file: " + string2);
                this.sendFileData(string2);
            }
            catch (FileNotFoundException fileNotFoundException) {
                this.error(404, "Object Not Found");
            }
        }
    }

    private void sendFileData(String string2) throws IOException, FileNotFoundException {
        InputStream inputStream = this.getClass().getResourceAsStream(string2);
        if (inputStream == null) {
            throw new FileNotFoundException(string2);
        }
        byte[] byArray = new byte[inputStream.available()];
        if (this.isHttp1) {
            this.pout.println("HTTP/1.0 200 Document follows");
            this.pout.println("Content-length: " + byArray.length);
            if (string2.endsWith(".gif")) {
                this.pout.println("Content-type: image/gif");
            } else if (string2.endsWith(".html") || string2.endsWith(".htm")) {
                this.pout.println("Content-Type: text/html");
            } else {
                this.pout.println("Content-Type: application/octet-stream");
            }
            this.pout.println();
        }
        int n = 0;
        do {
            if ((n = inputStream.read(byArray)) <= 0) continue;
            this.pout.write(byArray, 0, n);
        } while (n != -1);
        this.pout.flush();
    }

    private void error(int n, String string2) {
        string2 = "<html><h1>" + string2 + "</h1></html>";
        if (this.isHttp1) {
            this.pout.println("HTTP/1.0 " + n + " " + string2);
            this.pout.println("Content-type: text/html");
            this.pout.println("Content-length: " + string2.length() + "\n");
        }
        this.pout.println(string2);
    }
}

