/*
 * Decompiled with CFR 0.152.
 */
package bsh.classpath;

import bsh.BshClassManager;
import bsh.ClassPathException;
import bsh.Interpreter;
import bsh.InterpreterError;
import bsh.UtilEvalError;
import bsh.classpath.BshClassLoader;
import bsh.classpath.BshClassPath;
import bsh.classpath.DiscreteFilesClassLoader;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.Vector;

public class ClassManagerImpl
extends BshClassManager {
    static final String BSH_PACKAGE = "bsh";
    private BshClassPath baseClassPath;
    private boolean superImport;
    private BshClassPath fullClassPath;
    private Vector listeners = new Vector();
    private ReferenceQueue refQueue = new ReferenceQueue();
    private BshClassLoader baseLoader;
    private Map loaderMap;
    static /* synthetic */ Class class$bsh$Interpreter;

    public ClassManagerImpl() {
        this.reset();
    }

    public Class classForName(String string2) {
        ClassLoader classLoader;
        Class<?> clazz = (Class<?>)this.absoluteClassCache.get(string2);
        if (clazz != null) {
            return clazz;
        }
        if (this.absoluteNonClasses.get(string2) != null) {
            if (Interpreter.DEBUG) {
                Interpreter.debug("absoluteNonClass list hit: " + string2);
            }
            return null;
        }
        if (Interpreter.DEBUG) {
            Interpreter.debug("Trying to load class: " + string2);
        }
        if ((classLoader = this.getLoaderForClass(string2)) != null) {
            try {
                clazz = classLoader.loadClass(string2);
            }
            catch (Exception exception) {
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
                throw BshClassManager.noClassDefFound(string2, noClassDefFoundError);
            }
        }
        if (clazz == null && string2.startsWith(BSH_PACKAGE)) {
            try {
                clazz = (class$bsh$Interpreter == null ? (class$bsh$Interpreter = ClassManagerImpl.class$("bsh.Interpreter")) : class$bsh$Interpreter).getClassLoader().loadClass(string2);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        if (clazz == null && this.baseLoader != null) {
            try {
                clazz = this.baseLoader.loadClass(string2);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        if (clazz == null && this.externalClassLoader != null) {
            try {
                clazz = this.externalClassLoader.loadClass(string2);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        if (clazz == null) {
            try {
                ClassLoader classLoader2 = Thread.currentThread().getContextClassLoader();
                if (classLoader2 != null) {
                    clazz = Class.forName(string2, true, classLoader2);
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
        }
        if (clazz == null) {
            try {
                clazz = this.plainClassForName(string2);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        if (clazz == null) {
            clazz = this.loadSourceClass(string2);
        }
        this.cacheClassInfo(string2, clazz);
        return clazz;
    }

    public URL getResource(String string2) {
        URL uRL = null;
        if (this.baseLoader != null) {
            uRL = this.baseLoader.getResource(string2.substring(1));
        }
        if (uRL == null) {
            uRL = super.getResource(string2);
        }
        return uRL;
    }

    public InputStream getResourceAsStream(String string2) {
        InputStream inputStream = null;
        if (this.baseLoader != null) {
            inputStream = this.baseLoader.getResourceAsStream(string2.substring(1));
        }
        if (inputStream == null) {
            inputStream = super.getResourceAsStream(string2);
        }
        return inputStream;
    }

    ClassLoader getLoaderForClass(String string2) {
        return (ClassLoader)this.loaderMap.get(string2);
    }

    public void addClassPath(URL uRL) throws IOException {
        if (this.baseLoader == null) {
            this.setClassPath(new URL[]{uRL});
        } else {
            this.baseLoader.addURL(uRL);
            this.baseClassPath.add(uRL);
            this.classLoaderChanged();
        }
    }

    public void reset() {
        this.baseClassPath = new BshClassPath("baseClassPath");
        this.baseLoader = null;
        this.loaderMap = new HashMap();
        this.classLoaderChanged();
    }

    public void setClassPath(URL[] uRLArray) {
        this.baseClassPath.setPath(uRLArray);
        this.initBaseLoader();
        this.loaderMap = new HashMap();
        this.classLoaderChanged();
    }

    public void reloadAllClasses() throws ClassPathException {
        BshClassPath bshClassPath = new BshClassPath("temp");
        bshClassPath.addComponent(this.baseClassPath);
        bshClassPath.addComponent(BshClassPath.getUserClassPath());
        this.setClassPath(bshClassPath.getPathComponents());
    }

    private void initBaseLoader() {
        this.baseLoader = new BshClassLoader((BshClassManager)this, this.baseClassPath);
    }

    public void reloadClasses(String[] stringArray) throws ClassPathException {
        Object object;
        Object object2;
        if (this.baseLoader == null) {
            this.initBaseLoader();
        }
        DiscreteFilesClassLoader.ClassSourceMap classSourceMap = new DiscreteFilesClassLoader.ClassSourceMap();
        int n = 0;
        while (n < stringArray.length) {
            object2 = stringArray[n];
            object = this.baseClassPath.getClassSource((String)object2);
            if (object == null) {
                BshClassPath.getUserClassPath().insureInitialized();
                object = BshClassPath.getUserClassPath().getClassSource((String)object2);
            }
            if (object == null) {
                throw new ClassPathException("Nothing known about class: " + (String)object2);
            }
            if (object instanceof BshClassPath.JarClassSource) {
                throw new ClassPathException("Cannot reload class: " + (String)object2 + " from source: " + object);
            }
            classSourceMap.put((String)object2, (BshClassPath.ClassSource)object);
            ++n;
        }
        object2 = new DiscreteFilesClassLoader((BshClassManager)this, classSourceMap);
        object = classSourceMap.keySet().iterator();
        while (object.hasNext()) {
            this.loaderMap.put((String)object.next(), object2);
        }
        this.classLoaderChanged();
    }

    public void reloadPackage(String string2) throws ClassPathException {
        Set set = this.baseClassPath.getClassesForPackage(string2);
        if (set == null) {
            set = BshClassPath.getUserClassPath().getClassesForPackage(string2);
        }
        if (set == null) {
            throw new ClassPathException("No classes found for package: " + string2);
        }
        this.reloadClasses(set.toArray(new String[0]));
    }

    public BshClassPath getClassPath() throws ClassPathException {
        if (this.fullClassPath != null) {
            return this.fullClassPath;
        }
        this.fullClassPath = new BshClassPath("BeanShell Full Class Path");
        this.fullClassPath.addComponent(BshClassPath.getUserClassPath());
        try {
            this.fullClassPath.addComponent(BshClassPath.getBootClassPath());
        }
        catch (ClassPathException classPathException) {
            System.err.println("Warning: can't get boot class path");
        }
        this.fullClassPath.addComponent(this.baseClassPath);
        return this.fullClassPath;
    }

    public void doSuperImport() throws UtilEvalError {
        try {
            this.getClassPath().insureInitialized();
            this.getClassNameByUnqName("");
        }
        catch (ClassPathException classPathException) {
            throw new UtilEvalError("Error importing classpath " + classPathException);
        }
        this.superImport = true;
    }

    protected boolean hasSuperImport() {
        return this.superImport;
    }

    public String getClassNameByUnqName(String string2) throws ClassPathException {
        return this.getClassPath().getClassNameByUnqName(string2);
    }

    public void addListener(BshClassManager.Listener listener) {
        Reference reference;
        this.listeners.addElement(new WeakReference<BshClassManager.Listener>(listener, this.refQueue));
        while ((reference = this.refQueue.poll()) != null) {
            boolean bl = this.listeners.removeElement(reference);
            if (bl || !Interpreter.DEBUG) continue;
            Interpreter.debug("tried to remove non-existent weak ref: " + reference);
        }
    }

    public void removeListener(BshClassManager.Listener listener) {
        throw new Error("unimplemented");
    }

    public ClassLoader getBaseLoader() {
        return this.baseLoader;
    }

    public Class defineClass(String string2, byte[] byArray) {
        this.baseClassPath.setClassSource(string2, new BshClassPath.GeneratedClassSource(byArray));
        try {
            this.reloadClasses(new String[]{string2});
        }
        catch (ClassPathException classPathException) {
            throw new InterpreterError("defineClass: " + classPathException);
        }
        return this.classForName(string2);
    }

    protected void classLoaderChanged() {
        Object object;
        this.clearCaches();
        Vector<Object> vector = new Vector<Object>();
        Enumeration enumeration = this.listeners.elements();
        while (enumeration.hasMoreElements()) {
            object = (WeakReference)enumeration.nextElement();
            BshClassManager.Listener listener = (BshClassManager.Listener)((Reference)object).get();
            if (listener == null) {
                vector.add(object);
                continue;
            }
            listener.classLoaderChanged();
        }
        object = vector.elements();
        while (object.hasMoreElements()) {
            this.listeners.removeElement(object.nextElement());
        }
    }

    public void dump(PrintWriter printWriter) {
        printWriter.println("Bsh Class Manager Dump: ");
        printWriter.println("----------------------- ");
        printWriter.println("baseLoader = " + this.baseLoader);
        printWriter.println("loaderMap= " + this.loaderMap);
        printWriter.println("----------------------- ");
        printWriter.println("baseClassPath = " + this.baseClassPath);
    }

    static /* synthetic */ Class class$(String string2) {
        try {
            return Class.forName(string2);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

