/*
 * Decompiled with CFR 0.152.
 */
package bsh;

import bsh.BshClassManager;
import bsh.CallStack;
import bsh.Capabilities;
import bsh.EvalError;
import bsh.Interpreter;
import bsh.InterpreterError;
import bsh.LHS;
import bsh.Primitive;
import bsh.ReflectError;
import bsh.ReflectManager;
import bsh.SimpleNode;
import bsh.StringUtil;
import bsh.This;
import bsh.Types;
import bsh.UtilEvalError;
import bsh.UtilTargetError;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Vector;

class Reflect {
    Reflect() {
    }

    public static Object invokeObjectMethod(Object object, String string2, Object[] objectArray, Interpreter interpreter, CallStack callStack, SimpleNode simpleNode) throws ReflectError, EvalError, InvocationTargetException {
        if (object instanceof This && !This.isExposedThisMethod(string2)) {
            return ((This)object).invokeMethod(string2, objectArray, interpreter, callStack, simpleNode, false);
        }
        try {
            BshClassManager bshClassManager = interpreter == null ? null : interpreter.getClassManager();
            Class<?> clazz = object.getClass();
            Method method = Reflect.resolveExpectedJavaMethod(bshClassManager, clazz, object, string2, objectArray, false);
            return Reflect.invokeMethod(method, object, objectArray);
        }
        catch (UtilEvalError utilEvalError) {
            throw utilEvalError.toEvalError(simpleNode, callStack);
        }
    }

    public static Object invokeStaticMethod(BshClassManager bshClassManager, Class clazz, String string2, Object[] objectArray) throws ReflectError, UtilEvalError, InvocationTargetException {
        Interpreter.debug("invoke static Method");
        Method method = Reflect.resolveExpectedJavaMethod(bshClassManager, clazz, null, string2, objectArray, true);
        return Reflect.invokeMethod(method, null, objectArray);
    }

    static Object invokeMethod(Method method, Object object, Object[] objectArray) throws ReflectError, InvocationTargetException {
        if (objectArray == null) {
            objectArray = new Object[]{};
        }
        Reflect.logInvokeMethod("Invoking method (entry): ", method, objectArray);
        Object[] objectArray2 = new Object[objectArray.length];
        Class<?>[] classArray = method.getParameterTypes();
        try {
            int n = 0;
            while (n < objectArray.length) {
                objectArray2[n] = Types.castObject(objectArray[n], classArray[n], 1);
                ++n;
            }
        }
        catch (UtilEvalError utilEvalError) {
            throw new InterpreterError("illegal argument type in method invocation: " + utilEvalError);
        }
        objectArray2 = Primitive.unwrap(objectArray2);
        Reflect.logInvokeMethod("Invoking method (after massaging values): ", method, objectArray2);
        try {
            Object object2 = method.invoke(object, objectArray2);
            if (object2 == null) {
                object2 = Primitive.NULL;
            }
            Class<?> clazz = method.getReturnType();
            return Primitive.wrap(object2, clazz);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new ReflectError("Cannot access method " + StringUtil.methodString(method.getName(), method.getParameterTypes()) + " in '" + method.getDeclaringClass() + "' :" + illegalAccessException);
        }
    }

    public static Object getIndex(Object object, int n) throws ReflectError, UtilTargetError {
        if (Interpreter.DEBUG) {
            Interpreter.debug("getIndex: " + object + ", index=" + n);
        }
        try {
            Object object2 = Array.get(object, n);
            return Primitive.wrap(object2, object.getClass().getComponentType());
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new UtilTargetError(arrayIndexOutOfBoundsException);
        }
        catch (Exception exception) {
            throw new ReflectError("Array access:" + exception);
        }
    }

    public static void setIndex(Object object, int n, Object object2) throws ReflectError, UtilTargetError {
        try {
            object2 = Primitive.unwrap(object2);
            Array.set(object, n, object2);
        }
        catch (ArrayStoreException arrayStoreException) {
            throw new UtilTargetError(arrayStoreException);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new UtilTargetError(new ArrayStoreException(illegalArgumentException.toString()));
        }
        catch (Exception exception) {
            throw new ReflectError("Array access:" + exception);
        }
    }

    public static Object getStaticFieldValue(Class clazz, String string2) throws UtilEvalError, ReflectError {
        return Reflect.getFieldValue(clazz, null, string2, true);
    }

    public static Object getObjectFieldValue(Object object, String string2) throws UtilEvalError, ReflectError {
        if (object instanceof This) {
            return ((This)object).namespace.getVariable(string2);
        }
        try {
            return Reflect.getFieldValue(object.getClass(), object, string2, false);
        }
        catch (ReflectError reflectError) {
            if (Reflect.hasObjectPropertyGetter(object.getClass(), string2)) {
                return Reflect.getObjectProperty(object, string2);
            }
            throw reflectError;
        }
    }

    static LHS getLHSStaticField(Class clazz, String string2) throws UtilEvalError, ReflectError {
        Field field2 = Reflect.resolveExpectedJavaField(clazz, string2, true);
        return new LHS(field2);
    }

    static LHS getLHSObjectField(Object object, String string2) throws UtilEvalError, ReflectError {
        if (object instanceof This) {
            boolean bl = false;
            return new LHS(((This)object).namespace, string2, bl);
        }
        try {
            Field field2 = Reflect.resolveExpectedJavaField(object.getClass(), string2, false);
            return new LHS(object, field2);
        }
        catch (ReflectError reflectError) {
            if (Reflect.hasObjectPropertySetter(object.getClass(), string2)) {
                return new LHS(object, string2);
            }
            throw reflectError;
        }
    }

    private static Object getFieldValue(Class clazz, Object object, String string2, boolean bl) throws UtilEvalError, ReflectError {
        try {
            Field field2 = Reflect.resolveExpectedJavaField(clazz, string2, bl);
            Object object2 = field2.get(object);
            Class<?> clazz2 = field2.getType();
            return Primitive.wrap(object2, clazz2);
        }
        catch (NullPointerException nullPointerException) {
            throw new ReflectError("???" + string2 + " is not a static field.");
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new ReflectError("Can't access field: " + string2);
        }
    }

    protected static Field resolveJavaField(Class clazz, String string2, boolean bl) throws UtilEvalError {
        try {
            return Reflect.resolveExpectedJavaField(clazz, string2, bl);
        }
        catch (ReflectError reflectError) {
            return null;
        }
    }

    protected static Field resolveExpectedJavaField(Class clazz, String string2, boolean bl) throws UtilEvalError, ReflectError {
        Field field2;
        try {
            field2 = Capabilities.haveAccessibility() ? Reflect.findAccessibleField(clazz, string2) : clazz.getField(string2);
        }
        catch (NoSuchFieldException noSuchFieldException) {
            throw new ReflectError("No such field: " + string2);
        }
        catch (SecurityException securityException) {
            throw new UtilTargetError("Security Exception while searching fields of: " + clazz, securityException);
        }
        if (bl && !Modifier.isStatic(field2.getModifiers())) {
            throw new UtilEvalError("Can't reach instance field: " + string2 + " from static context: " + clazz.getName());
        }
        return field2;
    }

    /*
     * Unable to fully structure code
     */
    private static Field findAccessibleField(Class var0, String var1_1) throws UtilEvalError, NoSuchFieldException {
        try {
            var2_2 = var0.getField(var1_1);
            ReflectManager.RMSetAccessible(var2_2);
            return var2_2;
        }
        catch (NoSuchFieldException var3_4) {
            ** while (var0 != null)
        }
lbl-1000:
        // 1 sources

        {
            try {
                var2_3 = var0.getDeclaredField(var1_1);
                ReflectManager.RMSetAccessible(var2_3);
                return var2_3;
            }
            catch (NoSuchFieldException var3_5) {
                var0 = var0.getSuperclass();
            }
            continue;
        }
lbl16:
        // 1 sources

        throw new NoSuchFieldException(var1_1);
    }

    protected static Method resolveExpectedJavaMethod(BshClassManager bshClassManager, Class clazz, Object object, String string2, Object[] objectArray, boolean bl) throws ReflectError, UtilEvalError {
        if (object == Primitive.NULL) {
            throw new UtilTargetError(new NullPointerException("Attempt to invoke method " + string2 + " on null value"));
        }
        Class[] classArray = Types.getTypes(objectArray);
        Method method = Reflect.resolveJavaMethod(bshClassManager, clazz, string2, classArray, bl);
        if (method == null) {
            throw new ReflectError((bl ? "Static method " : "Method ") + StringUtil.methodString(string2, classArray) + " not found in class'" + clazz.getName() + "'");
        }
        return method;
    }

    protected static Method resolveJavaMethod(BshClassManager bshClassManager, Class clazz, String string2, Class[] classArray, boolean bl) throws UtilEvalError {
        if (clazz == null) {
            throw new InterpreterError("null class");
        }
        Method method = null;
        if (bshClassManager == null) {
            Interpreter.debug("resolveJavaMethod UNOPTIMIZED lookup");
        } else {
            method = bshClassManager.getResolvedMethod(clazz, string2, classArray, bl);
        }
        if (method == null) {
            boolean bl2 = !Capabilities.haveAccessibility();
            try {
                method = Reflect.findOverloadedMethod(clazz, string2, classArray, bl2);
            }
            catch (SecurityException securityException) {
                throw new UtilTargetError("Security Exception while searching methods of: " + clazz, securityException);
            }
            Reflect.checkFoundStaticMethod(method, bl, clazz);
            if (method != null && !bl2) {
                try {
                    ReflectManager.RMSetAccessible(method);
                }
                catch (UtilEvalError utilEvalError) {
                    // empty catch block
                }
            }
            if (method != null && bshClassManager != null) {
                bshClassManager.cacheResolvedMethod(clazz, classArray, method);
            }
        }
        return method;
    }

    private static Method findOverloadedMethod(Class clazz, String string2, Class[] classArray, boolean bl) {
        if (Interpreter.DEBUG) {
            Interpreter.debug("Searching for method: " + StringUtil.methodString(string2, classArray) + " in '" + clazz.getName() + "'");
        }
        Method[] methodArray = Reflect.getCandidateMethods(clazz, string2, classArray.length, bl);
        if (Interpreter.DEBUG) {
            Interpreter.debug("Looking for most specific method: " + string2);
        }
        Method method = Reflect.findMostSpecificMethod(classArray, methodArray);
        return method;
    }

    static Method[] getCandidateMethods(Class clazz, String string2, int n, boolean bl) {
        Vector vector = Reflect.gatherMethodsRecursive(clazz, string2, n, bl, null);
        Object[] objectArray = new Method[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    private static Vector gatherMethodsRecursive(Class clazz, String string2, int n, boolean bl, Vector vector) {
        if (vector == null) {
            vector = new Vector();
        }
        if (bl) {
            if (Reflect.isPublic(clazz)) {
                Reflect.addCandidates(clazz.getMethods(), string2, n, bl, vector);
            }
        } else {
            Reflect.addCandidates(clazz.getDeclaredMethods(), string2, n, bl, vector);
        }
        Class<?>[] classArray = clazz.getInterfaces();
        int n2 = 0;
        while (n2 < classArray.length) {
            Reflect.gatherMethodsRecursive(classArray[n2], string2, n, bl, vector);
            ++n2;
        }
        Class clazz2 = clazz.getSuperclass();
        if (clazz2 != null) {
            Reflect.gatherMethodsRecursive(clazz2, string2, n, bl, vector);
        }
        return vector;
    }

    private static Vector addCandidates(Method[] methodArray, String string2, int n, boolean bl, Vector vector) {
        int n2 = 0;
        while (n2 < methodArray.length) {
            Method method = methodArray[n2];
            if (method.getName().equals(string2) && method.getParameterTypes().length == n && (!bl || Reflect.isPublic(method))) {
                vector.add(method);
            }
            ++n2;
        }
        return vector;
    }

    static Object constructObject(Class clazz, Object[] objectArray) throws ReflectError, InvocationTargetException {
        Constructor[] constructorArray;
        if (clazz.isInterface()) {
            throw new ReflectError("Can't create instance of an interface: " + clazz);
        }
        Object var2_2 = null;
        Class[] classArray = Types.getTypes(objectArray);
        Constructor constructor = null;
        Constructor[] constructorArray2 = constructorArray = Capabilities.haveAccessibility() ? clazz.getDeclaredConstructors() : clazz.getConstructors();
        if (Interpreter.DEBUG) {
            Interpreter.debug("Looking for most specific constructor: " + clazz);
        }
        if ((constructor = Reflect.findMostSpecificConstructor(classArray, constructorArray)) == null) {
            throw Reflect.cantFindConstructor(clazz, classArray);
        }
        if (!Reflect.isPublic(constructor)) {
            try {
                ReflectManager.RMSetAccessible(constructor);
            }
            catch (UtilEvalError utilEvalError) {
                // empty catch block
            }
        }
        objectArray = Primitive.unwrap(objectArray);
        try {
            var2_2 = constructor.newInstance(objectArray);
        }
        catch (InstantiationException instantiationException) {
            throw new ReflectError("The class " + clazz + " is abstract ");
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new ReflectError("We don't have permission to create an instance.Use setAccessibility(true) to enable access.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new ReflectError("The number of arguments was wrong");
        }
        if (var2_2 == null) {
            throw new ReflectError("Couldn't construct the object");
        }
        return var2_2;
    }

    static Constructor findMostSpecificConstructor(Class[] classArray, Constructor[] constructorArray) {
        int n = Reflect.findMostSpecificConstructorIndex(classArray, constructorArray);
        return n == -1 ? null : constructorArray[n];
    }

    static int findMostSpecificConstructorIndex(Class[] classArray, Constructor[] constructorArray) {
        Class[][] classArray2 = new Class[constructorArray.length][];
        int n = 0;
        while (n < classArray2.length) {
            classArray2[n] = constructorArray[n].getParameterTypes();
            ++n;
        }
        return Reflect.findMostSpecificSignature(classArray, classArray2);
    }

    static Method findMostSpecificMethod(Class[] classArray, Method[] methodArray) {
        Class[][] classArray2 = new Class[methodArray.length][];
        int n = 0;
        while (n < methodArray.length) {
            classArray2[n] = methodArray[n].getParameterTypes();
            ++n;
        }
        int n2 = Reflect.findMostSpecificSignature(classArray, classArray2);
        return n2 == -1 ? null : methodArray[n2];
    }

    static int findMostSpecificSignature(Class[] classArray, Class[][] classArray2) {
        int n = 1;
        while (n <= 4) {
            Class[] classArray3 = null;
            int n2 = -1;
            int n3 = 0;
            while (n3 < classArray2.length) {
                Class[] classArray4 = classArray2[n3];
                if (Types.isSignatureAssignable(classArray, classArray4, n) && (classArray3 == null || Types.isSignatureAssignable(classArray4, classArray3, 1))) {
                    classArray3 = classArray4;
                    n2 = n3;
                }
                ++n3;
            }
            if (classArray3 != null) {
                return n2;
            }
            ++n;
        }
        return -1;
    }

    private static String accessorName(String string2, String string3) {
        return string2 + String.valueOf(Character.toUpperCase(string3.charAt(0))) + string3.substring(1);
    }

    public static boolean hasObjectPropertyGetter(Class clazz, String string2) {
        String string3 = Reflect.accessorName("get", string2);
        try {
            clazz.getMethod(string3, new Class[0]);
            return true;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            string3 = Reflect.accessorName("is", string2);
            try {
                Method method = clazz.getMethod(string3, new Class[0]);
                return method.getReturnType() == Boolean.TYPE;
            }
            catch (NoSuchMethodException noSuchMethodException2) {
                return false;
            }
        }
    }

    public static boolean hasObjectPropertySetter(Class clazz, String string2) {
        String string3 = Reflect.accessorName("set", string2);
        Method[] methodArray = clazz.getMethods();
        int n = 0;
        while (n < methodArray.length) {
            if (methodArray[n].getName().equals(string3)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public static Object getObjectProperty(Object object, String string2) throws UtilEvalError, ReflectError {
        String string3;
        Object[] objectArray = new Object[]{};
        Interpreter.debug("property access: ");
        Method method = null;
        Exception exception = null;
        Exception exception2 = null;
        try {
            string3 = Reflect.accessorName("get", string2);
            method = Reflect.resolveExpectedJavaMethod(null, object.getClass(), object, string3, objectArray, false);
        }
        catch (Exception exception3) {
            exception = exception3;
        }
        if (method == null) {
            try {
                string3 = Reflect.accessorName("is", string2);
                method = Reflect.resolveExpectedJavaMethod(null, object.getClass(), object, string3, objectArray, false);
                if (method.getReturnType() != Boolean.TYPE) {
                    method = null;
                }
            }
            catch (Exception exception4) {
                exception2 = exception4;
            }
        }
        if (method == null) {
            throw new ReflectError("Error in property getter: " + exception + (exception2 != null ? " : " + exception2 : ""));
        }
        try {
            return Reflect.invokeMethod(method, object, objectArray);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new UtilEvalError("Property accessor threw exception: " + invocationTargetException.getTargetException());
        }
    }

    public static void setObjectProperty(Object object, String string2, Object object2) throws ReflectError, UtilEvalError {
        String string3 = Reflect.accessorName("set", string2);
        Object[] objectArray = new Object[]{object2};
        Interpreter.debug("property access: ");
        try {
            Method method = Reflect.resolveExpectedJavaMethod(null, object.getClass(), object, string3, objectArray, false);
            Reflect.invokeMethod(method, object, objectArray);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new UtilEvalError("Property accessor threw exception: " + invocationTargetException.getTargetException());
        }
    }

    public static String normalizeClassName(Class clazz) {
        if (!clazz.isArray()) {
            return clazz.getName();
        }
        StringBuffer stringBuffer = new StringBuffer();
        try {
            stringBuffer.append(Reflect.getArrayBaseType(clazz).getName() + " ");
            int n = 0;
            while (n < Reflect.getArrayDimensions(clazz)) {
                stringBuffer.append("[]");
                ++n;
            }
        }
        catch (ReflectError reflectError) {}
        return stringBuffer.toString();
    }

    public static int getArrayDimensions(Class clazz) {
        if (!clazz.isArray()) {
            return 0;
        }
        return clazz.getName().lastIndexOf(91) + 1;
    }

    public static Class getArrayBaseType(Class clazz) throws ReflectError {
        if (!clazz.isArray()) {
            throw new ReflectError("The class is not an array.");
        }
        return clazz.getComponentType();
    }

    public static Object invokeCompiledCommand(Class clazz, Object[] objectArray, Interpreter interpreter, CallStack callStack) throws UtilEvalError {
        Object[] objectArray2 = new Object[objectArray.length + 2];
        objectArray2[0] = interpreter;
        objectArray2[1] = callStack;
        System.arraycopy(objectArray, 0, objectArray2, 2, objectArray.length);
        BshClassManager bshClassManager = interpreter.getClassManager();
        try {
            return Reflect.invokeStaticMethod(bshClassManager, clazz, "invoke", objectArray2);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new UtilEvalError("Error in compiled command: " + invocationTargetException.getTargetException());
        }
        catch (ReflectError reflectError) {
            throw new UtilEvalError("Error invoking compiled command: " + reflectError);
        }
    }

    private static void logInvokeMethod(String string2, Method method, Object[] objectArray) {
        if (Interpreter.DEBUG) {
            Interpreter.debug(string2 + method + " with args:");
            int n = 0;
            while (n < objectArray.length) {
                Interpreter.debug("args[" + n + "] = " + objectArray[n] + " type = " + objectArray[n].getClass());
                ++n;
            }
        }
    }

    private static void checkFoundStaticMethod(Method method, boolean bl, Class clazz) throws UtilEvalError {
        if (method != null && bl && !Reflect.isStatic(method)) {
            throw new UtilEvalError("Cannot reach instance method: " + StringUtil.methodString(method.getName(), method.getParameterTypes()) + " from static context: " + clazz.getName());
        }
    }

    private static ReflectError cantFindConstructor(Class clazz, Class[] classArray) {
        if (classArray.length == 0) {
            return new ReflectError("Can't find default constructor for: " + clazz);
        }
        return new ReflectError("Can't find constructor: " + StringUtil.methodString(clazz.getName(), classArray) + " in class: " + clazz.getName());
    }

    private static boolean isPublic(Class clazz) {
        return Modifier.isPublic(clazz.getModifiers());
    }

    private static boolean isPublic(Method method) {
        return Modifier.isPublic(method.getModifiers());
    }

    private static boolean isPublic(Constructor constructor) {
        return Modifier.isPublic(constructor.getModifiers());
    }

    private static boolean isStatic(Method method) {
        return Modifier.isStatic(method.getModifiers());
    }
}

